/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentTargetsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<BatchGetDeploymentTargetsResponse.Builder, BatchGetDeploymentTargetsResponse> {
    private static final SdkField<List<DeploymentTarget>> DEPLOYMENT_TARGETS_FIELD = SdkField
            .<List<DeploymentTarget>> builder(MarshallingType.LIST)
            .memberName("deploymentTargets")
            .getter(getter(BatchGetDeploymentTargetsResponse::deploymentTargets))
            .setter(setter(Builder::deploymentTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TARGETS_FIELD));

    private final List<DeploymentTarget> deploymentTargets;

    private BatchGetDeploymentTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentTargets = builder.deploymentTargets;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeploymentTargets() {
        return deploymentTargets != null && !(deploymentTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of target objects for a deployment. Each target object contains details about the target, such as its
     * status and lifecycle events. The type of the target objects depends on the deployment' compute platform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: The target object is an Amazon ECS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentTargets} method.
     * </p>
     * 
     * @return A list of target objects for a deployment. Each target object contains details about the target, such as
     *         its status and lifecycle events. The type of the target objects depends on the deployment' compute
     *         platform. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon ECS</b>: The target object is an Amazon ECS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment.
     *         </p>
     *         </li>
     */
    public final List<DeploymentTarget> deploymentTargets() {
        return deploymentTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentTargets() ? deploymentTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentTargetsResponse)) {
            return false;
        }
        BatchGetDeploymentTargetsResponse other = (BatchGetDeploymentTargetsResponse) obj;
        return hasDeploymentTargets() == other.hasDeploymentTargets()
                && Objects.equals(deploymentTargets(), other.deploymentTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDeploymentTargetsResponse")
                .add("DeploymentTargets", hasDeploymentTargets() ? deploymentTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentTargets":
            return Optional.ofNullable(clazz.cast(deploymentTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentTargetsResponse, T> g) {
        return obj -> g.apply((BatchGetDeploymentTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetDeploymentTargetsResponse> {
        /**
         * <p>
         * A list of target objects for a deployment. Each target object contains details about the target, such as its
         * status and lifecycle events. The type of the target objects depends on the deployment' compute platform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon ECS</b>: The target object is an Amazon ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentTargets
         *        A list of target objects for a deployment. Each target object contains details about the target, such
         *        as its status and lifecycle events. The type of the target objects depends on the deployment' compute
         *        platform. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon ECS</b>: The target object is an Amazon ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentTargets(Collection<DeploymentTarget> deploymentTargets);

        /**
         * <p>
         * A list of target objects for a deployment. Each target object contains details about the target, such as its
         * status and lifecycle events. The type of the target objects depends on the deployment' compute platform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon ECS</b>: The target object is an Amazon ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentTargets
         *        A list of target objects for a deployment. Each target object contains details about the target, such
         *        as its status and lifecycle events. The type of the target objects depends on the deployment' compute
         *        platform. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon ECS</b>: The target object is an Amazon ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentTargets(DeploymentTarget... deploymentTargets);

        /**
         * <p>
         * A list of target objects for a deployment. Each target object contains details about the target, such as its
         * status and lifecycle events. The type of the target objects depends on the deployment' compute platform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>EC2/On-premises</b>: Each target object is an EC2 or on-premises instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AWS Lambda</b>: The target object is a specific version of an AWS Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon ECS</b>: The target object is an Amazon ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CloudFormation</b>: The target object is an AWS CloudFormation blue/green deployment.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link List<DeploymentTarget>.Builder} avoiding
         * the need to create one manually via {@link List<DeploymentTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentTargets(List<DeploymentTarget>)}.
         * 
         * @param deploymentTargets
         *        a consumer that will call methods on {@link List<DeploymentTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentTargets(List<DeploymentTarget>)
         */
        Builder deploymentTargets(Consumer<DeploymentTarget.Builder>... deploymentTargets);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<DeploymentTarget> deploymentTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentTargetsResponse model) {
            super(model);
            deploymentTargets(model.deploymentTargets);
        }

        public final List<DeploymentTarget.Builder> getDeploymentTargets() {
            List<DeploymentTarget.Builder> result = DeploymentTargetListCopier.copyToBuilder(this.deploymentTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentTargets(Collection<DeploymentTarget.BuilderImpl> deploymentTargets) {
            this.deploymentTargets = DeploymentTargetListCopier.copyFromBuilder(deploymentTargets);
        }

        @Override
        public final Builder deploymentTargets(Collection<DeploymentTarget> deploymentTargets) {
            this.deploymentTargets = DeploymentTargetListCopier.copy(deploymentTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentTargets(DeploymentTarget... deploymentTargets) {
            deploymentTargets(Arrays.asList(deploymentTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentTargets(Consumer<DeploymentTarget.Builder>... deploymentTargets) {
            deploymentTargets(Stream.of(deploymentTargets).map(c -> DeploymentTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetDeploymentTargetsResponse build() {
            return new BatchGetDeploymentTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
