/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment rollback.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollbackInfo implements SdkPojo, Serializable, ToCopyableBuilder<RollbackInfo.Builder, RollbackInfo> {
    private static final SdkField<String> ROLLBACK_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rollbackDeploymentId").getter(getter(RollbackInfo::rollbackDeploymentId))
            .setter(setter(Builder::rollbackDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackDeploymentId").build())
            .build();

    private static final SdkField<String> ROLLBACK_TRIGGERING_DEPLOYMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("rollbackTriggeringDeploymentId")
            .getter(getter(RollbackInfo::rollbackTriggeringDeploymentId))
            .setter(setter(Builder::rollbackTriggeringDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackTriggeringDeploymentId")
                    .build()).build();

    private static final SdkField<String> ROLLBACK_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rollbackMessage").getter(getter(RollbackInfo::rollbackMessage)).setter(setter(Builder::rollbackMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLBACK_DEPLOYMENT_ID_FIELD,
            ROLLBACK_TRIGGERING_DEPLOYMENT_ID_FIELD, ROLLBACK_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rollbackDeploymentId;

    private final String rollbackTriggeringDeploymentId;

    private final String rollbackMessage;

    private RollbackInfo(BuilderImpl builder) {
        this.rollbackDeploymentId = builder.rollbackDeploymentId;
        this.rollbackTriggeringDeploymentId = builder.rollbackTriggeringDeploymentId;
        this.rollbackMessage = builder.rollbackMessage;
    }

    /**
     * <p>
     * The ID of the deployment rollback.
     * </p>
     * 
     * @return The ID of the deployment rollback.
     */
    public final String rollbackDeploymentId() {
        return rollbackDeploymentId;
    }

    /**
     * <p>
     * The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or
     * was stopped.
     * </p>
     * 
     * @return The deployment ID of the deployment that was underway and triggered a rollback deployment because it
     *         failed or was stopped.
     */
    public final String rollbackTriggeringDeploymentId() {
        return rollbackTriggeringDeploymentId;
    }

    /**
     * <p>
     * Information that describes the status of a deployment rollback (for example, whether the deployment can't be
     * rolled back, is in progress, failed, or succeeded).
     * </p>
     * 
     * @return Information that describes the status of a deployment rollback (for example, whether the deployment can't
     *         be rolled back, is in progress, failed, or succeeded).
     */
    public final String rollbackMessage() {
        return rollbackMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollbackDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackTriggeringDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackInfo)) {
            return false;
        }
        RollbackInfo other = (RollbackInfo) obj;
        return Objects.equals(rollbackDeploymentId(), other.rollbackDeploymentId())
                && Objects.equals(rollbackTriggeringDeploymentId(), other.rollbackTriggeringDeploymentId())
                && Objects.equals(rollbackMessage(), other.rollbackMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollbackInfo").add("RollbackDeploymentId", rollbackDeploymentId())
                .add("RollbackTriggeringDeploymentId", rollbackTriggeringDeploymentId())
                .add("RollbackMessage", rollbackMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rollbackDeploymentId":
            return Optional.ofNullable(clazz.cast(rollbackDeploymentId()));
        case "rollbackTriggeringDeploymentId":
            return Optional.ofNullable(clazz.cast(rollbackTriggeringDeploymentId()));
        case "rollbackMessage":
            return Optional.ofNullable(clazz.cast(rollbackMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RollbackInfo, T> g) {
        return obj -> g.apply((RollbackInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RollbackInfo> {
        /**
         * <p>
         * The ID of the deployment rollback.
         * </p>
         * 
         * @param rollbackDeploymentId
         *        The ID of the deployment rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackDeploymentId(String rollbackDeploymentId);

        /**
         * <p>
         * The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed
         * or was stopped.
         * </p>
         * 
         * @param rollbackTriggeringDeploymentId
         *        The deployment ID of the deployment that was underway and triggered a rollback deployment because it
         *        failed or was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackTriggeringDeploymentId(String rollbackTriggeringDeploymentId);

        /**
         * <p>
         * Information that describes the status of a deployment rollback (for example, whether the deployment can't be
         * rolled back, is in progress, failed, or succeeded).
         * </p>
         * 
         * @param rollbackMessage
         *        Information that describes the status of a deployment rollback (for example, whether the deployment
         *        can't be rolled back, is in progress, failed, or succeeded).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackMessage(String rollbackMessage);
    }

    static final class BuilderImpl implements Builder {
        private String rollbackDeploymentId;

        private String rollbackTriggeringDeploymentId;

        private String rollbackMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackInfo model) {
            rollbackDeploymentId(model.rollbackDeploymentId);
            rollbackTriggeringDeploymentId(model.rollbackTriggeringDeploymentId);
            rollbackMessage(model.rollbackMessage);
        }

        public final String getRollbackDeploymentId() {
            return rollbackDeploymentId;
        }

        public final void setRollbackDeploymentId(String rollbackDeploymentId) {
            this.rollbackDeploymentId = rollbackDeploymentId;
        }

        @Override
        @Transient
        public final Builder rollbackDeploymentId(String rollbackDeploymentId) {
            this.rollbackDeploymentId = rollbackDeploymentId;
            return this;
        }

        public final String getRollbackTriggeringDeploymentId() {
            return rollbackTriggeringDeploymentId;
        }

        public final void setRollbackTriggeringDeploymentId(String rollbackTriggeringDeploymentId) {
            this.rollbackTriggeringDeploymentId = rollbackTriggeringDeploymentId;
        }

        @Override
        @Transient
        public final Builder rollbackTriggeringDeploymentId(String rollbackTriggeringDeploymentId) {
            this.rollbackTriggeringDeploymentId = rollbackTriggeringDeploymentId;
            return this;
        }

        public final String getRollbackMessage() {
            return rollbackMessage;
        }

        public final void setRollbackMessage(String rollbackMessage) {
            this.rollbackMessage = rollbackMessage;
        }

        @Override
        @Transient
        public final Builder rollbackMessage(String rollbackMessage) {
            this.rollbackMessage = rollbackMessage;
            return this;
        }

        @Override
        public RollbackInfo build() {
            return new RollbackInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
