/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of the register on-premises instance operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterOnPremisesInstanceRequest extends CodeDeployRequest implements
        ToCopyableBuilder<RegisterOnPremisesInstanceRequest.Builder, RegisterOnPremisesInstanceRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceName").getter(getter(RegisterOnPremisesInstanceRequest::instanceName))
            .setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final SdkField<String> IAM_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamSessionArn").getter(getter(RegisterOnPremisesInstanceRequest::iamSessionArn))
            .setter(setter(Builder::iamSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamSessionArn").build()).build();

    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamUserArn").getter(getter(RegisterOnPremisesInstanceRequest::iamUserArn))
            .setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUserArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD,
            IAM_SESSION_ARN_FIELD, IAM_USER_ARN_FIELD));

    private final String instanceName;

    private final String iamSessionArn;

    private final String iamUserArn;

    private RegisterOnPremisesInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
    }

    /**
     * <p>
     * The name of the on-premises instance to register.
     * </p>
     * 
     * @return The name of the on-premises instance to register.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The ARN of the IAM session to associate with the on-premises instance.
     * </p>
     * 
     * @return The ARN of the IAM session to associate with the on-premises instance.
     */
    public final String iamSessionArn() {
        return iamSessionArn;
    }

    /**
     * <p>
     * The ARN of the IAM user to associate with the on-premises instance.
     * </p>
     * 
     * @return The ARN of the IAM user to associate with the on-premises instance.
     */
    public final String iamUserArn() {
        return iamUserArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterOnPremisesInstanceRequest)) {
            return false;
        }
        RegisterOnPremisesInstanceRequest other = (RegisterOnPremisesInstanceRequest) obj;
        return Objects.equals(instanceName(), other.instanceName()) && Objects.equals(iamSessionArn(), other.iamSessionArn())
                && Objects.equals(iamUserArn(), other.iamUserArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterOnPremisesInstanceRequest").add("InstanceName", instanceName())
                .add("IamSessionArn", iamSessionArn()).add("IamUserArn", iamUserArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "iamSessionArn":
            return Optional.ofNullable(clazz.cast(iamSessionArn()));
        case "iamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterOnPremisesInstanceRequest, T> g) {
        return obj -> g.apply((RegisterOnPremisesInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
        /**
         * <p>
         * The name of the on-premises instance to register.
         * </p>
         * 
         * @param instanceName
         *        The name of the on-premises instance to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The ARN of the IAM session to associate with the on-premises instance.
         * </p>
         * 
         * @param iamSessionArn
         *        The ARN of the IAM session to associate with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamSessionArn(String iamSessionArn);

        /**
         * <p>
         * The ARN of the IAM user to associate with the on-premises instance.
         * </p>
         * 
         * @param iamUserArn
         *        The ARN of the IAM user to associate with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String instanceName;

        private String iamSessionArn;

        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterOnPremisesInstanceRequest model) {
            super(model);
            instanceName(model.instanceName);
            iamSessionArn(model.iamSessionArn);
            iamUserArn(model.iamUserArn);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        @Transient
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getIamSessionArn() {
            return iamSessionArn;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        @Override
        @Transient
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        @Transient
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterOnPremisesInstanceRequest build() {
            return new RegisterOnPremisesInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
