/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingGroup.Builder, AutoScalingGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AutoScalingGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> HOOK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("hook")
            .getter(getter(AutoScalingGroup::hook)).setter(setter(Builder::hook))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hook").build()).build();

    private static final SdkField<String> TERMINATION_HOOK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("terminationHook").getter(getter(AutoScalingGroup::terminationHook))
            .setter(setter(Builder::terminationHook))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminationHook").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOOK_FIELD,
            TERMINATION_HOOK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String hook;

    private final String terminationHook;

    private AutoScalingGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.hook = builder.hook;
        this.terminationHook = builder.terminationHook;
    }

    /**
     * <p>
     * The Auto Scaling group name.
     * </p>
     * 
     * @return The Auto Scaling group name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the launch hook that CodeDeploy installed into the Auto Scaling group.
     * </p>
     * <p>
     * For more information about the launch hook, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors"
     * >How Amazon EC2 Auto Scaling works with CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return The name of the launch hook that CodeDeploy installed into the Auto Scaling group.</p>
     *         <p>
     *         For more information about the launch hook, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors"
     *         >How Amazon EC2 Auto Scaling works with CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.
     */
    public final String hook() {
        return hook;
    }

    /**
     * <p>
     * The name of the termination hook that CodeDeploy installed into the Auto Scaling group.
     * </p>
     * <p>
     * For more information about the termination hook, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
     * >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return The name of the termination hook that CodeDeploy installed into the Auto Scaling group.</p>
     *         <p>
     *         For more information about the termination hook, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
     *         >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User
     *         Guide</i>.
     */
    public final String terminationHook() {
        return terminationHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hook());
        hashCode = 31 * hashCode + Objects.hashCode(terminationHook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(hook(), other.hook())
                && Objects.equals(terminationHook(), other.terminationHook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingGroup").add("Name", name()).add("Hook", hook())
                .add("TerminationHook", terminationHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "hook":
            return Optional.ofNullable(clazz.cast(hook()));
        case "terminationHook":
            return Optional.ofNullable(clazz.cast(terminationHook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroup, T> g) {
        return obj -> g.apply((AutoScalingGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingGroup> {
        /**
         * <p>
         * The Auto Scaling group name.
         * </p>
         * 
         * @param name
         *        The Auto Scaling group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the launch hook that CodeDeploy installed into the Auto Scaling group.
         * </p>
         * <p>
         * For more information about the launch hook, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors"
         * >How Amazon EC2 Auto Scaling works with CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param hook
         *        The name of the launch hook that CodeDeploy installed into the Auto Scaling group.</p>
         *        <p>
         *        For more information about the launch hook, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors"
         *        >How Amazon EC2 Auto Scaling works with CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hook(String hook);

        /**
         * <p>
         * The name of the termination hook that CodeDeploy installed into the Auto Scaling group.
         * </p>
         * <p>
         * For more information about the termination hook, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
         * >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User
         * Guide</i>.
         * </p>
         * 
         * @param terminationHook
         *        The name of the termination hook that CodeDeploy installed into the Auto Scaling group.</p>
         *        <p>
         *        For more information about the termination hook, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
         *        >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationHook(String terminationHook);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String hook;

        private String terminationHook;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            name(model.name);
            hook(model.hook);
            terminationHook(model.terminationHook);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getHook() {
            return hook;
        }

        public final void setHook(String hook) {
            this.hook = hook;
        }

        @Override
        public final Builder hook(String hook) {
            this.hook = hook;
            return this;
        }

        public final String getTerminationHook() {
            return terminationHook;
        }

        public final void setTerminationHook(String terminationHook) {
            this.terminationHook = terminationHook;
        }

        @Override
        public final Builder terminationHook(String terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        @Override
        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
