/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentGroupInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentGroupInfo.Builder, DeploymentGroupInfo> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentGroupInfo::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentGroupInfo::deploymentGroupId)).setter(setter(Builder::deploymentGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupId").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentGroupInfo::deploymentGroupName)).setter(setter(Builder::deploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentGroupInfo::deploymentConfigName)).setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<List<EC2TagFilter>> EC2_TAG_FILTERS_FIELD = SdkField
            .<List<EC2TagFilter>> builder(MarshallingType.LIST)
            .getter(getter(DeploymentGroupInfo::ec2TagFilters))
            .setter(setter(Builder::ec2TagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagFilter>> ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .getter(getter(DeploymentGroupInfo::onPremisesInstanceTagFilters))
            .setter(setter(Builder::onPremisesInstanceTagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesInstanceTagFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutoScalingGroup>> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<List<AutoScalingGroup>> builder(MarshallingType.LIST)
            .getter(getter(DeploymentGroupInfo::autoScalingGroups))
            .setter(setter(Builder::autoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoScalingGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoScalingGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentGroupInfo::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()).build();

    private static final SdkField<RevisionLocation> TARGET_REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentGroupInfo::targetRevision))
            .setter(setter(Builder::targetRevision)).constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRevision").build()).build();

    private static final SdkField<List<TriggerConfig>> TRIGGER_CONFIGURATIONS_FIELD = SdkField
            .<List<TriggerConfig>> builder(MarshallingType.LIST)
            .getter(getter(DeploymentGroupInfo::triggerConfigurations))
            .setter(setter(Builder::triggerConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TriggerConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(TriggerConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentGroupInfo::alarmConfiguration))
            .setter(setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmConfiguration").build())
            .build();

    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeploymentGroupInfo::autoRollbackConfiguration)).setter(setter(Builder::autoRollbackConfiguration))
            .constructor(AutoRollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build())
            .build();

    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField
            .<DeploymentStyle> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentGroupInfo::deploymentStyle))
            .setter(setter(Builder::deploymentStyle)).constructor(DeploymentStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()).build();

    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<BlueGreenDeploymentConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeploymentGroupInfo::blueGreenDeploymentConfiguration))
            .setter(setter(Builder::blueGreenDeploymentConfiguration))
            .constructor(BlueGreenDeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration")
                    .build()).build();

    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField
            .<LoadBalancerInfo> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentGroupInfo::loadBalancerInfo))
            .setter(setter(Builder::loadBalancerInfo)).constructor(LoadBalancerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()).build();

    private static final SdkField<LastDeploymentInfo> LAST_SUCCESSFUL_DEPLOYMENT_FIELD = SdkField
            .<LastDeploymentInfo> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentGroupInfo::lastSuccessfulDeployment))
            .setter(setter(Builder::lastSuccessfulDeployment)).constructor(LastDeploymentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulDeployment").build())
            .build();

    private static final SdkField<LastDeploymentInfo> LAST_ATTEMPTED_DEPLOYMENT_FIELD = SdkField
            .<LastDeploymentInfo> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentGroupInfo::lastAttemptedDeployment))
            .setter(setter(Builder::lastAttemptedDeployment)).constructor(LastDeploymentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeployment").build())
            .build();

    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.<EC2TagSet> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeploymentGroupInfo::ec2TagSet)).setter(setter(Builder::ec2TagSet)).constructor(EC2TagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()).build();

    private static final SdkField<OnPremisesTagSet> ON_PREMISES_TAG_SET_FIELD = SdkField
            .<OnPremisesTagSet> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentGroupInfo::onPremisesTagSet))
            .setter(setter(Builder::onPremisesTagSet)).constructor(OnPremisesTagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesTagSet").build()).build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentGroupInfo::computePlatformAsString)).setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<List<ECSService>> ECS_SERVICES_FIELD = SdkField
            .<List<ECSService>> builder(MarshallingType.LIST)
            .getter(getter(DeploymentGroupInfo::ecsServices))
            .setter(setter(Builder::ecsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ECSService> builder(MarshallingType.SDK_POJO)
                                            .constructor(ECSService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DEPLOYMENT_GROUP_ID_FIELD, DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, EC2_TAG_FILTERS_FIELD,
            ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD, AUTO_SCALING_GROUPS_FIELD, SERVICE_ROLE_ARN_FIELD, TARGET_REVISION_FIELD,
            TRIGGER_CONFIGURATIONS_FIELD, ALARM_CONFIGURATION_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD, DEPLOYMENT_STYLE_FIELD,
            BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD, LOAD_BALANCER_INFO_FIELD, LAST_SUCCESSFUL_DEPLOYMENT_FIELD,
            LAST_ATTEMPTED_DEPLOYMENT_FIELD, EC2_TAG_SET_FIELD, ON_PREMISES_TAG_SET_FIELD, COMPUTE_PLATFORM_FIELD,
            ECS_SERVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationName;

    private final String deploymentGroupId;

    private final String deploymentGroupName;

    private final String deploymentConfigName;

    private final List<EC2TagFilter> ec2TagFilters;

    private final List<TagFilter> onPremisesInstanceTagFilters;

    private final List<AutoScalingGroup> autoScalingGroups;

    private final String serviceRoleArn;

    private final RevisionLocation targetRevision;

    private final List<TriggerConfig> triggerConfigurations;

    private final AlarmConfiguration alarmConfiguration;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final DeploymentStyle deploymentStyle;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private final LastDeploymentInfo lastSuccessfulDeployment;

    private final LastDeploymentInfo lastAttemptedDeployment;

    private final EC2TagSet ec2TagSet;

    private final OnPremisesTagSet onPremisesTagSet;

    private final String computePlatform;

    private final List<ECSService> ecsServices;

    private DeploymentGroupInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupId = builder.deploymentGroupId;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.targetRevision = builder.targetRevision;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.lastSuccessfulDeployment = builder.lastSuccessfulDeployment;
        this.lastAttemptedDeployment = builder.lastAttemptedDeployment;
        this.ec2TagSet = builder.ec2TagSet;
        this.onPremisesTagSet = builder.onPremisesTagSet;
        this.computePlatform = builder.computePlatform;
        this.ecsServices = builder.ecsServices;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The deployment group ID.
     * </p>
     * 
     * @return The deployment group ID.
     */
    public String deploymentGroupId() {
        return deploymentGroupId;
    }

    /**
     * <p>
     * The deployment group name.
     * </p>
     * 
     * @return The deployment group name.
     */
    public String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The deployment configuration name.
     * </p>
     * 
     * @return The deployment configuration name.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
     * tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the
     *         specified tags.
     */
    public List<EC2TagFilter> ec2TagFilters() {
        return ec2TagFilters;
    }

    /**
     * <p>
     * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of
     * the specified tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The on-premises instance tags on which to filter. The deployment group includes on-premises instances
     *         with any of the specified tags.
     */
    public List<TagFilter> onPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters;
    }

    /**
     * <p>
     * A list of associated Auto Scaling groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of associated Auto Scaling groups.
     */
    public List<AutoScalingGroup> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * A service role ARN.
     * </p>
     * 
     * @return A service role ARN.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Information about the deployment group's target revision, including type and location.
     * </p>
     * 
     * @return Information about the deployment group's target revision, including type and location.
     */
    public RevisionLocation targetRevision() {
        return targetRevision;
    }

    /**
     * <p>
     * Information about triggers associated with the deployment group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about triggers associated with the deployment group.
     */
    public List<TriggerConfig> triggerConfigurations() {
        return triggerConfigurations;
    }

    /**
     * <p>
     * A list of alarms associated with the deployment group.
     * </p>
     * 
     * @return A list of alarms associated with the deployment group.
     */
    public AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    /**
     * <p>
     * Information about the automatic rollback configuration associated with the deployment group.
     * </p>
     * 
     * @return Information about the automatic rollback configuration associated with the deployment group.
     */
    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Information about blue/green deployment options for a deployment group.
     * </p>
     * 
     * @return Information about blue/green deployment options for a deployment group.
     */
    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer to use in a deployment.
     * </p>
     * 
     * @return Information about the load balancer to use in a deployment.
     */
    public LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    /**
     * <p>
     * Information about the most recent successful deployment to the deployment group.
     * </p>
     * 
     * @return Information about the most recent successful deployment to the deployment group.
     */
    public LastDeploymentInfo lastSuccessfulDeployment() {
        return lastSuccessfulDeployment;
    }

    /**
     * <p>
     * Information about the most recent attempted deployment to the deployment group.
     * </p>
     * 
     * @return Information about the most recent attempted deployment to the deployment group.
     */
    public LastDeploymentInfo lastAttemptedDeployment() {
        return lastAttemptedDeployment;
    }

    /**
     * <p>
     * Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances
     * identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
     * </p>
     * 
     * @return Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2
     *         instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
     */
    public EC2TagSet ec2TagSet() {
        return ec2TagSet;
    }

    /**
     * <p>
     * Information about groups of tags applied to an on-premises instance. The deployment group includes only
     * on-premises instances identified by all the tag groups. Cannot be used in the same call as
     * onPremisesInstanceTagFilters.
     * </p>
     * 
     * @return Information about groups of tags applied to an on-premises instance. The deployment group includes only
     *         on-premises instances identified by all the tag groups. Cannot be used in the same call as
     *         onPremisesInstanceTagFilters.
     */
    public OnPremisesTagSet onPremisesTagSet() {
        return onPremisesTagSet;
    }

    /**
     * <p>
     * The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
     * @see ComputePlatform
     */
    public ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
     * @see ComputePlatform
     */
    public String computePlatformAsString() {
        return computePlatform;
    }

    /**
     * <p>
     * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
     * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name
     * pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The target Amazon ECS services in the deployment group. This applies only to deployment groups that use
     *         the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and
     *         service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     */
    public List<ECSService> ecsServices() {
        return ecsServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(onPremisesInstanceTagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(triggerConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptedDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagSet());
        hashCode = 31 * hashCode + Objects.hashCode(onPremisesTagSet());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ecsServices());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(deploymentGroupId(), other.deploymentGroupId())
                && Objects.equals(deploymentGroupName(), other.deploymentGroupName())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(ec2TagFilters(), other.ec2TagFilters())
                && Objects.equals(onPremisesInstanceTagFilters(), other.onPremisesInstanceTagFilters())
                && Objects.equals(autoScalingGroups(), other.autoScalingGroups())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(targetRevision(), other.targetRevision())
                && Objects.equals(triggerConfigurations(), other.triggerConfigurations())
                && Objects.equals(alarmConfiguration(), other.alarmConfiguration())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration())
                && Objects.equals(deploymentStyle(), other.deploymentStyle())
                && Objects.equals(blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration())
                && Objects.equals(loadBalancerInfo(), other.loadBalancerInfo())
                && Objects.equals(lastSuccessfulDeployment(), other.lastSuccessfulDeployment())
                && Objects.equals(lastAttemptedDeployment(), other.lastAttemptedDeployment())
                && Objects.equals(ec2TagSet(), other.ec2TagSet()) && Objects.equals(onPremisesTagSet(), other.onPremisesTagSet())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString())
                && Objects.equals(ecsServices(), other.ecsServices());
    }

    @Override
    public String toString() {
        return ToString.builder("DeploymentGroupInfo").add("ApplicationName", applicationName())
                .add("DeploymentGroupId", deploymentGroupId()).add("DeploymentGroupName", deploymentGroupName())
                .add("DeploymentConfigName", deploymentConfigName()).add("Ec2TagFilters", ec2TagFilters())
                .add("OnPremisesInstanceTagFilters", onPremisesInstanceTagFilters())
                .add("AutoScalingGroups", autoScalingGroups()).add("ServiceRoleArn", serviceRoleArn())
                .add("TargetRevision", targetRevision()).add("TriggerConfigurations", triggerConfigurations())
                .add("AlarmConfiguration", alarmConfiguration()).add("AutoRollbackConfiguration", autoRollbackConfiguration())
                .add("DeploymentStyle", deploymentStyle())
                .add("BlueGreenDeploymentConfiguration", blueGreenDeploymentConfiguration())
                .add("LoadBalancerInfo", loadBalancerInfo()).add("LastSuccessfulDeployment", lastSuccessfulDeployment())
                .add("LastAttemptedDeployment", lastAttemptedDeployment()).add("Ec2TagSet", ec2TagSet())
                .add("OnPremisesTagSet", onPremisesTagSet()).add("ComputePlatform", computePlatformAsString())
                .add("EcsServices", ecsServices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "deploymentGroupId":
            return Optional.ofNullable(clazz.cast(deploymentGroupId()));
        case "deploymentGroupName":
            return Optional.ofNullable(clazz.cast(deploymentGroupName()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "ec2TagFilters":
            return Optional.ofNullable(clazz.cast(ec2TagFilters()));
        case "onPremisesInstanceTagFilters":
            return Optional.ofNullable(clazz.cast(onPremisesInstanceTagFilters()));
        case "autoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "serviceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "targetRevision":
            return Optional.ofNullable(clazz.cast(targetRevision()));
        case "triggerConfigurations":
            return Optional.ofNullable(clazz.cast(triggerConfigurations()));
        case "alarmConfiguration":
            return Optional.ofNullable(clazz.cast(alarmConfiguration()));
        case "autoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        case "deploymentStyle":
            return Optional.ofNullable(clazz.cast(deploymentStyle()));
        case "blueGreenDeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentConfiguration()));
        case "loadBalancerInfo":
            return Optional.ofNullable(clazz.cast(loadBalancerInfo()));
        case "lastSuccessfulDeployment":
            return Optional.ofNullable(clazz.cast(lastSuccessfulDeployment()));
        case "lastAttemptedDeployment":
            return Optional.ofNullable(clazz.cast(lastAttemptedDeployment()));
        case "ec2TagSet":
            return Optional.ofNullable(clazz.cast(ec2TagSet()));
        case "onPremisesTagSet":
            return Optional.ofNullable(clazz.cast(onPremisesTagSet()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        case "ecsServices":
            return Optional.ofNullable(clazz.cast(ecsServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentGroupInfo, T> g) {
        return obj -> g.apply((DeploymentGroupInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentGroupInfo> {
        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The deployment group ID.
         * </p>
         * 
         * @param deploymentGroupId
         *        The deployment group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupId(String deploymentGroupId);

        /**
         * <p>
         * The deployment group name.
         * </p>
         * 
         * @param deploymentGroupName
         *        The deployment group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The deployment configuration name.
         * </p>
         * 
         * @param deploymentConfigName
         *        The deployment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
         * tags.
         * </p>
         * 
         * @param ec2TagFilters
         *        The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the
         *        specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
         * tags.
         * </p>
         * 
         * @param ec2TagFilters
         *        The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the
         *        specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(EC2TagFilter... ec2TagFilters);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
         * tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EC2TagFilter>.Builder} avoiding the need to
         * create one manually via {@link List<EC2TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EC2TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2TagFilters(List<EC2TagFilter>)}.
         * 
         * @param ec2TagFilters
         *        a consumer that will call methods on {@link List<EC2TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagFilters(List<EC2TagFilter>)
         */
        Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with
         * any of the specified tags.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The on-premises instance tags on which to filter. The deployment group includes on-premises instances
         *        with any of the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with
         * any of the specified tags.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The on-premises instance tags on which to filter. The deployment group includes on-premises instances
         *        with any of the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with
         * any of the specified tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagFilter>.Builder} avoiding the need to
         * create one manually via {@link List<TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremisesInstanceTagFilters(List<TagFilter>)}.
         * 
         * @param onPremisesInstanceTagFilters
         *        a consumer that will call methods on {@link List<TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesInstanceTagFilters(List<TagFilter>)
         */
        Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * 
         * @param autoScalingGroups
         *        A list of associated Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * 
         * @param autoScalingGroups
         *        A list of associated Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoScalingGroup>.Builder} avoiding the
         * need to create one manually via {@link List<AutoScalingGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoScalingGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #autoScalingGroups(List<AutoScalingGroup>)}.
         * 
         * @param autoScalingGroups
         *        a consumer that will call methods on {@link List<AutoScalingGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroups(List<AutoScalingGroup>)
         */
        Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder>... autoScalingGroups);

        /**
         * <p>
         * A service role ARN.
         * </p>
         * 
         * @param serviceRoleArn
         *        A service role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Information about the deployment group's target revision, including type and location.
         * </p>
         * 
         * @param targetRevision
         *        Information about the deployment group's target revision, including type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRevision(RevisionLocation targetRevision);

        /**
         * <p>
         * Information about the deployment group's target revision, including type and location.
         * </p>
         * This is a convenience that creates an instance of the {@link RevisionLocation.Builder} avoiding the need to
         * create one manually via {@link RevisionLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #targetRevision(RevisionLocation)}.
         * 
         * @param targetRevision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRevision(RevisionLocation)
         */
        default Builder targetRevision(Consumer<RevisionLocation.Builder> targetRevision) {
            return targetRevision(RevisionLocation.builder().applyMutation(targetRevision).build());
        }

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations);

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(TriggerConfig... triggerConfigurations);

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TriggerConfig>.Builder} avoiding the need
         * to create one manually via {@link List<TriggerConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TriggerConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #triggerConfigurations(List<TriggerConfig>)}.
         * 
         * @param triggerConfigurations
         *        a consumer that will call methods on {@link List<TriggerConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerConfigurations(List<TriggerConfig>)
         */
        Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations);

        /**
         * <p>
         * A list of alarms associated with the deployment group.
         * </p>
         * 
         * @param alarmConfiguration
         *        A list of alarms associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * A list of alarms associated with the deployment group.
         * </p>
         * This is a convenience that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the need to
         * create one manually via {@link AlarmConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmConfiguration(AlarmConfiguration)}.
         * 
         * @param alarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmConfiguration(AlarmConfiguration)
         */
        default Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return alarmConfiguration(AlarmConfiguration.builder().applyMutation(alarmConfiguration).build());
        }

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment group.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information about the automatic rollback configuration associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment group.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoRollbackConfiguration.Builder} avoiding the
         * need to create one manually via {@link AutoRollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoRollbackConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfiguration)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfiguration)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration).build());
        }

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentStyle.Builder} avoiding the need to
         * create one manually via {@link DeploymentStyle#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentStyle(DeploymentStyle)}.
         * 
         * @param deploymentStyle
         *        a consumer that will call methods on {@link DeploymentStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentStyle(DeploymentStyle)
         */
        default Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return deploymentStyle(DeploymentStyle.builder().applyMutation(deploymentStyle).build());
        }

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for a deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * This is a convenience that creates an instance of the {@link BlueGreenDeploymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link BlueGreenDeploymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlueGreenDeploymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)}.
         * 
         * @param blueGreenDeploymentConfiguration
         *        a consumer that will call methods on {@link BlueGreenDeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)
         */
        default Builder blueGreenDeploymentConfiguration(
                Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.builder()
                    .applyMutation(blueGreenDeploymentConfiguration).build());
        }

        /**
         * <p>
         * Information about the load balancer to use in a deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer to use in a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);

        /**
         * <p>
         * Information about the load balancer to use in a deployment.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadBalancerInfo.Builder} avoiding the need to
         * create one manually via {@link LoadBalancerInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancerInfo(LoadBalancerInfo)}.
         * 
         * @param loadBalancerInfo
         *        a consumer that will call methods on {@link LoadBalancerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerInfo(LoadBalancerInfo)
         */
        default Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return loadBalancerInfo(LoadBalancerInfo.builder().applyMutation(loadBalancerInfo).build());
        }

        /**
         * <p>
         * Information about the most recent successful deployment to the deployment group.
         * </p>
         * 
         * @param lastSuccessfulDeployment
         *        Information about the most recent successful deployment to the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment);

        /**
         * <p>
         * Information about the most recent successful deployment to the deployment group.
         * </p>
         * This is a convenience that creates an instance of the {@link LastDeploymentInfo.Builder} avoiding the need to
         * create one manually via {@link LastDeploymentInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LastDeploymentInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #lastSuccessfulDeployment(LastDeploymentInfo)}.
         * 
         * @param lastSuccessfulDeployment
         *        a consumer that will call methods on {@link LastDeploymentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastSuccessfulDeployment(LastDeploymentInfo)
         */
        default Builder lastSuccessfulDeployment(Consumer<LastDeploymentInfo.Builder> lastSuccessfulDeployment) {
            return lastSuccessfulDeployment(LastDeploymentInfo.builder().applyMutation(lastSuccessfulDeployment).build());
        }

        /**
         * <p>
         * Information about the most recent attempted deployment to the deployment group.
         * </p>
         * 
         * @param lastAttemptedDeployment
         *        Information about the most recent attempted deployment to the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment);

        /**
         * <p>
         * Information about the most recent attempted deployment to the deployment group.
         * </p>
         * This is a convenience that creates an instance of the {@link LastDeploymentInfo.Builder} avoiding the need to
         * create one manually via {@link LastDeploymentInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LastDeploymentInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #lastAttemptedDeployment(LastDeploymentInfo)}.
         * 
         * @param lastAttemptedDeployment
         *        a consumer that will call methods on {@link LastDeploymentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastAttemptedDeployment(LastDeploymentInfo)
         */
        default Builder lastAttemptedDeployment(Consumer<LastDeploymentInfo.Builder> lastAttemptedDeployment) {
            return lastAttemptedDeployment(LastDeploymentInfo.builder().applyMutation(lastAttemptedDeployment).build());
        }

        /**
         * <p>
         * Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances
         * identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
         * </p>
         * 
         * @param ec2TagSet
         *        Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2
         *        instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagSet(EC2TagSet ec2TagSet);

        /**
         * <p>
         * Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances
         * identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2TagSet.Builder} avoiding the need to create
         * one manually via {@link EC2TagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2TagSet.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2TagSet(EC2TagSet)}.
         * 
         * @param ec2TagSet
         *        a consumer that will call methods on {@link EC2TagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagSet(EC2TagSet)
         */
        default Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return ec2TagSet(EC2TagSet.builder().applyMutation(ec2TagSet).build());
        }

        /**
         * <p>
         * Information about groups of tags applied to an on-premises instance. The deployment group includes only
         * on-premises instances identified by all the tag groups. Cannot be used in the same call as
         * onPremisesInstanceTagFilters.
         * </p>
         * 
         * @param onPremisesTagSet
         *        Information about groups of tags applied to an on-premises instance. The deployment group includes
         *        only on-premises instances identified by all the tag groups. Cannot be used in the same call as
         *        onPremisesInstanceTagFilters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet);

        /**
         * <p>
         * Information about groups of tags applied to an on-premises instance. The deployment group includes only
         * on-premises instances identified by all the tag groups. Cannot be used in the same call as
         * onPremisesInstanceTagFilters.
         * </p>
         * This is a convenience that creates an instance of the {@link OnPremisesTagSet.Builder} avoiding the need to
         * create one manually via {@link OnPremisesTagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnPremisesTagSet.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremisesTagSet(OnPremisesTagSet)}.
         * 
         * @param onPremisesTagSet
         *        a consumer that will call methods on {@link OnPremisesTagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesTagSet(OnPremisesTagSet)
         */
        default Builder onPremisesTagSet(Consumer<OnPremisesTagSet.Builder> onPremisesTagSet) {
            return onPremisesTagSet(OnPremisesTagSet.builder().applyMutation(onPremisesTagSet).build());
        }

        /**
         * <p>
         * The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment group (<code>Lambda</code> or <code>Server</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target Amazon ECS services in the deployment group. This applies only to deployment groups that
         *        use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster
         *        and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(Collection<ECSService> ecsServices);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target Amazon ECS services in the deployment group. This applies only to deployment groups that
         *        use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster
         *        and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(ECSService... ecsServices);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ECSService>.Builder} avoiding the need to
         * create one manually via {@link List<ECSService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ECSService>.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsServices(List<ECSService>)}.
         * 
         * @param ecsServices
         *        a consumer that will call methods on {@link List<ECSService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsServices(List<ECSService>)
         */
        Builder ecsServices(Consumer<ECSService.Builder>... ecsServices);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupId;

        private String deploymentGroupName;

        private String deploymentConfigName;

        private List<EC2TagFilter> ec2TagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<TagFilter> onPremisesInstanceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<AutoScalingGroup> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();

        private String serviceRoleArn;

        private RevisionLocation targetRevision;

        private List<TriggerConfig> triggerConfigurations = DefaultSdkAutoConstructList.getInstance();

        private AlarmConfiguration alarmConfiguration;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private DeploymentStyle deploymentStyle;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private LastDeploymentInfo lastSuccessfulDeployment;

        private LastDeploymentInfo lastAttemptedDeployment;

        private EC2TagSet ec2TagSet;

        private OnPremisesTagSet onPremisesTagSet;

        private String computePlatform;

        private List<ECSService> ecsServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentGroupInfo model) {
            applicationName(model.applicationName);
            deploymentGroupId(model.deploymentGroupId);
            deploymentGroupName(model.deploymentGroupName);
            deploymentConfigName(model.deploymentConfigName);
            ec2TagFilters(model.ec2TagFilters);
            onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            autoScalingGroups(model.autoScalingGroups);
            serviceRoleArn(model.serviceRoleArn);
            targetRevision(model.targetRevision);
            triggerConfigurations(model.triggerConfigurations);
            alarmConfiguration(model.alarmConfiguration);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
            deploymentStyle(model.deploymentStyle);
            blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            loadBalancerInfo(model.loadBalancerInfo);
            lastSuccessfulDeployment(model.lastSuccessfulDeployment);
            lastAttemptedDeployment(model.lastAttemptedDeployment);
            ec2TagSet(model.ec2TagSet);
            onPremisesTagSet(model.onPremisesTagSet);
            computePlatform(model.computePlatform);
            ecsServices(model.ecsServices);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupId() {
            return deploymentGroupId;
        }

        @Override
        public final Builder deploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
            return this;
        }

        public final void setDeploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter.Builder> getEc2TagFilters() {
            return ec2TagFilters != null ? ec2TagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter... ec2TagFilters) {
            ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters) {
            ec2TagFilters(Stream.of(ec2TagFilters).map(c -> EC2TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        public final Collection<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            return onPremisesInstanceTagFilters != null ? onPremisesInstanceTagFilters.stream().map(TagFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Stream.of(onPremisesInstanceTagFilters)
                    .map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        public final Collection<AutoScalingGroup.Builder> getAutoScalingGroups() {
            return autoScalingGroups != null ? autoScalingGroups.stream().map(AutoScalingGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups) {
            autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder>... autoScalingGroups) {
            autoScalingGroups(Stream.of(autoScalingGroups).map(c -> AutoScalingGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copyFromBuilder(autoScalingGroups);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final RevisionLocation.Builder getTargetRevision() {
            return targetRevision != null ? targetRevision.toBuilder() : null;
        }

        @Override
        public final Builder targetRevision(RevisionLocation targetRevision) {
            this.targetRevision = targetRevision;
            return this;
        }

        public final void setTargetRevision(RevisionLocation.BuilderImpl targetRevision) {
            this.targetRevision = targetRevision != null ? targetRevision.build() : null;
        }

        public final Collection<TriggerConfig.Builder> getTriggerConfigurations() {
            return triggerConfigurations != null ? triggerConfigurations.stream().map(TriggerConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig... triggerConfigurations) {
            triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations) {
            triggerConfigurations(Stream.of(triggerConfigurations).map(c -> TriggerConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return alarmConfiguration != null ? alarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return deploymentStyle != null ? deploymentStyle.toBuilder() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(
                BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration
                    .build() : null;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return loadBalancerInfo != null ? loadBalancerInfo.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        public final LastDeploymentInfo.Builder getLastSuccessfulDeployment() {
            return lastSuccessfulDeployment != null ? lastSuccessfulDeployment.toBuilder() : null;
        }

        @Override
        public final Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment;
            return this;
        }

        public final void setLastSuccessfulDeployment(LastDeploymentInfo.BuilderImpl lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment != null ? lastSuccessfulDeployment.build() : null;
        }

        public final LastDeploymentInfo.Builder getLastAttemptedDeployment() {
            return lastAttemptedDeployment != null ? lastAttemptedDeployment.toBuilder() : null;
        }

        @Override
        public final Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment;
            return this;
        }

        public final void setLastAttemptedDeployment(LastDeploymentInfo.BuilderImpl lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment != null ? lastAttemptedDeployment.build() : null;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return ec2TagSet != null ? ec2TagSet.toBuilder() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        public final OnPremisesTagSet.Builder getOnPremisesTagSet() {
            return onPremisesTagSet != null ? onPremisesTagSet.toBuilder() : null;
        }

        @Override
        public final Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        public final void setOnPremisesTagSet(OnPremisesTagSet.BuilderImpl onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet != null ? onPremisesTagSet.build() : null;
        }

        public final String getComputePlatformAsString() {
            return computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        public final Collection<ECSService.Builder> getEcsServices() {
            return ecsServices != null ? ecsServices.stream().map(ECSService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ecsServices(Collection<ECSService> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copy(ecsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(ECSService... ecsServices) {
            ecsServices(Arrays.asList(ecsServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(Consumer<ECSService.Builder>... ecsServices) {
            ecsServices(Stream.of(ecsServices).map(c -> ECSService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEcsServices(Collection<ECSService.BuilderImpl> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copyFromBuilder(ecsServices);
        }

        @Override
        public DeploymentGroupInfo build() {
            return new DeploymentGroupInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
