/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location of application artifacts stored in GitHub.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitHubLocation implements SdkPojo, Serializable, ToCopyableBuilder<GitHubLocation.Builder, GitHubLocation> {
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GitHubLocation::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GitHubLocation::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_FIELD,
            COMMIT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repository;

    private final String commitId;

    private GitHubLocation(BuilderImpl builder) {
        this.repository = builder.repository;
        this.commitId = builder.commitId;
    }

    /**
     * <p>
     * The GitHub account and repository pair that stores a reference to the commit that represents the bundled
     * artifacts for the application revision.
     * </p>
     * <p>
     * Specified as account/repository.
     * </p>
     * 
     * @return The GitHub account and repository pair that stores a reference to the commit that represents the bundled
     *         artifacts for the application revision. </p>
     *         <p>
     *         Specified as account/repository.
     */
    public String repository() {
        return repository;
    }

    /**
     * <p>
     * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.
     * </p>
     * 
     * @return The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application
     *         revision.
     */
    public String commitId() {
        return commitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubLocation)) {
            return false;
        }
        GitHubLocation other = (GitHubLocation) obj;
        return Objects.equals(repository(), other.repository()) && Objects.equals(commitId(), other.commitId());
    }

    @Override
    public String toString() {
        return ToString.builder("GitHubLocation").add("Repository", repository()).add("CommitId", commitId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitHubLocation, T> g) {
        return obj -> g.apply((GitHubLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitHubLocation> {
        /**
         * <p>
         * The GitHub account and repository pair that stores a reference to the commit that represents the bundled
         * artifacts for the application revision.
         * </p>
         * <p>
         * Specified as account/repository.
         * </p>
         * 
         * @param repository
         *        The GitHub account and repository pair that stores a reference to the commit that represents the
         *        bundled artifacts for the application revision. </p>
         *        <p>
         *        Specified as account/repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.
         * </p>
         * 
         * @param commitId
         *        The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application
         *        revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);
    }

    static final class BuilderImpl implements Builder {
        private String repository;

        private String commitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubLocation model) {
            repository(model.repository);
            commitId(model.commitId);
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getCommitId() {
            return commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public GitHubLocation build() {
            return new GitHubLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
