/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentGroupsRequest extends CodeDeployRequest implements
        ToCopyableBuilder<BatchGetDeploymentGroupsRequest.Builder, BatchGetDeploymentGroupsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(BatchGetDeploymentGroupsRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<List<String>> DEPLOYMENT_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deploymentGroupNames")
            .getter(getter(BatchGetDeploymentGroupsRequest::deploymentGroupNames))
            .setter(setter(Builder::deploymentGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DEPLOYMENT_GROUP_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationName;

    private final List<String> deploymentGroupNames;

    private BatchGetDeploymentGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupNames = builder.deploymentGroupNames;
    }

    /**
     * <p>
     * The name of an CodeDeploy application associated with the applicable user or Amazon Web Services account.
     * </p>
     * 
     * @return The name of an CodeDeploy application associated with the applicable user or Amazon Web Services account.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentGroupNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeploymentGroupNames() {
        return deploymentGroupNames != null && !(deploymentGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the deployment groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentGroupNames} method.
     * </p>
     * 
     * @return The names of the deployment groups.
     */
    public final List<String> deploymentGroupNames() {
        return deploymentGroupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentGroupNames() ? deploymentGroupNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsRequest)) {
            return false;
        }
        BatchGetDeploymentGroupsRequest other = (BatchGetDeploymentGroupsRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && hasDeploymentGroupNames() == other.hasDeploymentGroupNames()
                && Objects.equals(deploymentGroupNames(), other.deploymentGroupNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDeploymentGroupsRequest").add("ApplicationName", applicationName())
                .add("DeploymentGroupNames", hasDeploymentGroupNames() ? deploymentGroupNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "deploymentGroupNames":
            return Optional.ofNullable(clazz.cast(deploymentGroupNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationName", APPLICATION_NAME_FIELD);
        map.put("deploymentGroupNames", DEPLOYMENT_GROUP_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentGroupsRequest, T> g) {
        return obj -> g.apply((BatchGetDeploymentGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetDeploymentGroupsRequest> {
        /**
         * <p>
         * The name of an CodeDeploy application associated with the applicable user or Amazon Web Services account.
         * </p>
         * 
         * @param applicationName
         *        The name of an CodeDeploy application associated with the applicable user or Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The names of the deployment groups.
         * </p>
         * 
         * @param deploymentGroupNames
         *        The names of the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupNames(Collection<String> deploymentGroupNames);

        /**
         * <p>
         * The names of the deployment groups.
         * </p>
         * 
         * @param deploymentGroupNames
         *        The names of the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupNames(String... deploymentGroupNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private List<String> deploymentGroupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsRequest model) {
            super(model);
            applicationName(model.applicationName);
            deploymentGroupNames(model.deploymentGroupNames);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Collection<String> getDeploymentGroupNames() {
            if (deploymentGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return deploymentGroupNames;
        }

        public final void setDeploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
        }

        @Override
        public final Builder deploymentGroupNames(Collection<String> deploymentGroupNames) {
            this.deploymentGroupNames = DeploymentGroupsListCopier.copy(deploymentGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupNames(String... deploymentGroupNames) {
            deploymentGroupNames(Arrays.asList(deploymentGroupNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDeploymentGroupsRequest build() {
            return new BatchGetDeploymentGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
