/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
 * deployment traffic behind a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentStyle implements SdkPojo, Serializable, ToCopyableBuilder<DeploymentStyle.Builder, DeploymentStyle> {
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentStyle::deploymentTypeAsString)).setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<String> DEPLOYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentStyle::deploymentOptionAsString)).setter(setter(Builder::deploymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TYPE_FIELD,
            DEPLOYMENT_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentType;

    private final String deploymentOption;

    private DeploymentStyle(BuilderImpl builder) {
        this.deploymentType = builder.deploymentType;
        this.deploymentOption = builder.deploymentOption;
    }

    /**
     * <p>
     * Indicates whether to run an in-place deployment or a blue/green deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to run an in-place deployment or a blue/green deployment.
     * @see DeploymentType
     */
    public DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Indicates whether to run an in-place deployment or a blue/green deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to run an in-place deployment or a blue/green deployment.
     * @see DeploymentType
     */
    public String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * Indicates whether to route deployment traffic behind a load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentOption}
     * will return {@link DeploymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentOptionAsString}.
     * </p>
     * 
     * @return Indicates whether to route deployment traffic behind a load balancer.
     * @see DeploymentOption
     */
    public DeploymentOption deploymentOption() {
        return DeploymentOption.fromValue(deploymentOption);
    }

    /**
     * <p>
     * Indicates whether to route deployment traffic behind a load balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentOption}
     * will return {@link DeploymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentOptionAsString}.
     * </p>
     * 
     * @return Indicates whether to route deployment traffic behind a load balancer.
     * @see DeploymentOption
     */
    public String deploymentOptionAsString() {
        return deploymentOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentOptionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStyle)) {
            return false;
        }
        DeploymentStyle other = (DeploymentStyle) obj;
        return Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(deploymentOptionAsString(), other.deploymentOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentStyle").add("DeploymentType", deploymentTypeAsString())
                .add("DeploymentOption", deploymentOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "deploymentOption":
            return Optional.ofNullable(clazz.cast(deploymentOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentStyle, T> g) {
        return obj -> g.apply((DeploymentStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentStyle> {
        /**
         * <p>
         * Indicates whether to run an in-place deployment or a blue/green deployment.
         * </p>
         * 
         * @param deploymentType
         *        Indicates whether to run an in-place deployment or a blue/green deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Indicates whether to run an in-place deployment or a blue/green deployment.
         * </p>
         * 
         * @param deploymentType
         *        Indicates whether to run an in-place deployment or a blue/green deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * <p>
         * Indicates whether to route deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentOption
         *        Indicates whether to route deployment traffic behind a load balancer.
         * @see DeploymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentOption
         */
        Builder deploymentOption(String deploymentOption);

        /**
         * <p>
         * Indicates whether to route deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentOption
         *        Indicates whether to route deployment traffic behind a load balancer.
         * @see DeploymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentOption
         */
        Builder deploymentOption(DeploymentOption deploymentOption);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentType;

        private String deploymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStyle model) {
            deploymentType(model.deploymentType);
            deploymentOption(model.deploymentOption);
        }

        public final String getDeploymentTypeAsString() {
            return deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getDeploymentOptionAsString() {
            return deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        @Override
        public final Builder deploymentOption(DeploymentOption deploymentOption) {
            this.deploymentOption(deploymentOption == null ? null : deploymentOption.toString());
            return this;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        @Override
        public DeploymentStyle build() {
            return new DeploymentStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
