/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.model.PartitionsRegionsMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

public class RegionMetadataProviderGenerator
implements PoetClass {
    private final PartitionsRegionsMetadata partitions;
    private final String basePackage;
    private final String regionBasePackage;

    public RegionMetadataProviderGenerator(PartitionsRegionsMetadata partitions, String basePackage, String regionBasePackage) {
        this.partitions = partitions;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
    }

    @Override
    public TypeSpec poetClass() {
        ParameterizedTypeName mapOfRegionMetadata = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]), ClassName.get((String)this.regionBasePackage, (String)"RegionMetadata", (String[])new String[0])});
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"RegionMetadataProvider", (String[])new String[0])).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addAnnotation(SdkPublicApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addField(FieldSpec.builder((TypeName)mapOfRegionMetadata, (String)"REGION_METADATA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.regions(this.partitions)).build()).addMethod(this.getter()).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.regionBasePackage, (String)"GeneratedRegionMetadataProvider", (String[])new String[0]);
    }

    private CodeBlock regions(PartitionsRegionsMetadata partitions) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<Region, RegionMetadata>builder()", new Object[]{ImmutableMap.class});
        partitions.getPartitions().forEach(p -> p.getRegions().keySet().forEach(r -> builder.add(".put(Region.$L, new $T())", new Object[]{this.regionClass((String)r), this.regionMetadataClass((String)r)})));
        return builder.add(".build()", new Object[0]).build();
    }

    private String regionClass(String region) {
        return region.replace("-", "_").toUpperCase(Locale.US);
    }

    private ClassName regionMetadataClass(String region) {
        return ClassName.get((String)this.basePackage, (String)Stream.of(region.split("-")).map(Utils::capitalize).collect(Collectors.joining()), (String[])new String[0]);
    }

    private MethodSpec getter() {
        return MethodSpec.methodBuilder((String)"regionMetadata").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]), "region", new Modifier[0]).returns((TypeName)ClassName.get((String)this.regionBasePackage, (String)"RegionMetadata", (String[])new String[0])).addStatement("return $L.get($L)", new Object[]{"REGION_METADATA", "region"}).build();
    }
}

