/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.codegen.model.config.customization.KeyTypePair;
import software.amazon.awssdk.codegen.poet.rules2.BooleanAndExpression;
import software.amazon.awssdk.codegen.poet.rules2.BooleanNotExpression;
import software.amazon.awssdk.codegen.poet.rules2.ComputeScopeTree;
import software.amazon.awssdk.codegen.poet.rules2.EndpointExpression;
import software.amazon.awssdk.codegen.poet.rules2.ErrorExpression;
import software.amazon.awssdk.codegen.poet.rules2.FunctionCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.HeadersExpression;
import software.amazon.awssdk.codegen.poet.rules2.LetExpression;
import software.amazon.awssdk.codegen.poet.rules2.ListExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralBooleanExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralIntegerExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralStringExpression;
import software.amazon.awssdk.codegen.poet.rules2.MemberAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.MethodCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.PropertiesExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleFunctionMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleSetExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.codegen.poet.rules2.StringConcatExpression;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;
import software.amazon.awssdk.codegen.poet.rules2.VariableReferenceExpression;
import software.amazon.awssdk.codegen.poet.rules2.WalkRuleExpressionVisitor;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.utils.uri.SdkUri;

public class CodeGeneratorVisitor
extends WalkRuleExpressionVisitor {
    private static final Logger log = LoggerFactory.getLogger(CodeGeneratorVisitor.class);
    private final CodeBlock.Builder builder;
    private final RuleRuntimeTypeMirror typeMirror;
    private final SymbolTable symbolTable;
    private final Map<String, KeyTypePair> knownEndpointAttributes;
    private final Map<String, ComputeScopeTree.Scope> ruleIdToScope;
    private final boolean endpointCaching;

    public CodeGeneratorVisitor(RuleRuntimeTypeMirror typeMirror, SymbolTable symbolTable, Map<String, KeyTypePair> knownEndpointAttributes, Map<String, ComputeScopeTree.Scope> ruleIdToScope, boolean endpointCaching, CodeBlock.Builder builder) {
        this.builder = builder;
        this.symbolTable = symbolTable;
        this.knownEndpointAttributes = knownEndpointAttributes;
        this.ruleIdToScope = ruleIdToScope;
        this.typeMirror = typeMirror;
        this.endpointCaching = endpointCaching;
    }

    @Override
    public Void visitLiteralBooleanExpression(LiteralBooleanExpression e) {
        this.builder.add(Boolean.toString(e.value()), new Object[0]);
        return null;
    }

    @Override
    public Void visitLiteralIntegerExpression(LiteralIntegerExpression e) {
        this.builder.add(Integer.toString(e.value()), new Object[0]);
        return null;
    }

    @Override
    public Void visitLiteralStringExpression(LiteralStringExpression e) {
        this.builder.add("$S", new Object[]{e.value()});
        return null;
    }

    @Override
    public Void visitBooleanNotExpression(BooleanNotExpression e) {
        this.builder.add("!", new Object[0]);
        e.expression().accept(this);
        return null;
    }

    @Override
    public Void visitBooleanAndExpression(BooleanAndExpression e) {
        List<RuleExpression> expressions = e.expressions();
        boolean isFirst = true;
        for (RuleExpression expr : expressions) {
            if (!isFirst) {
                this.builder.add(" && ", new Object[0]);
            }
            expr.accept(this);
            isFirst = false;
        }
        return null;
    }

    @Override
    public Void visitFunctionCallExpression(FunctionCallExpression e) {
        String fn = e.name();
        if ("not".equals(fn)) {
            this.builder.add("!(", new Object[0]);
            e.arguments().get(0).accept(this);
            this.builder.add(")", new Object[0]);
            return null;
        }
        if ("isSet".equals(fn)) {
            e.arguments().get(0).accept(this);
            this.builder.add(" != null", new Object[0]);
            return null;
        }
        if ("isNotSet".equals(fn)) {
            e.arguments().get(0).accept(this);
            this.builder.add(" == null", new Object[0]);
            return null;
        }
        RuleFunctionMirror func = this.typeMirror.resolveFunction(e.name());
        this.builder.add("$T.$L(", new Object[]{func.containingType().type(), func.javaName()});
        List<RuleExpression> args = e.arguments();
        boolean isFirst = true;
        for (RuleExpression arg : args) {
            if (!isFirst) {
                this.builder.add(", ", new Object[0]);
            }
            arg.accept(this);
            isFirst = false;
        }
        this.builder.add(")", new Object[0]);
        return null;
    }

    @Override
    public Void visitMethodCallExpression(MethodCallExpression e) {
        e.source().accept(this);
        this.builder.add(".$L(", new Object[]{e.name()});
        boolean isFirst = true;
        for (RuleExpression arg : e.arguments()) {
            if (!isFirst) {
                this.builder.add(", ", new Object[0]);
            }
            arg.accept(this);
            isFirst = false;
        }
        this.builder.add(")", new Object[0]);
        return null;
    }

    @Override
    public Void visitVariableReferenceExpression(VariableReferenceExpression e) {
        this.builder.add("$L", new Object[]{e.variableName()});
        return null;
    }

    @Override
    public Void visitMemberAccessExpression(MemberAccessExpression e) {
        e.source().accept(this);
        if (!e.directIndex()) {
            this.builder.add(".$L()", new Object[]{e.name()});
        }
        return null;
    }

    @Override
    public Void visitStringConcatExpression(StringConcatExpression e) {
        boolean isFirst = true;
        for (RuleExpression expr : e.expressions()) {
            if (!isFirst) {
                this.builder.add(" + ", new Object[0]);
            }
            expr.accept(this);
            isFirst = false;
        }
        return null;
    }

    @Override
    public Void visitListExpression(ListExpression e) {
        this.builder.add("$T.asList(", new Object[]{Arrays.class});
        boolean isFirst = true;
        for (RuleExpression expr : e.expressions()) {
            if (!isFirst) {
                this.builder.add(", ", new Object[0]);
            }
            expr.accept(this);
            isFirst = false;
        }
        this.builder.add(")", new Object[0]);
        return null;
    }

    @Override
    public Void visitRuleSetExpression(RuleSetExpression e) {
        EndpointExpression endpoint;
        this.conditionsPreamble(e);
        ErrorExpression error = e.error();
        if (error != null) {
            error.accept(this);
        }
        if ((endpoint = e.endpoint()) != null) {
            endpoint.accept(this);
        }
        if (e.children() != null) {
            this.codegenTreeBody(e);
        }
        this.conditionsEpilogue(e);
        return null;
    }

    @Override
    public Void visitLetExpression(LetExpression expr) {
        for (Map.Entry<String, RuleExpression> kvp : expr.bindings().entrySet()) {
            String k = kvp.getKey();
            RuleExpression v = kvp.getValue();
            RuleType type = this.symbolTable.locals().get(k);
            this.builder.add("$T $L = ", new Object[]{type.javaType(), k});
            v.accept(this);
            this.builder.addStatement("", new Object[0]);
            this.builder.beginControlFlow("if ($L != null)", new Object[]{k});
        }
        return null;
    }

    private void conditionsPreamble(RuleSetExpression expr) {
        for (RuleExpression condition : expr.conditions()) {
            if (condition.kind() == RuleExpression.RuleExpressionKind.LET) {
                condition.accept(this);
                continue;
            }
            this.builder.add("if (", new Object[0]);
            condition.accept(this);
            this.builder.beginControlFlow(")", new Object[0]);
        }
    }

    private void conditionsEpilogue(RuleSetExpression expr) {
        for (RuleExpression condition : expr.conditions()) {
            if (condition.kind() == RuleExpression.RuleExpressionKind.LET) {
                LetExpression let = (LetExpression)condition;
                for (int x = 0; x < let.bindings().size(); ++x) {
                    this.builder.endControlFlow();
                }
                continue;
            }
            this.builder.endControlFlow();
        }
        if (this.needsReturn(expr)) {
            this.builder.addStatement("return $T.carryOn()", new Object[]{this.typeMirror.rulesResult().type()});
        }
    }

    private boolean needsReturn(RuleSetExpression expr) {
        if (this.canBeInlined(expr)) {
            return false;
        }
        if (!expr.conditions().isEmpty()) {
            return true;
        }
        if (expr.children().isEmpty()) {
            return true;
        }
        int size = expr.children().size();
        RuleSetExpression child = expr.children().get(size - 1);
        if (child.isTree()) {
            return false;
        }
        return !child.conditions().isEmpty();
    }

    private void codegenTreeBody(RuleSetExpression expr) {
        List<RuleSetExpression> children = expr.children();
        int size = children.size();
        boolean isFirst = true;
        for (int idx = 0; idx < size; ++idx) {
            boolean isLast;
            RuleSetExpression child = children.get(idx);
            if (this.canBeInlined(child)) {
                child.accept(this);
                continue;
            }
            boolean bl = isLast = idx == size - 1;
            if (isLast) {
                this.builder.addStatement("return $L($L)", new Object[]{child.ruleId(), this.callParams(child.ruleId())});
                continue;
            }
            if (isFirst) {
                isFirst = false;
                this.builder.addStatement("$T result = $L($L)", new Object[]{this.typeMirror.rulesResult().type(), child.ruleId(), this.callParams(child.ruleId())});
            } else {
                this.builder.addStatement("result = $L($L)", new Object[]{child.ruleId(), this.callParams(child.ruleId())});
            }
            this.builder.beginControlFlow("if (result.isResolved())", new Object[0]).addStatement("return result", new Object[0]).endControlFlow();
        }
    }

    private boolean canBeInlined(RuleSetExpression child) {
        return !child.isTree();
    }

    private String callParams(String ruleId) {
        ComputeScopeTree.Scope scope = this.ruleIdToScope.get(ruleId);
        String args = scope.usesLocals().stream().filter(a -> !scope.defines().contains(a)).collect(Collectors.joining(", "));
        if (args.isEmpty()) {
            return "params";
        }
        return "params, " + args;
    }

    @Override
    public Void visitEndpointExpression(EndpointExpression e) {
        this.builder.add("return $T.endpoint(", new Object[]{this.typeMirror.rulesResult().type()});
        if (this.endpointCaching) {
            this.builder.add("$T.builder().url($T.getInstance().create(", new Object[]{Endpoint.class, SdkUri.class});
        } else {
            this.builder.add("$T.builder().url($T.create(", new Object[]{Endpoint.class, URI.class});
        }
        e.url().accept(this);
        this.builder.add("))", new Object[0]);
        e.headers().accept(this);
        e.properties().accept(this);
        this.builder.add(".build()", new Object[0]);
        this.builder.addStatement(")", new Object[0]);
        return null;
    }

    @Override
    public Void visitPropertiesExpression(PropertiesExpression e) {
        Map<String, RuleExpression> properties = e.properties();
        properties.forEach((k, v) -> {
            if ("authSchemes".equals(k)) {
                this.addAuthSchemesBlock((RuleExpression)v);
            } else if ("metricValues".equals(k)) {
                this.addMetricValuesBlock((RuleExpression)v);
            } else if (this.knownEndpointAttributes.containsKey(k)) {
                this.addAttributeBlock((String)k, (RuleExpression)v);
            } else {
                log.warn("Ignoring unknown endpoint property: {}", k);
            }
        });
        return null;
    }

    @Override
    public Void visitHeadersExpression(HeadersExpression e) {
        e.headers().forEach((k, v) -> {
            for (RuleExpression value : v.expressions()) {
                this.builder.add(".putHeader($S, ", new Object[]{k});
                value.accept(this);
                this.builder.add(")", new Object[0]);
            }
        });
        return null;
    }

    @Override
    public Void visitErrorExpression(ErrorExpression e) {
        this.builder.add("return $T.error(", new Object[]{this.typeMirror.rulesResult().type()});
        e.error().accept(this);
        this.builder.addStatement(")", new Object[0]);
        return null;
    }

    private void addAuthSchemesBlock(RuleExpression e) {
        ListExpression expr = (ListExpression)e;
        this.builder.add(".putAttribute($T.AUTH_SCHEMES, ", new Object[]{AwsEndpointAttribute.class});
        this.builder.add("$T.asList(", new Object[]{Arrays.class});
        boolean isFirst = true;
        for (RuleExpression authSchemeExpr : expr.expressions()) {
            if (!isFirst) {
                this.builder.add(", ", new Object[0]);
            }
            this.addAuthSchemesBody(authSchemeExpr);
            isFirst = false;
        }
        this.builder.add("))", new Object[0]);
    }

    private void addAuthSchemesBody(RuleExpression e) {
        if (e.kind() != RuleExpression.RuleExpressionKind.PROPERTIES) {
            throw new RuntimeException("Expecting properties, got: " + e);
        }
        PropertiesExpression expr = (PropertiesExpression)e;
        String name = this.stringValueOf(expr.properties().get("name"));
        this.builder.add("$T.builder()", new Object[]{this.authSchemeClass(name)});
        expr.properties().forEach((k, v) -> {
            if (!"name".equals(k)) {
                this.builder.add(".$L(", new Object[]{k});
                v.accept(this);
                this.builder.add(")", new Object[0]);
            }
        });
        this.builder.add(".build()", new Object[0]);
    }

    private String stringValueOf(RuleExpression e) {
        if (e.kind() != RuleExpression.RuleExpressionKind.STRING_VALUE) {
            throw new RuntimeException("Expecting string value, got: " + e);
        }
        LiteralStringExpression expr = (LiteralStringExpression)e;
        return expr.value();
    }

    private ClassName authSchemeClass(String name) {
        switch (name) {
            case "sigv4": {
                return ClassName.get(SigV4AuthScheme.class);
            }
            case "sigv4a": {
                return ClassName.get(SigV4aAuthScheme.class);
            }
            case "sigv4-s3express": {
                return ClassName.get((String)"software.amazon.awssdk.services.s3.endpoints.authscheme", (String)"S3ExpressEndpointAuthScheme", (String[])new String[0]);
            }
        }
        throw new RuntimeException("Unknown auth scheme: " + name);
    }

    private void addMetricValuesBlock(RuleExpression v) {
        this.builder.add(".putAttribute($T.METRIC_VALUES, ", new Object[]{AwsEndpointAttribute.class});
        v.accept(this);
        this.builder.add(")", new Object[0]);
    }

    private void addAttributeBlock(String k, RuleExpression v) {
        KeyTypePair keyType = this.knownEndpointAttributes.get(k);
        ClassConstant classConstant = this.parseClassConstant(keyType.getKey());
        this.builder.add(".putAttribute($T.$L, ", new Object[]{classConstant.className(), classConstant.fieldName()});
        v.accept(this);
        this.builder.add(")", new Object[0]);
    }

    public CodeBlock.Builder builder() {
        return this.builder;
    }

    private ClassConstant parseClassConstant(String value) {
        int lastDot = value.lastIndexOf(46);
        if (lastDot == -1) {
            throw new IllegalArgumentException("cannot parse class constant: " + value);
        }
        String fieldName = value.substring(lastDot + 1);
        String className = value.substring(0, lastDot);
        int classLastDot = className.lastIndexOf(46);
        if (classLastDot == -1) {
            throw new IllegalArgumentException("cannot parse class constant: " + value);
        }
        String simpleName = className.substring(classLastDot + 1);
        String packageName = className.substring(0, classLastDot);
        return new ClassConstant(ClassName.get((String)packageName, (String)simpleName, (String[])new String[0]), fieldName);
    }

    static class ClassConstant {
        private final ClassName className;
        private final String fieldName;

        ClassConstant(ClassName className, String fieldName) {
            this.className = className;
            this.fieldName = fieldName;
        }

        public ClassName className() {
            return this.className;
        }

        public String fieldName() {
            return this.fieldName;
        }
    }
}

