/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.config.customization.EndpointAuthSchemeConfig;
import software.amazon.awssdk.codegen.model.config.customization.KeyTypePair;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.RuleModel;
import software.amazon.awssdk.codegen.model.service.EndpointRuleSetModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.poet.rules2.CodeGeneratorVisitor;
import software.amazon.awssdk.codegen.poet.rules2.CodegenExpressionBuidler;
import software.amazon.awssdk.codegen.poet.rules2.ComputeScopeTree;
import software.amazon.awssdk.codegen.poet.rules2.ExpressionParser;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleSetExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

public class EndpointProviderSpec2
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final Map<String, KeyTypePair> knownEndpointAttributes;
    private final CodegenExpressionBuidler utils;
    private final RuleRuntimeTypeMirror typeMirror;

    public EndpointProviderSpec2(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
        String packageName = intermediateModel.getMetadata().getFullInternalEndpointRulesPackageName();
        this.typeMirror = new RuleRuntimeTypeMirror(packageName);
        EndpointRuleSetModel model = intermediateModel.getEndpointRuleSetModel();
        this.utils = EndpointProviderSpec2.createCodegenRulesUtil(model.getRules(), model.getParameters(), this.typeMirror);
        this.knownEndpointAttributes = EndpointProviderSpec2.knownEndpointAttributes(intermediateModel);
    }

    private static RuleType fromParameterModel(ParameterModel model) {
        switch (model.getType().toLowerCase(Locale.ENGLISH)) {
            case "boolean": {
                return RuleRuntimeTypeMirror.BOOLEAN;
            }
            case "string": {
                return RuleRuntimeTypeMirror.STRING;
            }
            case "stringarray": {
                return RuleRuntimeTypeMirror.LIST_OF_STRING;
            }
        }
        throw new IllegalStateException("Cannot find rule type for: " + model.getType());
    }

    private static RuleModel createRootRule(List<RuleModel> rules) {
        RuleModel root = new RuleModel();
        root.setRules(rules);
        root.setType("tree");
        root.setConditions(Collections.emptyList());
        return root;
    }

    private static CodegenExpressionBuidler createCodegenRulesUtil(List<RuleModel> rules, Map<String, ParameterModel> parameters, RuleRuntimeTypeMirror typeMirror) {
        RuleSetExpression root = ExpressionParser.parseRuleSetExpression(EndpointProviderSpec2.createRootRule(rules));
        return CodegenExpressionBuidler.from(root, typeMirror, EndpointProviderSpec2.initSymbolTable(parameters));
    }

    private static SymbolTable initSymbolTable(Map<String, ParameterModel> parameters) {
        SymbolTable.Builder builder = SymbolTable.builder();
        parameters.forEach((k, v) -> {
            builder.putParam((String)k, EndpointProviderSpec2.fromParameterModel(v));
            if (v.getBuiltInEnum() == BuiltInParameter.AWS_REGION) {
                builder.regionParamName((String)k);
                builder.putLocal((String)k, RuleRuntimeTypeMirror.STRING);
            }
        });
        return builder.build();
    }

    private static Map<String, KeyTypePair> knownEndpointAttributes(IntermediateModel intermediateModel) {
        Map<String, KeyTypePair> knownEndpointAttributes = null;
        EndpointAuthSchemeConfig config = intermediateModel.getCustomizationConfig().getEndpointAuthSchemeConfig();
        if (config != null) {
            knownEndpointAttributes = config.getEndpointProviderTestKeys();
        }
        if (knownEndpointAttributes == null) {
            knownEndpointAttributes = Collections.emptyMap();
        }
        return knownEndpointAttributes;
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)this.endpointRulesSpecUtils.providerInterfaceName()).addAnnotation(SdkInternalApi.class);
        builder.addMethod(this.resolveEndpointMethod());
        ArrayList<MethodSpec.Builder> methods = new ArrayList<MethodSpec.Builder>();
        this.createRuleMethod(this.utils.root(), methods);
        for (MethodSpec.Builder methodBuilder : methods) {
            builder.addMethod(methodBuilder.build());
        }
        builder.addMethod(this.equalsMethod());
        builder.addMethod(this.hashCodeMethod());
        return builder.build();
    }

    @Override
    public ClassName className() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)("Default" + this.endpointRulesSpecUtils.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    private MethodSpec resolveEndpointMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"resolveEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.endpointRulesSpecUtils.resolverReturnType()).addAnnotation(Override.class).addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), "params", new Modifier[0]);
        builder.addCode(this.validateRequiredParams());
        builder.beginControlFlow("try", new Object[0]);
        String regionParamName = this.utils.regionParamName();
        if (regionParamName != null) {
            builder.addStatement("$T region = params.$L()", new Object[]{Region.class, regionParamName});
            builder.addStatement("$T regionId = region == null ? null : region.id()", new Object[]{String.class});
            builder.addStatement("$T result = $L(params, regionId)", new Object[]{this.ruleResult(), this.utils.root().ruleId()});
        } else {
            builder.addStatement("$T result = $L(params)", new Object[]{this.ruleResult(), this.utils.root().ruleId()});
        }
        builder.beginControlFlow("if (result.canContinue())", new Object[0]).addStatement("throw $T.create($S)", new Object[]{SdkClientException.class, "Rule engine did not reach an error or endpoint result"}).endControlFlow();
        builder.beginControlFlow("if (result.isError())", new Object[0]).addStatement("String errorMsg = result.error()", new Object[0]).beginControlFlow("if (errorMsg.contains(\"Invalid ARN\") && errorMsg.contains(\":s3:::\"))", new Object[0]).addStatement("errorMsg += $S", new Object[]{". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest."}).endControlFlow().addStatement("throw $T.create(errorMsg)", new Object[]{SdkClientException.class}).endControlFlow();
        builder.addStatement("return $T.completedFuture(result.endpoint())", new Object[]{CompletableFuture.class});
        builder.nextControlFlow("catch ($T error)", new Object[]{Exception.class});
        builder.addStatement("return $T.failedFuture(error)", new Object[]{CompletableFutureUtils.class});
        builder.endControlFlow();
        return builder.build();
    }

    private CodeBlock validateRequiredParams() {
        CodeBlock.Builder b = CodeBlock.builder();
        Map<String, ParameterModel> parameters = this.intermediateModel.getEndpointRuleSetModel().getParameters();
        parameters.entrySet().stream().filter(e -> Boolean.TRUE.equals(((ParameterModel)e.getValue()).isRequired())).forEach(e -> b.addStatement("$T.notNull($N.$N(), $S)", new Object[]{Validate.class, "params", this.endpointRulesSpecUtils.paramMethodName((String)e.getKey()), String.format("Parameter '%s' must not be null", e.getKey())}));
        return b.build();
    }

    private void createRuleMethod(RuleSetExpression expr, List<MethodSpec.Builder> methods) {
        MethodSpec.Builder builder = this.methodBuilderForRule(expr);
        methods.add(builder);
        CodeBlock.Builder block = CodeBlock.builder();
        this.codegenExpr(expr, block);
        builder.addCode(block.build());
        if (expr.isTree()) {
            for (RuleSetExpression child : expr.children()) {
                if (!child.isTree()) continue;
                this.createRuleMethod(child, methods);
            }
        }
    }

    private MethodSpec.Builder methodBuilderForRule(RuleSetExpression expr) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)expr.ruleId()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(this.ruleResult());
        ComputeScopeTree.Scope scope = this.utils.scopesByName().get(expr.ruleId());
        builder.addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), "params", new Modifier[0]);
        for (String param : scope.usesLocals()) {
            if (scope.defines().contains(param)) continue;
            RuleType type = this.utils.symbolTable().localType(param);
            builder.addParameter(type.javaType(), param, new Modifier[0]);
        }
        return builder;
    }

    private void codegenExpr(RuleSetExpression expr, CodeBlock.Builder builder) {
        boolean useEndpointCaching = this.intermediateModel.getCustomizationConfig().getEnableEndpointProviderUriCaching();
        CodeGeneratorVisitor visitor = new CodeGeneratorVisitor(this.typeMirror, this.utils.symbolTable(), this.knownEndpointAttributes, this.utils.scopesByName(), useEndpointCaching, builder);
        visitor.visitRuleSetExpression(expr);
    }

    private TypeName ruleResult() {
        return this.typeMirror.rulesResult().type();
    }

    private MethodSpec equalsMethod() {
        return MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "rhs", new Modifier[0]).addStatement("return rhs != null && getClass().equals(rhs.getClass())", new Object[0]).build();
    }

    private MethodSpec hashCodeMethod() {
        return MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return getClass().hashCode()", new Object[0]).build();
    }
}

