/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.utils;

import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.utils.CollectionUtils;

public final class AuthUtils {
    private AuthUtils() {
    }

    public static boolean usesBearerAuth(IntermediateModel model) {
        if (AuthUtils.isServiceBearerAuth(model)) {
            return true;
        }
        return model.getOperations().values().stream().map(OperationModel::getAuthType).anyMatch(authType -> authType == AuthType.BEARER);
    }

    public static boolean usesSigv4aAuth(IntermediateModel model) {
        if (AuthUtils.isServiceSigv4a(model)) {
            return true;
        }
        return model.getOperations().values().stream().anyMatch(operationModel -> operationModel.getAuth().stream().anyMatch(authType -> authType == AuthType.V4A));
    }

    public static boolean usesAwsAuth(IntermediateModel model) {
        if (AuthUtils.isServiceAwsAuthType(model)) {
            return true;
        }
        return model.getOperations().values().stream().map(OperationModel::getAuthType).anyMatch(AuthUtils::isAuthTypeAws);
    }

    public static boolean isOpBearerAuthPreferred(IntermediateModel model, OperationModel opModel) {
        return opModel.getAuthType() == AuthType.BEARER || opModel.getAuth() != null && !opModel.getAuth().isEmpty() && opModel.getAuth().get(0) == AuthType.BEARER || model.getMetadata().getAuthType() == AuthType.BEARER && AuthUtils.hasNoAuthType(opModel) || model.getMetadata().getAuth() != null && !model.getMetadata().getAuth().isEmpty() && model.getMetadata().getAuth().get(0) == AuthType.BEARER && AuthUtils.hasNoAuthType(opModel);
    }

    private static boolean isServiceBearerAuth(IntermediateModel model) {
        return model.getMetadata().getAuthType() == AuthType.BEARER || model.getMetadata().getAuth() != null && model.getMetadata().getAuth().contains((Object)AuthType.BEARER);
    }

    private static boolean isServiceSigv4a(IntermediateModel model) {
        return model.getMetadata().getAuth().stream().anyMatch(authType -> authType == AuthType.V4A);
    }

    private static boolean isServiceAwsAuthType(IntermediateModel model) {
        AuthType authType = model.getMetadata().getAuthType();
        if (authType == null && !CollectionUtils.isNullOrEmpty(model.getMetadata().getAuth())) {
            return model.getMetadata().getAuth().stream().map(AuthType::value).map(AuthType::fromValue).anyMatch(AuthUtils::isAuthTypeAws);
        }
        return AuthUtils.isAuthTypeAws(authType);
    }

    private static boolean isAuthTypeAws(AuthType authType) {
        if (authType == null) {
            return false;
        }
        switch (authType) {
            case V4A: 
            case V4: 
            case S3: 
            case S3V4: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasNoAuthType(OperationModel opModel) {
        return opModel.getAuthType() == null || opModel.getAuthType() == AuthType.NONE;
    }
}

