/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class VersionUtils {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(.*)");

    private VersionUtils() {
    }

    public static String convertToMajorMinorX(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            String suffix = matcher.group(4);
            return major + "." + minor + ".x" + suffix;
        }
        return version;
    }
}

