/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RepositoryAssociationSummariesCopier {
    static List<RepositoryAssociationSummary> copy(Collection<RepositoryAssociationSummary> repositoryAssociationSummariesParam) {
        if (repositoryAssociationSummariesParam == null || repositoryAssociationSummariesParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<RepositoryAssociationSummary> repositoryAssociationSummariesParamCopy = new ArrayList<>(
                repositoryAssociationSummariesParam);
        return Collections.unmodifiableList(repositoryAssociationSummariesParamCopy);
    }

    static List<RepositoryAssociationSummary> copyFromBuilder(
            Collection<? extends RepositoryAssociationSummary.Builder> repositoryAssociationSummariesParam) {
        if (repositoryAssociationSummariesParam == null) {
            return null;
        }
        return copy(repositoryAssociationSummariesParam.stream().map(RepositoryAssociationSummary.Builder::build)
                .collect(toList()));
    }
}
