/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Repository implements SdkPojo, Serializable, ToCopyableBuilder<Repository.Builder, Repository> {
    private static final SdkField<CodeCommitRepository> CODE_COMMIT_FIELD = SdkField
            .<CodeCommitRepository> builder(MarshallingType.SDK_POJO).getter(getter(Repository::codeCommit))
            .setter(setter(Builder::codeCommit)).constructor(CodeCommitRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeCommit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_COMMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeCommitRepository codeCommit;

    private Repository(BuilderImpl builder) {
        this.codeCommit = builder.codeCommit;
    }

    /**
     * <p>
     * Information about an AWS CodeCommit repository.
     * </p>
     * 
     * @return Information about an AWS CodeCommit repository.
     */
    public CodeCommitRepository codeCommit() {
        return codeCommit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeCommit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository) obj;
        return Objects.equals(codeCommit(), other.codeCommit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Repository").add("CodeCommit", codeCommit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeCommit":
            return Optional.ofNullable(clazz.cast(codeCommit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Repository, T> g) {
        return obj -> g.apply((Repository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Repository> {
        /**
         * <p>
         * Information about an AWS CodeCommit repository.
         * </p>
         * 
         * @param codeCommit
         *        Information about an AWS CodeCommit repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeCommit(CodeCommitRepository codeCommit);

        /**
         * <p>
         * Information about an AWS CodeCommit repository.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeCommitRepository.Builder} avoiding the need
         * to create one manually via {@link CodeCommitRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeCommitRepository.Builder#build()} is called immediately and
         * its result is passed to {@link #codeCommit(CodeCommitRepository)}.
         * 
         * @param codeCommit
         *        a consumer that will call methods on {@link CodeCommitRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeCommit(CodeCommitRepository)
         */
        default Builder codeCommit(Consumer<CodeCommitRepository.Builder> codeCommit) {
            return codeCommit(CodeCommitRepository.builder().applyMutation(codeCommit).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CodeCommitRepository codeCommit;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            codeCommit(model.codeCommit);
        }

        public final CodeCommitRepository.Builder getCodeCommit() {
            return codeCommit != null ? codeCommit.toBuilder() : null;
        }

        @Override
        public final Builder codeCommit(CodeCommitRepository codeCommit) {
            this.codeCommit = codeCommit;
            return this;
        }

        public final void setCodeCommit(CodeCommitRepository.BuilderImpl codeCommit) {
            this.codeCommit = codeCommit != null ? codeCommit.build() : null;
        }

        @Override
        public Repository build() {
            return new Repository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
