/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about recommendation feedback summaries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationFeedbackSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationFeedbackSummary.Builder, RecommendationFeedbackSummary> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecommendationFeedbackSummary::recommendationId)).setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<List<String>> REACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RecommendationFeedbackSummary::reactionsAsStrings))
            .setter(setter(Builder::reactionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reactions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecommendationFeedbackSummary::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            REACTIONS_FIELD, USER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final List<String> reactions;

    private final String userId;

    private RecommendationFeedbackSummary(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.reactions = builder.reactions;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect
     * the feedback.
     * </p>
     * 
     * @return The recommendation ID that can be used to track the provided recommendations. Later on it can be used to
     *         collect the feedback.
     */
    public String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * List for storing reactions. Reactions are utf-8 text code for emojis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReactions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List for storing reactions. Reactions are utf-8 text code for emojis.
     */
    public List<Reaction> reactions() {
        return ReactionsCopier.copyStringToEnum(reactions);
    }

    /**
     * Returns true if the Reactions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReactions() {
        return reactions != null && !(reactions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List for storing reactions. Reactions are utf-8 text code for emojis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReactions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List for storing reactions. Reactions are utf-8 text code for emojis.
     */
    public List<String> reactionsAsStrings() {
        return reactions;
    }

    /**
     * <p>
     * The identifier for the user that gave the feedback.
     * </p>
     * 
     * @return The identifier for the user that gave the feedback.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(reactionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationFeedbackSummary)) {
            return false;
        }
        RecommendationFeedbackSummary other = (RecommendationFeedbackSummary) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(reactionsAsStrings(), other.reactionsAsStrings()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecommendationFeedbackSummary").add("RecommendationId", recommendationId())
                .add("Reactions", reactionsAsStrings()).add("UserId", userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "Reactions":
            return Optional.ofNullable(clazz.cast(reactionsAsStrings()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationFeedbackSummary, T> g) {
        return obj -> g.apply((RecommendationFeedbackSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationFeedbackSummary> {
        /**
         * <p>
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to
         * collect the feedback.
         * </p>
         * 
         * @param recommendationId
         *        The recommendation ID that can be used to track the provided recommendations. Later on it can be used
         *        to collect the feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionsWithStrings(Collection<String> reactions);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionsWithStrings(String... reactions);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactions(Collection<Reaction> reactions);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactions(Reaction... reactions);

        /**
         * <p>
         * The identifier for the user that gave the feedback.
         * </p>
         * 
         * @param userId
         *        The identifier for the user that gave the feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private List<String> reactions = DefaultSdkAutoConstructList.getInstance();

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationFeedbackSummary model) {
            recommendationId(model.recommendationId);
            reactionsWithStrings(model.reactions);
            userId(model.userId);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final Collection<String> getReactionsAsStrings() {
            return reactions;
        }

        @Override
        public final Builder reactionsWithStrings(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionsWithStrings(String... reactions) {
            reactionsWithStrings(Arrays.asList(reactions));
            return this;
        }

        @Override
        public final Builder reactions(Collection<Reaction> reactions) {
            this.reactions = ReactionsCopier.copyEnumToString(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactions(Reaction... reactions) {
            reactions(Arrays.asList(reactions));
            return this;
        }

        public final void setReactionsWithStrings(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public RecommendationFeedbackSummary build() {
            return new RecommendationFeedbackSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
