/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a repository association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryAssociationSummary.Builder, RepositoryAssociationSummary> {
    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RepositoryAssociationSummary::associationArn)).setter(setter(Builder::associationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationArn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RepositoryAssociationSummary::lastUpdatedTimeStamp)).setter(setter(Builder::lastUpdatedTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimeStamp").build())
            .build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RepositoryAssociationSummary::associationId)).setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RepositoryAssociationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RepositoryAssociationSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RepositoryAssociationSummary::providerTypeAsString)).setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RepositoryAssociationSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ARN_FIELD,
            LAST_UPDATED_TIME_STAMP_FIELD, ASSOCIATION_ID_FIELD, NAME_FIELD, OWNER_FIELD, PROVIDER_TYPE_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationArn;

    private final Instant lastUpdatedTimeStamp;

    private final String associationId;

    private final String name;

    private final String owner;

    private final String providerType;

    private final String state;

    private RepositoryAssociationSummary(BuilderImpl builder) {
        this.associationArn = builder.associationArn;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
        this.associationId = builder.associationId;
        this.name = builder.name;
        this.owner = builder.owner;
        this.providerType = builder.providerType;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) identifying the repository association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) identifying the repository association.
     */
    public String associationArn() {
        return associationArn;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, since the repository association was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, since the repository association was last updated.
     */
    public Instant lastUpdatedTimeStamp() {
        return lastUpdatedTimeStamp;
    }

    /**
     * <p>
     * The repository association ID.
     * </p>
     * 
     * @return The repository association ID.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The name of the repository association.
     * </p>
     * 
     * @return The name of the repository association.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The owner of the repository association.
     * </p>
     * 
     * @return The owner of the repository association.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The provider type of the repository association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type of the repository association.
     * @see ProviderType
     */
    public ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The provider type of the repository association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type of the repository association.
     * @see ProviderType
     */
    public String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The state of the repository association.
     * </p>
     * <dl>
     * <dt>Associated</dt>
     * <dd>
     * <p>
     * Amazon CodeGuru Reviewer is associated with the repository.
     * </p>
     * </dd>
     * <dt>Associating</dt>
     * <dd>
     * <p>
     * The association is in progress.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The association failed.
     * </p>
     * </dd>
     * <dt>Disassociating</dt>
     * <dd>
     * <p>
     * Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RepositoryAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the repository association.</p>
     *         <dl>
     *         <dt>Associated</dt>
     *         <dd>
     *         <p>
     *         Amazon CodeGuru Reviewer is associated with the repository.
     *         </p>
     *         </dd>
     *         <dt>Associating</dt>
     *         <dd>
     *         <p>
     *         The association is in progress.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The association failed.
     *         </p>
     *         </dd>
     *         <dt>Disassociating</dt>
     *         <dd>
     *         <p>
     *         Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
     *         </p>
     *         </dd>
     * @see RepositoryAssociationState
     */
    public RepositoryAssociationState state() {
        return RepositoryAssociationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the repository association.
     * </p>
     * <dl>
     * <dt>Associated</dt>
     * <dd>
     * <p>
     * Amazon CodeGuru Reviewer is associated with the repository.
     * </p>
     * </dd>
     * <dt>Associating</dt>
     * <dd>
     * <p>
     * The association is in progress.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The association failed.
     * </p>
     * </dd>
     * <dt>Disassociating</dt>
     * <dd>
     * <p>
     * Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RepositoryAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the repository association.</p>
     *         <dl>
     *         <dt>Associated</dt>
     *         <dd>
     *         <p>
     *         Amazon CodeGuru Reviewer is associated with the repository.
     *         </p>
     *         </dd>
     *         <dt>Associating</dt>
     *         <dd>
     *         <p>
     *         The association is in progress.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The association failed.
     *         </p>
     *         </dd>
     *         <dt>Disassociating</dt>
     *         <dd>
     *         <p>
     *         Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
     *         </p>
     *         </dd>
     * @see RepositoryAssociationState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAssociationSummary)) {
            return false;
        }
        RepositoryAssociationSummary other = (RepositoryAssociationSummary) obj;
        return Objects.equals(associationArn(), other.associationArn())
                && Objects.equals(lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp())
                && Objects.equals(associationId(), other.associationId()) && Objects.equals(name(), other.name())
                && Objects.equals(owner(), other.owner()) && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RepositoryAssociationSummary").add("AssociationArn", associationArn())
                .add("LastUpdatedTimeStamp", lastUpdatedTimeStamp()).add("AssociationId", associationId()).add("Name", name())
                .add("Owner", owner()).add("ProviderType", providerTypeAsString()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationArn":
            return Optional.ofNullable(clazz.cast(associationArn()));
        case "LastUpdatedTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimeStamp()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryAssociationSummary, T> g) {
        return obj -> g.apply((RepositoryAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryAssociationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) identifying the repository association.
         * </p>
         * 
         * @param associationArn
         *        The Amazon Resource Name (ARN) identifying the repository association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationArn(String associationArn);

        /**
         * <p>
         * The time, in milliseconds since the epoch, since the repository association was last updated.
         * </p>
         * 
         * @param lastUpdatedTimeStamp
         *        The time, in milliseconds since the epoch, since the repository association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp);

        /**
         * <p>
         * The repository association ID.
         * </p>
         * 
         * @param associationId
         *        The repository association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The name of the repository association.
         * </p>
         * 
         * @param name
         *        The name of the repository association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of the repository association.
         * </p>
         * 
         * @param owner
         *        The owner of the repository association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The provider type of the repository association.
         * </p>
         * 
         * @param providerType
         *        The provider type of the repository association.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The provider type of the repository association.
         * </p>
         * 
         * @param providerType
         *        The provider type of the repository association.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The state of the repository association.
         * </p>
         * <dl>
         * <dt>Associated</dt>
         * <dd>
         * <p>
         * Amazon CodeGuru Reviewer is associated with the repository.
         * </p>
         * </dd>
         * <dt>Associating</dt>
         * <dd>
         * <p>
         * The association is in progress.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The association failed.
         * </p>
         * </dd>
         * <dt>Disassociating</dt>
         * <dd>
         * <p>
         * Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param state
         *        The state of the repository association.</p>
         *        <dl>
         *        <dt>Associated</dt>
         *        <dd>
         *        <p>
         *        Amazon CodeGuru Reviewer is associated with the repository.
         *        </p>
         *        </dd>
         *        <dt>Associating</dt>
         *        <dd>
         *        <p>
         *        The association is in progress.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The association failed.
         *        </p>
         *        </dd>
         *        <dt>Disassociating</dt>
         *        <dd>
         *        <p>
         *        Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
         *        </p>
         *        </dd>
         * @see RepositoryAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryAssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the repository association.
         * </p>
         * <dl>
         * <dt>Associated</dt>
         * <dd>
         * <p>
         * Amazon CodeGuru Reviewer is associated with the repository.
         * </p>
         * </dd>
         * <dt>Associating</dt>
         * <dd>
         * <p>
         * The association is in progress.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The association failed.
         * </p>
         * </dd>
         * <dt>Disassociating</dt>
         * <dd>
         * <p>
         * Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param state
         *        The state of the repository association.</p>
         *        <dl>
         *        <dt>Associated</dt>
         *        <dd>
         *        <p>
         *        Amazon CodeGuru Reviewer is associated with the repository.
         *        </p>
         *        </dd>
         *        <dt>Associating</dt>
         *        <dd>
         *        <p>
         *        The association is in progress.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The association failed.
         *        </p>
         *        </dd>
         *        <dt>Disassociating</dt>
         *        <dd>
         *        <p>
         *        Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
         *        </p>
         *        </dd>
         * @see RepositoryAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryAssociationState
         */
        Builder state(RepositoryAssociationState state);
    }

    static final class BuilderImpl implements Builder {
        private String associationArn;

        private Instant lastUpdatedTimeStamp;

        private String associationId;

        private String name;

        private String owner;

        private String providerType;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryAssociationSummary model) {
            associationArn(model.associationArn);
            lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
            associationId(model.associationId);
            name(model.name);
            owner(model.owner);
            providerType(model.providerType);
            state(model.state);
        }

        public final String getAssociationArn() {
            return associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        public final Instant getLastUpdatedTimeStamp() {
            return lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public final void setLastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getProviderType() {
            return providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RepositoryAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public RepositoryAssociationSummary build() {
            return new RepositoryAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
