/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the source code type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCodeType implements SdkPojo, Serializable, ToCopyableBuilder<SourceCodeType.Builder, SourceCodeType> {
    private static final SdkField<CommitDiffSourceCodeType> COMMIT_DIFF_FIELD = SdkField
            .<CommitDiffSourceCodeType> builder(MarshallingType.SDK_POJO).getter(getter(SourceCodeType::commitDiff))
            .setter(setter(Builder::commitDiff)).constructor(CommitDiffSourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitDiff").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_DIFF_FIELD));

    private static final long serialVersionUID = 1L;

    private final CommitDiffSourceCodeType commitDiff;

    private SourceCodeType(BuilderImpl builder) {
        this.commitDiff = builder.commitDiff;
    }

    /**
     * <p>
     * The commit diff for the pull request.
     * </p>
     * 
     * @return The commit diff for the pull request.
     */
    public CommitDiffSourceCodeType commitDiff() {
        return commitDiff;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitDiff());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCodeType)) {
            return false;
        }
        SourceCodeType other = (SourceCodeType) obj;
        return Objects.equals(commitDiff(), other.commitDiff());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SourceCodeType").add("CommitDiff", commitDiff()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommitDiff":
            return Optional.ofNullable(clazz.cast(commitDiff()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCodeType, T> g) {
        return obj -> g.apply((SourceCodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCodeType> {
        /**
         * <p>
         * The commit diff for the pull request.
         * </p>
         * 
         * @param commitDiff
         *        The commit diff for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitDiff(CommitDiffSourceCodeType commitDiff);

        /**
         * <p>
         * The commit diff for the pull request.
         * </p>
         * This is a convenience that creates an instance of the {@link CommitDiffSourceCodeType.Builder} avoiding the
         * need to create one manually via {@link CommitDiffSourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CommitDiffSourceCodeType.Builder#build()} is called immediately
         * and its result is passed to {@link #commitDiff(CommitDiffSourceCodeType)}.
         * 
         * @param commitDiff
         *        a consumer that will call methods on {@link CommitDiffSourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitDiff(CommitDiffSourceCodeType)
         */
        default Builder commitDiff(Consumer<CommitDiffSourceCodeType.Builder> commitDiff) {
            return commitDiff(CommitDiffSourceCodeType.builder().applyMutation(commitDiff).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CommitDiffSourceCodeType commitDiff;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCodeType model) {
            commitDiff(model.commitDiff);
        }

        public final CommitDiffSourceCodeType.Builder getCommitDiff() {
            return commitDiff != null ? commitDiff.toBuilder() : null;
        }

        @Override
        public final Builder commitDiff(CommitDiffSourceCodeType commitDiff) {
            this.commitDiff = commitDiff;
            return this;
        }

        public final void setCommitDiff(CommitDiffSourceCodeType.BuilderImpl commitDiff) {
            this.commitDiff = commitDiff != null ? commitDiff.build() : null;
        }

        @Override
        public SourceCodeType build() {
            return new SourceCodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
