/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositoryAssociationsRequest extends CodeGuruReviewerRequest implements
        ToCopyableBuilder<ListRepositoryAssociationsRequest.Builder, ListRepositoryAssociationsRequest> {
    private static final SdkField<List<String>> PROVIDER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListRepositoryAssociationsRequest::providerTypesAsStrings))
            .setter(setter(Builder::providerTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProviderType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListRepositoryAssociationsRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListRepositoryAssociationsRequest::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Name").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OWNERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListRepositoryAssociationsRequest::owners))
            .setter(setter(Builder::owners))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Owner").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListRepositoryAssociationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRepositoryAssociationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPES_FIELD,
            STATES_FIELD, NAMES_FIELD, OWNERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> providerTypes;

    private final List<String> states;

    private final List<String> names;

    private final List<String> owners;

    private final Integer maxResults;

    private final String nextToken;

    private ListRepositoryAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.providerTypes = builder.providerTypes;
        this.states = builder.states;
        this.names = builder.names;
        this.owners = builder.owners;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * List of provider types to use as a filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProviderTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of provider types to use as a filter.
     */
    public List<ProviderType> providerTypes() {
        return ProviderTypesCopier.copyStringToEnum(providerTypes);
    }

    /**
     * Returns true if the ProviderTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProviderTypes() {
        return providerTypes != null && !(providerTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of provider types to use as a filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProviderTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of provider types to use as a filter.
     */
    public List<String> providerTypesAsStrings() {
        return providerTypes;
    }

    /**
     * <p>
     * List of repository association states to use as a filter.
     * </p>
     * <p>
     * The valid repository association states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Associated</b>: The repository association is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Associating</b>: CodeGuru Reviewer is:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review.
     * </p>
     * <note>
     * <p>
     * If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru Reviewer
     * creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews
     * of code in your repository cannot be triggered.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Failed</b>: The repository failed to associate or disassociate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source code
     * access.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of repository association states to use as a filter.</p>
     *         <p>
     *         The valid repository association states are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Associated</b>: The repository association is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associating</b>: CodeGuru Reviewer is:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer
     *         review.
     *         </p>
     *         <note>
     *         <p>
     *         If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru
     *         Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these
     *         webhooks, reviews of code in your repository cannot be triggered.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
     *         repository.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Failed</b>: The repository failed to associate or disassociate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
     *         source code access.
     *         </p>
     *         </li>
     */
    public List<RepositoryAssociationState> states() {
        return RepositoryAssociationStatesCopier.copyStringToEnum(states);
    }

    /**
     * Returns true if the States property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of repository association states to use as a filter.
     * </p>
     * <p>
     * The valid repository association states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Associated</b>: The repository association is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Associating</b>: CodeGuru Reviewer is:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review.
     * </p>
     * <note>
     * <p>
     * If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru Reviewer
     * creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews
     * of code in your repository cannot be triggered.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Failed</b>: The repository failed to associate or disassociate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source code
     * access.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of repository association states to use as a filter.</p>
     *         <p>
     *         The valid repository association states are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Associated</b>: The repository association is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associating</b>: CodeGuru Reviewer is:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer
     *         review.
     *         </p>
     *         <note>
     *         <p>
     *         If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru
     *         Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these
     *         webhooks, reviews of code in your repository cannot be triggered.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
     *         repository.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Failed</b>: The repository failed to associate or disassociate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
     *         source code access.
     *         </p>
     *         </li>
     */
    public List<String> statesAsStrings() {
        return states;
    }

    /**
     * Returns true if the Names property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of repository names to use as a filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of repository names to use as a filter.
     */
    public List<String> names() {
        return names;
    }

    /**
     * Returns true if the Owners property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOwners() {
        return owners != null && !(owners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of owners to use as a filter. For AWS CodeCommit, it is the name of the CodeCommit account that was used to
     * associate the repository. For other repository source providers, such as Bitbucket, this is name of the account
     * that was used to associate the repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOwners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of owners to use as a filter. For AWS CodeCommit, it is the name of the CodeCommit account that was
     *         used to associate the repository. For other repository source providers, such as Bitbucket, this is name
     *         of the account that was used to associate the repository.
     */
    public List<String> owners() {
        return owners;
    }

    /**
     * <p>
     * The maximum number of repository association results returned by <code>ListRepositoryAssociations</code> in
     * paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns
     * <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining
     * results of the initial request can be seen by sending another <code>ListRepositoryAssociations</code> request
     * with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not
     * used, <code>ListRepositoryAssociations</code> returns up to 100 results and a <code>nextToken</code> value if
     * applicable.
     * </p>
     * 
     * @return The maximum number of repository association results returned by <code>ListRepositoryAssociations</code>
     *         in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns
     *         <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The
     *         remaining results of the initial request can be seen by sending another
     *         <code>ListRepositoryAssociations</code> request with the returned <code>nextToken</code> value. This
     *         value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code>
     *         returns up to 100 results and a <code>nextToken</code> value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListRepositoryAssociations</code>
     * request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     * continues from the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not for other
     * programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results
     *         exceeded the value of that parameter. Pagination continues from the end of the previous results that
     *         returned the <code>nextToken</code> value. </p> <note>
     *         <p>
     *         Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not
     *         for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(providerTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(statesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(names());
        hashCode = 31 * hashCode + Objects.hashCode(owners());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoryAssociationsRequest)) {
            return false;
        }
        ListRepositoryAssociationsRequest other = (ListRepositoryAssociationsRequest) obj;
        return Objects.equals(providerTypesAsStrings(), other.providerTypesAsStrings())
                && Objects.equals(statesAsStrings(), other.statesAsStrings()) && Objects.equals(names(), other.names())
                && Objects.equals(owners(), other.owners()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRepositoryAssociationsRequest").add("ProviderTypes", providerTypesAsStrings())
                .add("States", statesAsStrings()).add("Names", names()).add("Owners", owners()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderTypes":
            return Optional.ofNullable(clazz.cast(providerTypesAsStrings()));
        case "States":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "Owners":
            return Optional.ofNullable(clazz.cast(owners()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoryAssociationsRequest, T> g) {
        return obj -> g.apply((ListRepositoryAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRepositoryAssociationsRequest> {
        /**
         * <p>
         * List of provider types to use as a filter.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types to use as a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypesWithStrings(Collection<String> providerTypes);

        /**
         * <p>
         * List of provider types to use as a filter.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types to use as a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypesWithStrings(String... providerTypes);

        /**
         * <p>
         * List of provider types to use as a filter.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types to use as a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypes(Collection<ProviderType> providerTypes);

        /**
         * <p>
         * List of provider types to use as a filter.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types to use as a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypes(ProviderType... providerTypes);

        /**
         * <p>
         * List of repository association states to use as a filter.
         * </p>
         * <p>
         * The valid repository association states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Associated</b>: The repository association is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Associating</b>: CodeGuru Reviewer is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer
         * review.
         * </p>
         * <note>
         * <p>
         * If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru
         * Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these
         * webhooks, reviews of code in your repository cannot be triggered.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         * repository.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Failed</b>: The repository failed to associate or disassociate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source
         * code access.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of repository association states to use as a filter.</p>
         *        <p>
         *        The valid repository association states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Associated</b>: The repository association is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Associating</b>: CodeGuru Reviewer is:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru
         *        Reviewer review.
         *        </p>
         *        <note>
         *        <p>
         *        If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>,
         *        CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you
         *        delete these webhooks, reviews of code in your repository cannot be triggered.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         *        repository.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Failed</b>: The repository failed to associate or disassociate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
         *        source code access.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * List of repository association states to use as a filter.
         * </p>
         * <p>
         * The valid repository association states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Associated</b>: The repository association is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Associating</b>: CodeGuru Reviewer is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer
         * review.
         * </p>
         * <note>
         * <p>
         * If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru
         * Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these
         * webhooks, reviews of code in your repository cannot be triggered.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         * repository.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Failed</b>: The repository failed to associate or disassociate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source
         * code access.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of repository association states to use as a filter.</p>
         *        <p>
         *        The valid repository association states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Associated</b>: The repository association is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Associating</b>: CodeGuru Reviewer is:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru
         *        Reviewer review.
         *        </p>
         *        <note>
         *        <p>
         *        If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>,
         *        CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you
         *        delete these webhooks, reviews of code in your repository cannot be triggered.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         *        repository.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Failed</b>: The repository failed to associate or disassociate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
         *        source code access.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * List of repository association states to use as a filter.
         * </p>
         * <p>
         * The valid repository association states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Associated</b>: The repository association is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Associating</b>: CodeGuru Reviewer is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer
         * review.
         * </p>
         * <note>
         * <p>
         * If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru
         * Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these
         * webhooks, reviews of code in your repository cannot be triggered.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         * repository.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Failed</b>: The repository failed to associate or disassociate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source
         * code access.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of repository association states to use as a filter.</p>
         *        <p>
         *        The valid repository association states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Associated</b>: The repository association is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Associating</b>: CodeGuru Reviewer is:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru
         *        Reviewer review.
         *        </p>
         *        <note>
         *        <p>
         *        If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>,
         *        CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you
         *        delete these webhooks, reviews of code in your repository cannot be triggered.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         *        repository.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Failed</b>: The repository failed to associate or disassociate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
         *        source code access.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<RepositoryAssociationState> states);

        /**
         * <p>
         * List of repository association states to use as a filter.
         * </p>
         * <p>
         * The valid repository association states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Associated</b>: The repository association is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Associating</b>: CodeGuru Reviewer is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer
         * review.
         * </p>
         * <note>
         * <p>
         * If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru
         * Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these
         * webhooks, reviews of code in your repository cannot be triggered.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         * repository.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Failed</b>: The repository failed to associate or disassociate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and source
         * code access.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of repository association states to use as a filter.</p>
         *        <p>
         *        The valid repository association states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Associated</b>: The repository association is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Associating</b>: CodeGuru Reviewer is:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru
         *        Reviewer review.
         *        </p>
         *        <note>
         *        <p>
         *        If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>,
         *        CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you
         *        delete these webhooks, reviews of code in your repository cannot be triggered.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your
         *        repository.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Failed</b>: The repository failed to associate or disassociate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Disassociating</b>: CodeGuru Reviewer is removing the repository's pull request notifications and
         *        source code access.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(RepositoryAssociationState... states);

        /**
         * <p>
         * List of repository names to use as a filter.
         * </p>
         * 
         * @param names
         *        List of repository names to use as a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * List of repository names to use as a filter.
         * </p>
         * 
         * @param names
         *        List of repository names to use as a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * List of owners to use as a filter. For AWS CodeCommit, it is the name of the CodeCommit account that was used
         * to associate the repository. For other repository source providers, such as Bitbucket, this is name of the
         * account that was used to associate the repository.
         * </p>
         * 
         * @param owners
         *        List of owners to use as a filter. For AWS CodeCommit, it is the name of the CodeCommit account that
         *        was used to associate the repository. For other repository source providers, such as Bitbucket, this
         *        is name of the account that was used to associate the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(Collection<String> owners);

        /**
         * <p>
         * List of owners to use as a filter. For AWS CodeCommit, it is the name of the CodeCommit account that was used
         * to associate the repository. For other repository source providers, such as Bitbucket, this is name of the
         * account that was used to associate the repository.
         * </p>
         * 
         * @param owners
         *        List of owners to use as a filter. For AWS CodeCommit, it is the name of the CodeCommit account that
         *        was used to associate the repository. For other repository source providers, such as Bitbucket, this
         *        is name of the account that was used to associate the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(String... owners);

        /**
         * <p>
         * The maximum number of repository association results returned by <code>ListRepositoryAssociations</code> in
         * paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns
         * <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The
         * remaining results of the initial request can be seen by sending another
         * <code>ListRepositoryAssociations</code> request with the returned <code>nextToken</code> value. This value
         * can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code> returns up
         * to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of repository association results returned by
         *        <code>ListRepositoryAssociations</code> in paginated output. When this parameter is used,
         *        <code>ListRepositoryAssociations</code> only returns <code>maxResults</code> results in a single page
         *        with a <code>nextToken</code> response element. The remaining results of the initial request can be
         *        seen by sending another <code>ListRepositoryAssociations</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used,
         *        <code>ListRepositoryAssociations</code> returns up to 100 results and a <code>nextToken</code> value
         *        if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListRepositoryAssociations</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not for
         * other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results
         *        exceeded the value of that parameter. Pagination continues from the end of the previous results that
         *        returned the <code>nextToken</code> value. </p> <note>
         *        <p>
         *        Treat this token as an opaque identifier that is only used to retrieve the next items in a list and
         *        not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruReviewerRequest.BuilderImpl implements Builder {
        private List<String> providerTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private List<String> owners = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoryAssociationsRequest model) {
            super(model);
            providerTypesWithStrings(model.providerTypes);
            statesWithStrings(model.states);
            names(model.names);
            owners(model.owners);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getProviderTypes() {
            return providerTypes;
        }

        @Override
        public final Builder providerTypesWithStrings(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypesWithStrings(String... providerTypes) {
            providerTypesWithStrings(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        public final Builder providerTypes(Collection<ProviderType> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copyEnumToString(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(ProviderType... providerTypes) {
            providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        public final void setProviderTypes(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
        }

        public final Collection<String> getStates() {
            return states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = RepositoryAssociationStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<RepositoryAssociationState> states) {
            this.states = RepositoryAssociationStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(RepositoryAssociationState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = RepositoryAssociationStatesCopier.copy(states);
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = NamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = NamesCopier.copy(names);
        }

        public final Collection<String> getOwners() {
            return owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnersCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String... owners) {
            owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnersCopier.copy(owners);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositoryAssociationsRequest build() {
            return new ListRepositoryAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
