/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateRepositoryRequest extends CodeGuruReviewerRequest implements
        ToCopyableBuilder<AssociateRepositoryRequest.Builder, AssociateRepositoryRequest> {
    private static final SdkField<Repository> REPOSITORY_FIELD = SdkField.<Repository> builder(MarshallingType.SDK_POJO)
            .getter(getter(AssociateRepositoryRequest::repository)).setter(setter(Builder::repository))
            .constructor(Repository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateRepositoryRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final Repository repository;

    private final String clientRequestToken;

    private AssociateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.repository = builder.repository;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The repository to associate.
     * </p>
     * 
     * @return The repository to associate.
     */
    public Repository repository() {
        return repository;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * <p>
     * To add a new repository association, this parameter specifies a unique identifier for the new repository
     * association that helps ensure idempotency.
     * </p>
     * <p>
     * If you use the AWS CLI or one of the AWS SDKs to call this operation, you can leave this parameter empty. The CLI
     * or SDK generates a random UUID for you and includes that in the request. If you don't use the SDK and instead
     * generate a raw HTTP request to the Secrets Manager service endpoint, you must generate a ClientRequestToken
     * yourself for new versions and include that value in the request.
     * </p>
     * <p>
     * You typically interact with this value if you implement your own retry logic and want to ensure that a given
     * repository association is not created twice. We recommend that you generate a UUID-type value to ensure
     * uniqueness within the specified repository association.
     * </p>
     * <p>
     * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations
     * if there are failures and retries.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
     *         <p>
     *         To add a new repository association, this parameter specifies a unique identifier for the new repository
     *         association that helps ensure idempotency.
     *         </p>
     *         <p>
     *         If you use the AWS CLI or one of the AWS SDKs to call this operation, you can leave this parameter empty.
     *         The CLI or SDK generates a random UUID for you and includes that in the request. If you don't use the SDK
     *         and instead generate a raw HTTP request to the Secrets Manager service endpoint, you must generate a
     *         ClientRequestToken yourself for new versions and include that value in the request.
     *         </p>
     *         <p>
     *         You typically interact with this value if you implement your own retry logic and want to ensure that a
     *         given repository association is not created twice. We recommend that you generate a UUID-type value to
     *         ensure uniqueness within the specified repository association.
     *         </p>
     *         <p>
     *         Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
     *         associations if there are failures and retries.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRepositoryRequest)) {
            return false;
        }
        AssociateRepositoryRequest other = (AssociateRepositoryRequest) obj;
        return Objects.equals(repository(), other.repository())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateRepositoryRequest").add("Repository", repository())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateRepositoryRequest, T> g) {
        return obj -> g.apply((AssociateRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateRepositoryRequest> {
        /**
         * <p>
         * The repository to associate.
         * </p>
         * 
         * @param repository
         *        The repository to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(Repository repository);

        /**
         * <p>
         * The repository to associate.
         * </p>
         * This is a convenience that creates an instance of the {@link Repository.Builder} avoiding the need to create
         * one manually via {@link Repository#builder()}.
         *
         * When the {@link Consumer} completes, {@link Repository.Builder#build()} is called immediately and its result
         * is passed to {@link #repository(Repository)}.
         * 
         * @param repository
         *        a consumer that will call methods on {@link Repository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repository(Repository)
         */
        default Builder repository(Consumer<Repository.Builder> repository) {
            return repository(Repository.builder().applyMutation(repository).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * <p>
         * To add a new repository association, this parameter specifies a unique identifier for the new repository
         * association that helps ensure idempotency.
         * </p>
         * <p>
         * If you use the AWS CLI or one of the AWS SDKs to call this operation, you can leave this parameter empty. The
         * CLI or SDK generates a random UUID for you and includes that in the request. If you don't use the SDK and
         * instead generate a raw HTTP request to the Secrets Manager service endpoint, you must generate a
         * ClientRequestToken yourself for new versions and include that value in the request.
         * </p>
         * <p>
         * You typically interact with this value if you implement your own retry logic and want to ensure that a given
         * repository association is not created twice. We recommend that you generate a UUID-type value to ensure
         * uniqueness within the specified repository association.
         * </p>
         * <p>
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
         * associations if there are failures and retries.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
         *        <p>
         *        To add a new repository association, this parameter specifies a unique identifier for the new
         *        repository association that helps ensure idempotency.
         *        </p>
         *        <p>
         *        If you use the AWS CLI or one of the AWS SDKs to call this operation, you can leave this parameter
         *        empty. The CLI or SDK generates a random UUID for you and includes that in the request. If you don't
         *        use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, you must
         *        generate a ClientRequestToken yourself for new versions and include that value in the request.
         *        </p>
         *        <p>
         *        You typically interact with this value if you implement your own retry logic and want to ensure that a
         *        given repository association is not created twice. We recommend that you generate a UUID-type value to
         *        ensure uniqueness within the specified repository association.
         *        </p>
         *        <p>
         *        Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
         *        associations if there are failures and retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruReviewerRequest.BuilderImpl implements Builder {
        private Repository repository;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRepositoryRequest model) {
            super(model);
            repository(model.repository);
            clientRequestToken(model.clientRequestToken);
        }

        public final Repository.Builder getRepository() {
            return repository != null ? repository.toBuilder() : null;
        }

        @Override
        public final Builder repository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(Repository.BuilderImpl repository) {
            this.repository = repository != null ? repository.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateRepositoryRequest build() {
            return new AssociateRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
