/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the source code that is analyzed in a code review. A code review can analyze the source code that is
 * specified using a pull request diff or a branch in an associated repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCodeType implements SdkPojo, Serializable, ToCopyableBuilder<SourceCodeType.Builder, SourceCodeType> {
    private static final SdkField<CommitDiffSourceCodeType> COMMIT_DIFF_FIELD = SdkField
            .<CommitDiffSourceCodeType> builder(MarshallingType.SDK_POJO).getter(getter(SourceCodeType::commitDiff))
            .setter(setter(Builder::commitDiff)).constructor(CommitDiffSourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitDiff").build()).build();

    private static final SdkField<RepositoryHeadSourceCodeType> REPOSITORY_HEAD_FIELD = SdkField
            .<RepositoryHeadSourceCodeType> builder(MarshallingType.SDK_POJO).getter(getter(SourceCodeType::repositoryHead))
            .setter(setter(Builder::repositoryHead)).constructor(RepositoryHeadSourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryHead").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_DIFF_FIELD,
            REPOSITORY_HEAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final CommitDiffSourceCodeType commitDiff;

    private final RepositoryHeadSourceCodeType repositoryHead;

    private SourceCodeType(BuilderImpl builder) {
        this.commitDiff = builder.commitDiff;
        this.repositoryHead = builder.repositoryHead;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
     * repository.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     *         <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
     *         repository.
     */
    public CommitDiffSourceCodeType commitDiff() {
        return commitDiff;
    }

    /**
     * Returns the value of the RepositoryHead property for this object.
     * 
     * @return The value of the RepositoryHead property for this object.
     */
    public RepositoryHeadSourceCodeType repositoryHead() {
        return repositoryHead;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitDiff());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryHead());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCodeType)) {
            return false;
        }
        SourceCodeType other = (SourceCodeType) obj;
        return Objects.equals(commitDiff(), other.commitDiff()) && Objects.equals(repositoryHead(), other.repositoryHead());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SourceCodeType").add("CommitDiff", commitDiff()).add("RepositoryHead", repositoryHead()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommitDiff":
            return Optional.ofNullable(clazz.cast(commitDiff()));
        case "RepositoryHead":
            return Optional.ofNullable(clazz.cast(repositoryHead()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCodeType, T> g) {
        return obj -> g.apply((SourceCodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCodeType> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
         * repository.
         * </p>
         * 
         * @param commitDiff
         *        A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         *        <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an
         *        associated repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitDiff(CommitDiffSourceCodeType commitDiff);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
         * repository.
         * </p>
         * This is a convenience that creates an instance of the {@link CommitDiffSourceCodeType.Builder} avoiding the
         * need to create one manually via {@link CommitDiffSourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CommitDiffSourceCodeType.Builder#build()} is called immediately
         * and its result is passed to {@link #commitDiff(CommitDiffSourceCodeType)}.
         * 
         * @param commitDiff
         *        a consumer that will call methods on {@link CommitDiffSourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitDiff(CommitDiffSourceCodeType)
         */
        default Builder commitDiff(Consumer<CommitDiffSourceCodeType.Builder> commitDiff) {
            return commitDiff(CommitDiffSourceCodeType.builder().applyMutation(commitDiff).build());
        }

        /**
         * Sets the value of the RepositoryHead property for this object.
         *
         * @param repositoryHead
         *        The new value for the RepositoryHead property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead);

        /**
         * Sets the value of the RepositoryHead property for this object.
         *
         * This is a convenience that creates an instance of the {@link RepositoryHeadSourceCodeType.Builder} avoiding
         * the need to create one manually via {@link RepositoryHeadSourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryHeadSourceCodeType.Builder#build()} is called
         * immediately and its result is passed to {@link #repositoryHead(RepositoryHeadSourceCodeType)}.
         * 
         * @param repositoryHead
         *        a consumer that will call methods on {@link RepositoryHeadSourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryHead(RepositoryHeadSourceCodeType)
         */
        default Builder repositoryHead(Consumer<RepositoryHeadSourceCodeType.Builder> repositoryHead) {
            return repositoryHead(RepositoryHeadSourceCodeType.builder().applyMutation(repositoryHead).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CommitDiffSourceCodeType commitDiff;

        private RepositoryHeadSourceCodeType repositoryHead;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCodeType model) {
            commitDiff(model.commitDiff);
            repositoryHead(model.repositoryHead);
        }

        public final CommitDiffSourceCodeType.Builder getCommitDiff() {
            return commitDiff != null ? commitDiff.toBuilder() : null;
        }

        @Override
        public final Builder commitDiff(CommitDiffSourceCodeType commitDiff) {
            this.commitDiff = commitDiff;
            return this;
        }

        public final void setCommitDiff(CommitDiffSourceCodeType.BuilderImpl commitDiff) {
            this.commitDiff = commitDiff != null ? commitDiff.build() : null;
        }

        public final RepositoryHeadSourceCodeType.Builder getRepositoryHead() {
            return repositoryHead != null ? repositoryHead.toBuilder() : null;
        }

        @Override
        public final Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead) {
            this.repositoryHead = repositoryHead;
            return this;
        }

        public final void setRepositoryHead(RepositoryHeadSourceCodeType.BuilderImpl repositoryHead) {
            this.repositoryHead = repositoryHead != null ? repositoryHead.build() : null;
        }

        @Override
        public SourceCodeType build() {
            return new SourceCodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
