/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCodeReviewResponse extends CodeGuruReviewerResponse implements
        ToCopyableBuilder<DescribeCodeReviewResponse.Builder, DescribeCodeReviewResponse> {
    private static final SdkField<CodeReview> CODE_REVIEW_FIELD = SdkField.<CodeReview> builder(MarshallingType.SDK_POJO)
            .memberName("CodeReview").getter(getter(DescribeCodeReviewResponse::codeReview)).setter(setter(Builder::codeReview))
            .constructor(CodeReview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReview").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_FIELD));

    private final CodeReview codeReview;

    private DescribeCodeReviewResponse(BuilderImpl builder) {
        super(builder);
        this.codeReview = builder.codeReview;
    }

    /**
     * <p>
     * Information about the code review.
     * </p>
     * 
     * @return Information about the code review.
     */
    public CodeReview codeReview() {
        return codeReview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeReview());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeReviewResponse)) {
            return false;
        }
        DescribeCodeReviewResponse other = (DescribeCodeReviewResponse) obj;
        return Objects.equals(codeReview(), other.codeReview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCodeReviewResponse").add("CodeReview", codeReview()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeReview":
            return Optional.ofNullable(clazz.cast(codeReview()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeReviewResponse, T> g) {
        return obj -> g.apply((DescribeCodeReviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCodeReviewResponse> {
        /**
         * <p>
         * Information about the code review.
         * </p>
         * 
         * @param codeReview
         *        Information about the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReview(CodeReview codeReview);

        /**
         * <p>
         * Information about the code review.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeReview.Builder} avoiding the need to create
         * one manually via {@link CodeReview#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeReview.Builder#build()} is called immediately and its result
         * is passed to {@link #codeReview(CodeReview)}.
         * 
         * @param codeReview
         *        a consumer that will call methods on {@link CodeReview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeReview(CodeReview)
         */
        default Builder codeReview(Consumer<CodeReview.Builder> codeReview) {
            return codeReview(CodeReview.builder().applyMutation(codeReview).build());
        }
    }

    static final class BuilderImpl extends CodeGuruReviewerResponse.BuilderImpl implements Builder {
        private CodeReview codeReview;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeReviewResponse model) {
            super(model);
            codeReview(model.codeReview);
        }

        public final CodeReview.Builder getCodeReview() {
            return codeReview != null ? codeReview.toBuilder() : null;
        }

        @Override
        public final Builder codeReview(CodeReview codeReview) {
            this.codeReview = codeReview;
            return this;
        }

        public final void setCodeReview(CodeReview.BuilderImpl codeReview) {
            this.codeReview = codeReview != null ? codeReview.build() : null;
        }

        @Override
        public DescribeCodeReviewResponse build() {
            return new DescribeCodeReviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
