/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCodeReviewRequest extends CodeGuruReviewerRequest implements
        ToCopyableBuilder<DescribeCodeReviewRequest.Builder, DescribeCodeReviewRequest> {
    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeReviewArn").getter(getter(DescribeCodeReviewRequest::codeReviewArn))
            .setter(setter(Builder::codeReviewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CodeReviewArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_ARN_FIELD));

    private final String codeReviewArn;

    private DescribeCodeReviewRequest(BuilderImpl builder) {
        super(builder);
        this.codeReviewArn = builder.codeReviewArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a>
     * object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     *         <code>CodeReview</code> </a> object.
     */
    public String codeReviewArn() {
        return codeReviewArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeReviewArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeReviewRequest)) {
            return false;
        }
        DescribeCodeReviewRequest other = (DescribeCodeReviewRequest) obj;
        return Objects.equals(codeReviewArn(), other.codeReviewArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCodeReviewRequest").add("CodeReviewArn", codeReviewArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeReviewArn":
            return Optional.ofNullable(clazz.cast(codeReviewArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeReviewRequest, T> g) {
        return obj -> g.apply((DescribeCodeReviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCodeReviewRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code>
         * </a> object.
         * </p>
         * 
         * @param codeReviewArn
         *        The Amazon Resource Name (ARN) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         *        <code>CodeReview</code> </a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewArn(String codeReviewArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruReviewerRequest.BuilderImpl implements Builder {
        private String codeReviewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeReviewRequest model) {
            super(model);
            codeReviewArn(model.codeReviewArn);
        }

        public final String getCodeReviewArn() {
            return codeReviewArn;
        }

        @Override
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCodeReviewRequest build() {
            return new DescribeCodeReviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
