/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateRepositoryResponse extends CodeGuruReviewerResponse implements
        ToCopyableBuilder<DisassociateRepositoryResponse.Builder, DisassociateRepositoryResponse> {
    private static final SdkField<RepositoryAssociation> REPOSITORY_ASSOCIATION_FIELD = SdkField
            .<RepositoryAssociation> builder(MarshallingType.SDK_POJO).memberName("RepositoryAssociation")
            .getter(getter(DisassociateRepositoryResponse::repositoryAssociation)).setter(setter(Builder::repositoryAssociation))
            .constructor(RepositoryAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAssociation").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DisassociateRepositoryResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ASSOCIATION_FIELD,
            TAGS_FIELD));

    private final RepositoryAssociation repositoryAssociation;

    private final Map<String, String> tags;

    private DisassociateRepositoryResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryAssociation = builder.repositoryAssociation;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Information about the disassociated repository.
     * </p>
     * 
     * @return Information about the disassociated repository.
     */
    public RepositoryAssociation repositoryAssociation() {
        return repositoryAssociation;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two
     * parts:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
     * <code>Secret</code>). Tag keys are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>, <code>Production</code>,
     * or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case
     * sensitive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with
     *         two parts: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>,
     *         or <code>Secret</code>). Tag keys are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>,
     *         <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string.
     *         Like tag keys, tag values are case sensitive.
     *         </p>
     *         </li>
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateRepositoryResponse)) {
            return false;
        }
        DisassociateRepositoryResponse other = (DisassociateRepositoryResponse) obj;
        return Objects.equals(repositoryAssociation(), other.repositoryAssociation()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateRepositoryResponse").add("RepositoryAssociation", repositoryAssociation())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryAssociation":
            return Optional.ofNullable(clazz.cast(repositoryAssociation()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateRepositoryResponse, T> g) {
        return obj -> g.apply((DisassociateRepositoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateRepositoryResponse> {
        /**
         * <p>
         * Information about the disassociated repository.
         * </p>
         * 
         * @param repositoryAssociation
         *        Information about the disassociated repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryAssociation(RepositoryAssociation repositoryAssociation);

        /**
         * <p>
         * Information about the disassociated repository.
         * </p>
         * This is a convenience that creates an instance of the {@link RepositoryAssociation.Builder} avoiding the need
         * to create one manually via {@link RepositoryAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #repositoryAssociation(RepositoryAssociation)}.
         * 
         * @param repositoryAssociation
         *        a consumer that will call methods on {@link RepositoryAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryAssociation(RepositoryAssociation)
         */
        default Builder repositoryAssociation(Consumer<RepositoryAssociation.Builder> repositoryAssociation) {
            return repositoryAssociation(RepositoryAssociation.builder().applyMutation(repositoryAssociation).build());
        }

        /**
         * <p>
         * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two
         * parts:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
         * <code>Secret</code>). Tag keys are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>,
         * <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string. Like
         * tag keys, tag values are case sensitive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label
         *        with two parts: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <i>tag key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>
         *        , or <code>Secret</code>). Tag keys are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An optional field known as a <i>tag value</i> (for example, <code>111122223333</code>,
         *        <code>Production</code>, or a team name). Omitting the tag value is the same as using an empty string.
         *        Like tag keys, tag values are case sensitive.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CodeGuruReviewerResponse.BuilderImpl implements Builder {
        private RepositoryAssociation repositoryAssociation;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateRepositoryResponse model) {
            super(model);
            repositoryAssociation(model.repositoryAssociation);
            tags(model.tags);
        }

        public final RepositoryAssociation.Builder getRepositoryAssociation() {
            return repositoryAssociation != null ? repositoryAssociation.toBuilder() : null;
        }

        @Override
        public final Builder repositoryAssociation(RepositoryAssociation repositoryAssociation) {
            this.repositoryAssociation = repositoryAssociation;
            return this;
        }

        public final void setRepositoryAssociation(RepositoryAssociation.BuilderImpl repositoryAssociation) {
            this.repositoryAssociation = repositoryAssociation != null ? repositoryAssociation.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DisassociateRepositoryResponse build() {
            return new DisassociateRepositoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
