/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecommendationFeedbackRequest extends CodeGuruReviewerRequest implements
        ToCopyableBuilder<PutRecommendationFeedbackRequest.Builder, PutRecommendationFeedbackRequest> {
    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeReviewArn").getter(getter(PutRecommendationFeedbackRequest::codeReviewArn))
            .setter(setter(Builder::codeReviewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewArn").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(PutRecommendationFeedbackRequest::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<List<String>> REACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Reactions")
            .getter(getter(PutRecommendationFeedbackRequest::reactionsAsStrings))
            .setter(setter(Builder::reactionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reactions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_ARN_FIELD,
            RECOMMENDATION_ID_FIELD, REACTIONS_FIELD));

    private final String codeReviewArn;

    private final String recommendationId;

    private final List<String> reactions;

    private PutRecommendationFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.codeReviewArn = builder.codeReviewArn;
        this.recommendationId = builder.recommendationId;
        this.reactions = builder.reactions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a>
     * object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     *         <code>CodeReview</code> </a> object.
     */
    public final String codeReviewArn() {
        return codeReviewArn;
    }

    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations and then to collect the feedback.
     * </p>
     * 
     * @return The recommendation ID that can be used to track the provided recommendations and then to collect the
     *         feedback.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all
     * your feedback.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReactions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears
     *         all your feedback.
     */
    public final List<Reaction> reactions() {
        return ReactionsCopier.copyStringToEnum(reactions);
    }

    /**
     * Returns true if the Reactions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReactions() {
        return reactions != null && !(reactions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all
     * your feedback.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReactions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears
     *         all your feedback.
     */
    public final List<String> reactionsAsStrings() {
        return reactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReactions() ? reactionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecommendationFeedbackRequest)) {
            return false;
        }
        PutRecommendationFeedbackRequest other = (PutRecommendationFeedbackRequest) obj;
        return Objects.equals(codeReviewArn(), other.codeReviewArn())
                && Objects.equals(recommendationId(), other.recommendationId()) && hasReactions() == other.hasReactions()
                && Objects.equals(reactionsAsStrings(), other.reactionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecommendationFeedbackRequest").add("CodeReviewArn", codeReviewArn())
                .add("RecommendationId", recommendationId()).add("Reactions", hasReactions() ? reactionsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeReviewArn":
            return Optional.ofNullable(clazz.cast(codeReviewArn()));
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "Reactions":
            return Optional.ofNullable(clazz.cast(reactionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecommendationFeedbackRequest, T> g) {
        return obj -> g.apply((PutRecommendationFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRecommendationFeedbackRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code>
         * </a> object.
         * </p>
         * 
         * @param codeReviewArn
         *        The Amazon Resource Name (ARN) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         *        <code>CodeReview</code> </a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewArn(String codeReviewArn);

        /**
         * <p>
         * The recommendation ID that can be used to track the provided recommendations and then to collect the
         * feedback.
         * </p>
         * 
         * @param recommendationId
         *        The recommendation ID that can be used to track the provided recommendations and then to collect the
         *        feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all
         * your feedback.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it
         *        clears all your feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionsWithStrings(Collection<String> reactions);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all
         * your feedback.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it
         *        clears all your feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionsWithStrings(String... reactions);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all
         * your feedback.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it
         *        clears all your feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactions(Collection<Reaction> reactions);

        /**
         * <p>
         * List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all
         * your feedback.
         * </p>
         * 
         * @param reactions
         *        List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it
         *        clears all your feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactions(Reaction... reactions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruReviewerRequest.BuilderImpl implements Builder {
        private String codeReviewArn;

        private String recommendationId;

        private List<String> reactions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecommendationFeedbackRequest model) {
            super(model);
            codeReviewArn(model.codeReviewArn);
            recommendationId(model.recommendationId);
            reactionsWithStrings(model.reactions);
        }

        public final String getCodeReviewArn() {
            return codeReviewArn;
        }

        @Override
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final Collection<String> getReactions() {
            if (reactions instanceof SdkAutoConstructList) {
                return null;
            }
            return reactions;
        }

        @Override
        public final Builder reactionsWithStrings(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionsWithStrings(String... reactions) {
            reactionsWithStrings(Arrays.asList(reactions));
            return this;
        }

        @Override
        public final Builder reactions(Collection<Reaction> reactions) {
            this.reactions = ReactionsCopier.copyEnumToString(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactions(Reaction... reactions) {
            reactions(Arrays.asList(reactions));
            return this;
        }

        public final void setReactions(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecommendationFeedbackRequest build() {
            return new PutRecommendationFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
