/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType"> <code>SourceCodeType</code>
 * </a> that specifies the tip of a branch in an associated repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryHeadSourceCodeType implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryHeadSourceCodeType.Builder, RepositoryHeadSourceCodeType> {
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BranchName").getter(getter(RepositoryHeadSourceCodeType::branchName))
            .setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String branchName;

    private RepositoryHeadSourceCodeType(BuilderImpl builder) {
        this.branchName = builder.branchName;
    }

    /**
     * <p>
     * The name of the branch in an associated repository. The <code>RepositoryHeadSourceCodeType</code> specifies the
     * tip of this branch.
     * </p>
     * 
     * @return The name of the branch in an associated repository. The <code>RepositoryHeadSourceCodeType</code>
     *         specifies the tip of this branch.
     */
    public final String branchName() {
        return branchName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryHeadSourceCodeType)) {
            return false;
        }
        RepositoryHeadSourceCodeType other = (RepositoryHeadSourceCodeType) obj;
        return Objects.equals(branchName(), other.branchName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryHeadSourceCodeType").add("BranchName", branchName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BranchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryHeadSourceCodeType, T> g) {
        return obj -> g.apply((RepositoryHeadSourceCodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryHeadSourceCodeType> {
        /**
         * <p>
         * The name of the branch in an associated repository. The <code>RepositoryHeadSourceCodeType</code> specifies
         * the tip of this branch.
         * </p>
         * 
         * @param branchName
         *        The name of the branch in an associated repository. The <code>RepositoryHeadSourceCodeType</code>
         *        specifies the tip of this branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);
    }

    static final class BuilderImpl implements Builder {
        private String branchName;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryHeadSourceCodeType model) {
            branchName(model.branchName);
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public RepositoryHeadSourceCodeType build() {
            return new RepositoryHeadSourceCodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
