/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
 * <code>SourceCodeType</code> </a> that specifies the commit diff for a pull request on an associated repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommitDiffSourceCodeType implements SdkPojo, Serializable,
        ToCopyableBuilder<CommitDiffSourceCodeType.Builder, CommitDiffSourceCodeType> {
    private static final SdkField<String> SOURCE_COMMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceCommit").getter(getter(CommitDiffSourceCodeType::sourceCommit))
            .setter(setter(Builder::sourceCommit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCommit").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationCommit").getter(getter(CommitDiffSourceCodeType::destinationCommit))
            .setter(setter(Builder::destinationCommit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCommit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COMMIT_FIELD,
            DESTINATION_COMMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceCommit;

    private final String destinationCommit;

    private CommitDiffSourceCodeType(BuilderImpl builder) {
        this.sourceCommit = builder.sourceCommit;
        this.destinationCommit = builder.destinationCommit;
    }

    /**
     * <p>
     * The SHA of the source commit used to generate a commit diff.
     * </p>
     * 
     * @return The SHA of the source commit used to generate a commit diff.
     */
    public final String sourceCommit() {
        return sourceCommit;
    }

    /**
     * <p>
     * The SHA of the destination commit used to generate a commit diff.
     * </p>
     * 
     * @return The SHA of the destination commit used to generate a commit diff.
     */
    public final String destinationCommit() {
        return destinationCommit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommit());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitDiffSourceCodeType)) {
            return false;
        }
        CommitDiffSourceCodeType other = (CommitDiffSourceCodeType) obj;
        return Objects.equals(sourceCommit(), other.sourceCommit())
                && Objects.equals(destinationCommit(), other.destinationCommit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommitDiffSourceCodeType").add("SourceCommit", sourceCommit())
                .add("DestinationCommit", destinationCommit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceCommit":
            return Optional.ofNullable(clazz.cast(sourceCommit()));
        case "DestinationCommit":
            return Optional.ofNullable(clazz.cast(destinationCommit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitDiffSourceCodeType, T> g) {
        return obj -> g.apply((CommitDiffSourceCodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommitDiffSourceCodeType> {
        /**
         * <p>
         * The SHA of the source commit used to generate a commit diff.
         * </p>
         * 
         * @param sourceCommit
         *        The SHA of the source commit used to generate a commit diff.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommit(String sourceCommit);

        /**
         * <p>
         * The SHA of the destination commit used to generate a commit diff.
         * </p>
         * 
         * @param destinationCommit
         *        The SHA of the destination commit used to generate a commit diff.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommit(String destinationCommit);
    }

    static final class BuilderImpl implements Builder {
        private String sourceCommit;

        private String destinationCommit;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitDiffSourceCodeType model) {
            sourceCommit(model.sourceCommit);
            destinationCommit(model.destinationCommit);
        }

        public final String getSourceCommit() {
            return sourceCommit;
        }

        @Override
        public final Builder sourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
            return this;
        }

        public final void setSourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
        }

        public final String getDestinationCommit() {
            return destinationCommit;
        }

        @Override
        public final Builder destinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
            return this;
        }

        public final void setDestinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
        }

        @Override
        public CommitDiffSourceCodeType build() {
            return new CommitDiffSourceCodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
