/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A code review type that analyzes all code under a specified branch in an associated repository. The associated
 * repository is specified using its ARN when you call <a
 * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview"> <code>CreateCodeReview</code>
 * </a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryAnalysis implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryAnalysis.Builder, RepositoryAnalysis> {
    private static final SdkField<RepositoryHeadSourceCodeType> REPOSITORY_HEAD_FIELD = SdkField
            .<RepositoryHeadSourceCodeType> builder(MarshallingType.SDK_POJO).memberName("RepositoryHead")
            .getter(getter(RepositoryAnalysis::repositoryHead)).setter(setter(Builder::repositoryHead))
            .constructor(RepositoryHeadSourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryHead").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_HEAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final RepositoryHeadSourceCodeType repositoryHead;

    private RepositoryAnalysis(BuilderImpl builder) {
        this.repositoryHead = builder.repositoryHead;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * <code>SourceCodeType</code> </a> that specifies the tip of a branch in an associated repository.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     *         <code>SourceCodeType</code> </a> that specifies the tip of a branch in an associated repository.
     */
    public final RepositoryHeadSourceCodeType repositoryHead() {
        return repositoryHead;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryHead());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAnalysis)) {
            return false;
        }
        RepositoryAnalysis other = (RepositoryAnalysis) obj;
        return Objects.equals(repositoryHead(), other.repositoryHead());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryAnalysis").add("RepositoryHead", repositoryHead()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryHead":
            return Optional.ofNullable(clazz.cast(repositoryHead()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryAnalysis, T> g) {
        return obj -> g.apply((RepositoryAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryAnalysis> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies the tip of a branch in an associated repository.
         * </p>
         * 
         * @param repositoryHead
         *        A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         *        <code>SourceCodeType</code> </a> that specifies the tip of a branch in an associated repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies the tip of a branch in an associated repository.
         * </p>
         * This is a convenience that creates an instance of the {@link RepositoryHeadSourceCodeType.Builder} avoiding
         * the need to create one manually via {@link RepositoryHeadSourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryHeadSourceCodeType.Builder#build()} is called
         * immediately and its result is passed to {@link #repositoryHead(RepositoryHeadSourceCodeType)}.
         * 
         * @param repositoryHead
         *        a consumer that will call methods on {@link RepositoryHeadSourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryHead(RepositoryHeadSourceCodeType)
         */
        default Builder repositoryHead(Consumer<RepositoryHeadSourceCodeType.Builder> repositoryHead) {
            return repositoryHead(RepositoryHeadSourceCodeType.builder().applyMutation(repositoryHead).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RepositoryHeadSourceCodeType repositoryHead;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryAnalysis model) {
            repositoryHead(model.repositoryHead);
        }

        public final RepositoryHeadSourceCodeType.Builder getRepositoryHead() {
            return repositoryHead != null ? repositoryHead.toBuilder() : null;
        }

        @Override
        public final Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead) {
            this.repositoryHead = repositoryHead;
            return this;
        }

        public final void setRepositoryHead(RepositoryHeadSourceCodeType.BuilderImpl repositoryHead) {
            this.repositoryHead = repositoryHead != null ? repositoryHead.build() : null;
        }

        @Override
        public RepositoryAnalysis build() {
            return new RepositoryAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
