/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
 * <code>SourceCodeType</code> </a> that specifies the commit diff for a pull request on an associated repository. The
 * <code>SourceCommit</code> and <code>DestinationCommit</code> fields are required to do a pull request code review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommitDiffSourceCodeType implements SdkPojo, Serializable,
        ToCopyableBuilder<CommitDiffSourceCodeType.Builder, CommitDiffSourceCodeType> {
    private static final SdkField<String> SOURCE_COMMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceCommit").getter(getter(CommitDiffSourceCodeType::sourceCommit))
            .setter(setter(Builder::sourceCommit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCommit").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationCommit").getter(getter(CommitDiffSourceCodeType::destinationCommit))
            .setter(setter(Builder::destinationCommit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCommit").build()).build();

    private static final SdkField<String> MERGE_BASE_COMMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeBaseCommit").getter(getter(CommitDiffSourceCodeType::mergeBaseCommit))
            .setter(setter(Builder::mergeBaseCommit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeBaseCommit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COMMIT_FIELD,
            DESTINATION_COMMIT_FIELD, MERGE_BASE_COMMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceCommit;

    private final String destinationCommit;

    private final String mergeBaseCommit;

    private CommitDiffSourceCodeType(BuilderImpl builder) {
        this.sourceCommit = builder.sourceCommit;
        this.destinationCommit = builder.destinationCommit;
        this.mergeBaseCommit = builder.mergeBaseCommit;
    }

    /**
     * <p>
     * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code
     * review.
     * </p>
     * 
     * @return The SHA of the source commit used to generate a commit diff. This field is required for a pull request
     *         code review.
     */
    public final String sourceCommit() {
        return sourceCommit;
    }

    /**
     * <p>
     * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code
     * review.
     * </p>
     * 
     * @return The SHA of the destination commit used to generate a commit diff. This field is required for a pull
     *         request code review.
     */
    public final String destinationCommit() {
        return destinationCommit;
    }

    /**
     * <p>
     * The SHA of the merge base of a commit.
     * </p>
     * 
     * @return The SHA of the merge base of a commit.
     */
    public final String mergeBaseCommit() {
        return mergeBaseCommit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommit());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommit());
        hashCode = 31 * hashCode + Objects.hashCode(mergeBaseCommit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitDiffSourceCodeType)) {
            return false;
        }
        CommitDiffSourceCodeType other = (CommitDiffSourceCodeType) obj;
        return Objects.equals(sourceCommit(), other.sourceCommit())
                && Objects.equals(destinationCommit(), other.destinationCommit())
                && Objects.equals(mergeBaseCommit(), other.mergeBaseCommit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommitDiffSourceCodeType").add("SourceCommit", sourceCommit())
                .add("DestinationCommit", destinationCommit()).add("MergeBaseCommit", mergeBaseCommit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceCommit":
            return Optional.ofNullable(clazz.cast(sourceCommit()));
        case "DestinationCommit":
            return Optional.ofNullable(clazz.cast(destinationCommit()));
        case "MergeBaseCommit":
            return Optional.ofNullable(clazz.cast(mergeBaseCommit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitDiffSourceCodeType, T> g) {
        return obj -> g.apply((CommitDiffSourceCodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommitDiffSourceCodeType> {
        /**
         * <p>
         * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code
         * review.
         * </p>
         * 
         * @param sourceCommit
         *        The SHA of the source commit used to generate a commit diff. This field is required for a pull request
         *        code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommit(String sourceCommit);

        /**
         * <p>
         * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request
         * code review.
         * </p>
         * 
         * @param destinationCommit
         *        The SHA of the destination commit used to generate a commit diff. This field is required for a pull
         *        request code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommit(String destinationCommit);

        /**
         * <p>
         * The SHA of the merge base of a commit.
         * </p>
         * 
         * @param mergeBaseCommit
         *        The SHA of the merge base of a commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeBaseCommit(String mergeBaseCommit);
    }

    static final class BuilderImpl implements Builder {
        private String sourceCommit;

        private String destinationCommit;

        private String mergeBaseCommit;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitDiffSourceCodeType model) {
            sourceCommit(model.sourceCommit);
            destinationCommit(model.destinationCommit);
            mergeBaseCommit(model.mergeBaseCommit);
        }

        public final String getSourceCommit() {
            return sourceCommit;
        }

        @Override
        public final Builder sourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
            return this;
        }

        public final void setSourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
        }

        public final String getDestinationCommit() {
            return destinationCommit;
        }

        @Override
        public final Builder destinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
            return this;
        }

        public final void setDestinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
        }

        public final String getMergeBaseCommit() {
            return mergeBaseCommit;
        }

        @Override
        public final Builder mergeBaseCommit(String mergeBaseCommit) {
            this.mergeBaseCommit = mergeBaseCommit;
            return this;
        }

        public final void setMergeBaseCommit(String mergeBaseCommit) {
            this.mergeBaseCommit = mergeBaseCommit;
        }

        @Override
        public CommitDiffSourceCodeType build() {
            return new CommitDiffSourceCodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
