/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the name of an S3 bucket and a <code>CodeArtifacts</code> object that contains the S3 object keys for a
 * source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3RepositoryDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<S3RepositoryDetails.Builder, S3RepositoryDetails> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3RepositoryDetails::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<CodeArtifacts> CODE_ARTIFACTS_FIELD = SdkField
            .<CodeArtifacts> builder(MarshallingType.SDK_POJO).memberName("CodeArtifacts")
            .getter(getter(S3RepositoryDetails::codeArtifacts)).setter(setter(Builder::codeArtifacts))
            .constructor(CodeArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeArtifacts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            CODE_ARTIFACTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final CodeArtifacts codeArtifacts;

    private S3RepositoryDetails(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.codeArtifacts = builder.codeArtifacts;
    }

    /**
     * <p>
     * The name of the S3 bucket used for associating a new S3 repository. It must begin with
     * <code>codeguru-reviewer-</code>.
     * </p>
     * 
     * @return The name of the S3 bucket used for associating a new S3 repository. It must begin with
     *         <code>codeguru-reviewer-</code>.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object key for a
     * source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
     * </p>
     * 
     * @return A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object key for
     *         a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
     */
    public final CodeArtifacts codeArtifacts() {
        return codeArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(codeArtifacts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3RepositoryDetails)) {
            return false;
        }
        S3RepositoryDetails other = (S3RepositoryDetails) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(codeArtifacts(), other.codeArtifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3RepositoryDetails").add("BucketName", bucketName()).add("CodeArtifacts", codeArtifacts())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "CodeArtifacts":
            return Optional.ofNullable(clazz.cast(codeArtifacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3RepositoryDetails, T> g) {
        return obj -> g.apply((S3RepositoryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3RepositoryDetails> {
        /**
         * <p>
         * The name of the S3 bucket used for associating a new S3 repository. It must begin with
         * <code>codeguru-reviewer-</code>.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket used for associating a new S3 repository. It must begin with
         *        <code>codeguru-reviewer-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object key for a
         * source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         * </p>
         * 
         * @param codeArtifacts
         *        A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object key
         *        for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeArtifacts(CodeArtifacts codeArtifacts);

        /**
         * <p>
         * A <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object key for a
         * source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeArtifacts.Builder} avoiding the need to
         * create one manually via {@link CodeArtifacts#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #codeArtifacts(CodeArtifacts)}.
         * 
         * @param codeArtifacts
         *        a consumer that will call methods on {@link CodeArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeArtifacts(CodeArtifacts)
         */
        default Builder codeArtifacts(Consumer<CodeArtifacts.Builder> codeArtifacts) {
            return codeArtifacts(CodeArtifacts.builder().applyMutation(codeArtifacts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private CodeArtifacts codeArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(S3RepositoryDetails model) {
            bucketName(model.bucketName);
            codeArtifacts(model.codeArtifacts);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final CodeArtifacts.Builder getCodeArtifacts() {
            return codeArtifacts != null ? codeArtifacts.toBuilder() : null;
        }

        @Override
        public final Builder codeArtifacts(CodeArtifacts codeArtifacts) {
            this.codeArtifacts = codeArtifacts;
            return this;
        }

        public final void setCodeArtifacts(CodeArtifacts.BuilderImpl codeArtifacts) {
            this.codeArtifacts = codeArtifacts != null ? codeArtifacts.build() : null;
        }

        @Override
        public S3RepositoryDetails build() {
            return new S3RepositoryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
