/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSummary.Builder, RecommendationSummary> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilePath").getter(getter(RecommendationSummary::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(RecommendationSummary::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<Integer> START_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartLine").getter(getter(RecommendationSummary::startLine)).setter(setter(Builder::startLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartLine").build()).build();

    private static final SdkField<Integer> END_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndLine").getter(getter(RecommendationSummary::endLine)).setter(setter(Builder::endLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndLine").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RecommendationSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RECOMMENDATION_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationCategory").getter(getter(RecommendationSummary::recommendationCategoryAsString))
            .setter(setter(Builder::recommendationCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationCategory").build())
            .build();

    private static final SdkField<RuleMetadata> RULE_METADATA_FIELD = SdkField.<RuleMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("RuleMetadata").getter(getter(RecommendationSummary::ruleMetadata)).setter(setter(Builder::ruleMetadata))
            .constructor(RuleMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleMetadata").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(RecommendationSummary::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            RECOMMENDATION_ID_FIELD, START_LINE_FIELD, END_LINE_FIELD, DESCRIPTION_FIELD, RECOMMENDATION_CATEGORY_FIELD,
            RULE_METADATA_FIELD, SEVERITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final String recommendationId;

    private final Integer startLine;

    private final Integer endLine;

    private final String description;

    private final String recommendationCategory;

    private final RuleMetadata ruleMetadata;

    private final String severity;

    private RecommendationSummary(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.recommendationId = builder.recommendationId;
        this.startLine = builder.startLine;
        this.endLine = builder.endLine;
        this.description = builder.description;
        this.recommendationCategory = builder.recommendationCategory;
        this.ruleMetadata = builder.ruleMetadata;
        this.severity = builder.severity;
    }

    /**
     * <p>
     * Name of the file on which a recommendation is provided.
     * </p>
     * 
     * @return Name of the file on which a recommendation is provided.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect
     * the feedback.
     * </p>
     * 
     * @return The recommendation ID that can be used to track the provided recommendations. Later on it can be used to
     *         collect the feedback.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * Start line from where the recommendation is applicable in the source commit or source branch.
     * </p>
     * 
     * @return Start line from where the recommendation is applicable in the source commit or source branch.
     */
    public final Integer startLine() {
        return startLine;
    }

    /**
     * <p>
     * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment
     * the start line and end line values are the same.
     * </p>
     * 
     * @return Last line where the recommendation is applicable in the source commit or source branch. For a single line
     *         comment the start line and end line values are the same.
     */
    public final Integer endLine() {
        return endLine;
    }

    /**
     * <p>
     * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line
     * and the end line.
     * </p>
     * 
     * @return A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the
     *         start line and the end line.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of a recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationCategory} will return {@link RecommendationCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recommendationCategoryAsString}.
     * </p>
     * 
     * @return The type of a recommendation.
     * @see RecommendationCategory
     */
    public final RecommendationCategory recommendationCategory() {
        return RecommendationCategory.fromValue(recommendationCategory);
    }

    /**
     * <p>
     * The type of a recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationCategory} will return {@link RecommendationCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recommendationCategoryAsString}.
     * </p>
     * 
     * @return The type of a recommendation.
     * @see RecommendationCategory
     */
    public final String recommendationCategoryAsString() {
        return recommendationCategory;
    }

    /**
     * <p>
     * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description.
     * CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is
     * detected that violates the rule.
     * </p>
     * 
     * @return Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long
     *         description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in
     *         analysis results if code is detected that violates the rule.
     */
    public final RuleMetadata ruleMetadata() {
        return ruleMetadata;
    }

    /**
     * <p>
     * The severity of the issue in the code that generated this recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the issue in the code that generated this recommendation.
     * @see Severity
     */
    public final Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the issue in the code that generated this recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the issue in the code that generated this recommendation.
     * @see Severity
     */
    public final String severityAsString() {
        return severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(startLine());
        hashCode = 31 * hashCode + Objects.hashCode(endLine());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(startLine(), other.startLine()) && Objects.equals(endLine(), other.endLine())
                && Objects.equals(description(), other.description())
                && Objects.equals(recommendationCategoryAsString(), other.recommendationCategoryAsString())
                && Objects.equals(ruleMetadata(), other.ruleMetadata())
                && Objects.equals(severityAsString(), other.severityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationSummary").add("FilePath", filePath()).add("RecommendationId", recommendationId())
                .add("StartLine", startLine()).add("EndLine", endLine()).add("Description", description())
                .add("RecommendationCategory", recommendationCategoryAsString()).add("RuleMetadata", ruleMetadata())
                .add("Severity", severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "StartLine":
            return Optional.ofNullable(clazz.cast(startLine()));
        case "EndLine":
            return Optional.ofNullable(clazz.cast(endLine()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RecommendationCategory":
            return Optional.ofNullable(clazz.cast(recommendationCategoryAsString()));
        case "RuleMetadata":
            return Optional.ofNullable(clazz.cast(ruleMetadata()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSummary> {
        /**
         * <p>
         * Name of the file on which a recommendation is provided.
         * </p>
         * 
         * @param filePath
         *        Name of the file on which a recommendation is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to
         * collect the feedback.
         * </p>
         * 
         * @param recommendationId
         *        The recommendation ID that can be used to track the provided recommendations. Later on it can be used
         *        to collect the feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * Start line from where the recommendation is applicable in the source commit or source branch.
         * </p>
         * 
         * @param startLine
         *        Start line from where the recommendation is applicable in the source commit or source branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startLine(Integer startLine);

        /**
         * <p>
         * Last line where the recommendation is applicable in the source commit or source branch. For a single line
         * comment the start line and end line values are the same.
         * </p>
         * 
         * @param endLine
         *        Last line where the recommendation is applicable in the source commit or source branch. For a single
         *        line comment the start line and end line values are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endLine(Integer endLine);

        /**
         * <p>
         * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start
         * line and the end line.
         * </p>
         * 
         * @param description
         *        A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the
         *        start line and the end line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of a recommendation.
         * </p>
         * 
         * @param recommendationCategory
         *        The type of a recommendation.
         * @see RecommendationCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationCategory
         */
        Builder recommendationCategory(String recommendationCategory);

        /**
         * <p>
         * The type of a recommendation.
         * </p>
         * 
         * @param recommendationCategory
         *        The type of a recommendation.
         * @see RecommendationCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationCategory
         */
        Builder recommendationCategory(RecommendationCategory recommendationCategory);

        /**
         * <p>
         * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long
         * description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis
         * results if code is detected that violates the rule.
         * </p>
         * 
         * @param ruleMetadata
         *        Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long
         *        description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in
         *        analysis results if code is detected that violates the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleMetadata(RuleMetadata ruleMetadata);

        /**
         * <p>
         * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long
         * description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis
         * results if code is detected that violates the rule.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleMetadata.Builder} avoiding the need to
         * create one manually via {@link RuleMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleMetadata(RuleMetadata)}.
         * 
         * @param ruleMetadata
         *        a consumer that will call methods on {@link RuleMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleMetadata(RuleMetadata)
         */
        default Builder ruleMetadata(Consumer<RuleMetadata.Builder> ruleMetadata) {
            return ruleMetadata(RuleMetadata.builder().applyMutation(ruleMetadata).build());
        }

        /**
         * <p>
         * The severity of the issue in the code that generated this recommendation.
         * </p>
         * 
         * @param severity
         *        The severity of the issue in the code that generated this recommendation.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the issue in the code that generated this recommendation.
         * </p>
         * 
         * @param severity
         *        The severity of the issue in the code that generated this recommendation.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private String recommendationId;

        private Integer startLine;

        private Integer endLine;

        private String description;

        private String recommendationCategory;

        private RuleMetadata ruleMetadata;

        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            filePath(model.filePath);
            recommendationId(model.recommendationId);
            startLine(model.startLine);
            endLine(model.endLine);
            description(model.description);
            recommendationCategory(model.recommendationCategory);
            ruleMetadata(model.ruleMetadata);
            severity(model.severity);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        @Transient
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        @Transient
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Integer getStartLine() {
            return startLine;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        @Override
        @Transient
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public final Integer getEndLine() {
            return endLine;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        @Override
        @Transient
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRecommendationCategory() {
            return recommendationCategory;
        }

        public final void setRecommendationCategory(String recommendationCategory) {
            this.recommendationCategory = recommendationCategory;
        }

        @Override
        @Transient
        public final Builder recommendationCategory(String recommendationCategory) {
            this.recommendationCategory = recommendationCategory;
            return this;
        }

        @Override
        @Transient
        public final Builder recommendationCategory(RecommendationCategory recommendationCategory) {
            this.recommendationCategory(recommendationCategory == null ? null : recommendationCategory.toString());
            return this;
        }

        public final RuleMetadata.Builder getRuleMetadata() {
            return ruleMetadata != null ? ruleMetadata.toBuilder() : null;
        }

        public final void setRuleMetadata(RuleMetadata.BuilderImpl ruleMetadata) {
            this.ruleMetadata = ruleMetadata != null ? ruleMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleMetadata(RuleMetadata ruleMetadata) {
            this.ruleMetadata = ruleMetadata;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        @Transient
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        @Override
        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
