/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecommendationFeedbackRequest extends CodeGuruReviewerRequest implements
        ToCopyableBuilder<DescribeRecommendationFeedbackRequest.Builder, DescribeRecommendationFeedbackRequest> {
    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeReviewArn").getter(getter(DescribeRecommendationFeedbackRequest::codeReviewArn))
            .setter(setter(Builder::codeReviewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CodeReviewArn").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(DescribeRecommendationFeedbackRequest::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RecommendationId").build())
            .build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DescribeRecommendationFeedbackRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_ARN_FIELD,
            RECOMMENDATION_ID_FIELD, USER_ID_FIELD));

    private final String codeReviewArn;

    private final String recommendationId;

    private final String userId;

    private DescribeRecommendationFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.codeReviewArn = builder.codeReviewArn;
        this.recommendationId = builder.recommendationId;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a>
     * object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     *         <code>CodeReview</code> </a> object.
     */
    public final String codeReviewArn() {
        return codeReviewArn;
    }

    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations and then to collect the feedback.
     * </p>
     * 
     * @return The recommendation ID that can be used to track the provided recommendations and then to collect the
     *         feedback.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user
     * making the request.
     * </p>
     * <p>
     * The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an
     * Amazon Resource Name (ARN). For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"
     * > Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
     * </p>
     * 
     * @return Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the
     *         user making the request. </p>
     *         <p>
     *         The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or
     *         an Amazon Resource Name (ARN). For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"
     *         > Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationFeedbackRequest)) {
            return false;
        }
        DescribeRecommendationFeedbackRequest other = (DescribeRecommendationFeedbackRequest) obj;
        return Objects.equals(codeReviewArn(), other.codeReviewArn())
                && Objects.equals(recommendationId(), other.recommendationId()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecommendationFeedbackRequest").add("CodeReviewArn", codeReviewArn())
                .add("RecommendationId", recommendationId()).add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeReviewArn":
            return Optional.ofNullable(clazz.cast(codeReviewArn()));
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommendationFeedbackRequest, T> g) {
        return obj -> g.apply((DescribeRecommendationFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRecommendationFeedbackRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code>
         * </a> object.
         * </p>
         * 
         * @param codeReviewArn
         *        The Amazon Resource Name (ARN) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         *        <code>CodeReview</code> </a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewArn(String codeReviewArn);

        /**
         * <p>
         * The recommendation ID that can be used to track the provided recommendations and then to collect the
         * feedback.
         * </p>
         * 
         * @param recommendationId
         *        The recommendation ID that can be used to track the provided recommendations and then to collect the
         *        feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the
         * user making the request.
         * </p>
         * <p>
         * The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID or an
         * Amazon Resource Name (ARN). For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"
         * > Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
         * </p>
         * 
         * @param userId
         *        Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to
         *        the user making the request. </p>
         *        <p>
         *        The <code>UserId</code> is an IAM principal that can be specified as an Amazon Web Services account ID
         *        or an Amazon Resource Name (ARN). For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"
         *        > Specifying a Principal</a> in the <i>Amazon Web Services Identity and Access Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruReviewerRequest.BuilderImpl implements Builder {
        private String codeReviewArn;

        private String recommendationId;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommendationFeedbackRequest model) {
            super(model);
            codeReviewArn(model.codeReviewArn);
            recommendationId(model.recommendationId);
            userId(model.userId);
        }

        public final String getCodeReviewArn() {
            return codeReviewArn;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        @Override
        @Transient
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        @Transient
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRecommendationFeedbackRequest build() {
            return new DescribeRecommendationFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
