/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The encryption option for a repository association. It is either owned by Amazon Web Services Key Management Service
 * (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).
 * </p>
 * </li>
 * <li>
 * <p>
 * The ID of the Amazon Web Services KMS key that is associated with a respository association.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KMSKeyDetails implements SdkPojo, Serializable, ToCopyableBuilder<KMSKeyDetails.Builder, KMSKeyDetails> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(KMSKeyDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final SdkField<String> ENCRYPTION_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionOption").getter(getter(KMSKeyDetails::encryptionOptionAsString))
            .setter(setter(Builder::encryptionOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            ENCRYPTION_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String encryptionOption;

    private KMSKeyDetails(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.encryptionOption = builder.encryptionOption;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services KMS key that is associated with a respository association.
     * </p>
     * 
     * @return The ID of the Amazon Web Services KMS key that is associated with a respository association.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The encryption option for a repository association. It is either owned by Amazon Web Services Key Management
     * Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionOption}
     * will return {@link EncryptionOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionOptionAsString}.
     * </p>
     * 
     * @return The encryption option for a repository association. It is either owned by Amazon Web Services Key
     *         Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (
     *         <code>CUSTOMER_MANAGED_CMK</code>).
     * @see EncryptionOption
     */
    public final EncryptionOption encryptionOption() {
        return EncryptionOption.fromValue(encryptionOption);
    }

    /**
     * <p>
     * The encryption option for a repository association. It is either owned by Amazon Web Services Key Management
     * Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionOption}
     * will return {@link EncryptionOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionOptionAsString}.
     * </p>
     * 
     * @return The encryption option for a repository association. It is either owned by Amazon Web Services Key
     *         Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (
     *         <code>CUSTOMER_MANAGED_CMK</code>).
     * @see EncryptionOption
     */
    public final String encryptionOptionAsString() {
        return encryptionOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSKeyDetails)) {
            return false;
        }
        KMSKeyDetails other = (KMSKeyDetails) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(encryptionOptionAsString(), other.encryptionOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KMSKeyDetails").add("KMSKeyId", kmsKeyId()).add("EncryptionOption", encryptionOptionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EncryptionOption":
            return Optional.ofNullable(clazz.cast(encryptionOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KMSKeyDetails, T> g) {
        return obj -> g.apply((KMSKeyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KMSKeyDetails> {
        /**
         * <p>
         * The ID of the Amazon Web Services KMS key that is associated with a respository association.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the Amazon Web Services KMS key that is associated with a respository association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The encryption option for a repository association. It is either owned by Amazon Web Services Key Management
         * Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).
         * </p>
         * 
         * @param encryptionOption
         *        The encryption option for a repository association. It is either owned by Amazon Web Services Key
         *        Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (
         *        <code>CUSTOMER_MANAGED_CMK</code>).
         * @see EncryptionOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionOption
         */
        Builder encryptionOption(String encryptionOption);

        /**
         * <p>
         * The encryption option for a repository association. It is either owned by Amazon Web Services Key Management
         * Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (<code>CUSTOMER_MANAGED_CMK</code>).
         * </p>
         * 
         * @param encryptionOption
         *        The encryption option for a repository association. It is either owned by Amazon Web Services Key
         *        Management Service (KMS) (<code>AWS_OWNED_CMK</code>) or customer managed (
         *        <code>CUSTOMER_MANAGED_CMK</code>).
         * @see EncryptionOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionOption
         */
        Builder encryptionOption(EncryptionOption encryptionOption);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String encryptionOption;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSKeyDetails model) {
            kmsKeyId(model.kmsKeyId);
            encryptionOption(model.encryptionOption);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getEncryptionOption() {
            return encryptionOption;
        }

        public final void setEncryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
        }

        @Override
        @Transient
        public final Builder encryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionOption(EncryptionOption encryptionOption) {
            this.encryptionOption(encryptionOption == null ? null : encryptionOption.toString());
            return this;
        }

        @Override
        public KMSKeyDetails build() {
            return new KMSKeyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
