/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the statistics from the code review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metrics implements SdkPojo, Serializable, ToCopyableBuilder<Metrics.Builder, Metrics> {
    private static final SdkField<Long> METERED_LINES_OF_CODE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MeteredLinesOfCodeCount").getter(getter(Metrics::meteredLinesOfCodeCount))
            .setter(setter(Builder::meteredLinesOfCodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredLinesOfCodeCount").build())
            .build();

    private static final SdkField<Long> FINDINGS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FindingsCount").getter(getter(Metrics::findingsCount)).setter(setter(Builder::findingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METERED_LINES_OF_CODE_COUNT_FIELD, FINDINGS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long meteredLinesOfCodeCount;

    private final Long findingsCount;

    private Metrics(BuilderImpl builder) {
        this.meteredLinesOfCodeCount = builder.meteredLinesOfCodeCount;
        this.findingsCount = builder.findingsCount;
    }

    /**
     * <p>
     * Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions,
     * this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that
     * already existed in the pull request, this includes only the changed lines of code. In both cases, this does not
     * include non-code lines such as comments and import statements. For example, if you submit a pull request
     * containing 5 files, each with 500 lines of code, and in a subsequent revision you added a new file with 200 lines
     * of code, and also modified a total of 25 lines across the initial 5 files, <code>MeteredLinesOfCodeCount</code>
     * includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of code for
     * a total of 2,725 lines of code.
     * </p>
     * 
     * @return Lines of code metered in the code review. For the initial code review pull request and all subsequent
     *         revisions, this includes all lines of code in the files added to the pull request. In subsequent
     *         revisions, for files that already existed in the pull request, this includes only the changed lines of
     *         code. In both cases, this does not include non-code lines such as comments and import statements. For
     *         example, if you submit a pull request containing 5 files, each with 500 lines of code, and in a
     *         subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines
     *         across the initial 5 files, <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 =
     *         2,500 lines), the new file (200 lines) and the 25 changed lines of code for a total of 2,725 lines of
     *         code.
     */
    public final Long meteredLinesOfCodeCount() {
        return meteredLinesOfCodeCount;
    }

    /**
     * <p>
     * Total number of recommendations found in the code review.
     * </p>
     * 
     * @return Total number of recommendations found in the code review.
     */
    public final Long findingsCount() {
        return findingsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meteredLinesOfCodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(findingsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics) obj;
        return Objects.equals(meteredLinesOfCodeCount(), other.meteredLinesOfCodeCount())
                && Objects.equals(findingsCount(), other.findingsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metrics").add("MeteredLinesOfCodeCount", meteredLinesOfCodeCount())
                .add("FindingsCount", findingsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeteredLinesOfCodeCount":
            return Optional.ofNullable(clazz.cast(meteredLinesOfCodeCount()));
        case "FindingsCount":
            return Optional.ofNullable(clazz.cast(findingsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Metrics, T> g) {
        return obj -> g.apply((Metrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metrics> {
        /**
         * <p>
         * Lines of code metered in the code review. For the initial code review pull request and all subsequent
         * revisions, this includes all lines of code in the files added to the pull request. In subsequent revisions,
         * for files that already existed in the pull request, this includes only the changed lines of code. In both
         * cases, this does not include non-code lines such as comments and import statements. For example, if you
         * submit a pull request containing 5 files, each with 500 lines of code, and in a subsequent revision you added
         * a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files,
         * <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 = 2,500 lines), the new file (200
         * lines) and the 25 changed lines of code for a total of 2,725 lines of code.
         * </p>
         * 
         * @param meteredLinesOfCodeCount
         *        Lines of code metered in the code review. For the initial code review pull request and all subsequent
         *        revisions, this includes all lines of code in the files added to the pull request. In subsequent
         *        revisions, for files that already existed in the pull request, this includes only the changed lines of
         *        code. In both cases, this does not include non-code lines such as comments and import statements. For
         *        example, if you submit a pull request containing 5 files, each with 500 lines of code, and in a
         *        subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines
         *        across the initial 5 files, <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 =
         *        2,500 lines), the new file (200 lines) and the 25 changed lines of code for a total of 2,725 lines of
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meteredLinesOfCodeCount(Long meteredLinesOfCodeCount);

        /**
         * <p>
         * Total number of recommendations found in the code review.
         * </p>
         * 
         * @param findingsCount
         *        Total number of recommendations found in the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsCount(Long findingsCount);
    }

    static final class BuilderImpl implements Builder {
        private Long meteredLinesOfCodeCount;

        private Long findingsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Metrics model) {
            meteredLinesOfCodeCount(model.meteredLinesOfCodeCount);
            findingsCount(model.findingsCount);
        }

        public final Long getMeteredLinesOfCodeCount() {
            return meteredLinesOfCodeCount;
        }

        public final void setMeteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
        }

        @Override
        @Transient
        public final Builder meteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
            return this;
        }

        public final Long getFindingsCount() {
            return findingsCount;
        }

        public final void setFindingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
        }

        @Override
        @Transient
        public final Builder findingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
            return this;
        }

        @Override
        public Metrics build() {
            return new Metrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
