/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the summary of the code review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeReviewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeReviewSummary.Builder, CodeReviewSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CodeReviewSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeReviewArn").getter(getter(CodeReviewSummary::codeReviewArn)).setter(setter(Builder::codeReviewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewArn").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(CodeReviewSummary::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(CodeReviewSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(CodeReviewSummary::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CodeReviewSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATED_TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimeStamp").getter(getter(CodeReviewSummary::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimeStamp").getter(getter(CodeReviewSummary::lastUpdatedTimeStamp))
            .setter(setter(Builder::lastUpdatedTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimeStamp").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CodeReviewSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PullRequestId").getter(getter(CodeReviewSummary::pullRequestId)).setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PullRequestId").build()).build();

    private static final SdkField<MetricsSummary> METRICS_SUMMARY_FIELD = SdkField
            .<MetricsSummary> builder(MarshallingType.SDK_POJO).memberName("MetricsSummary")
            .getter(getter(CodeReviewSummary::metricsSummary)).setter(setter(Builder::metricsSummary))
            .constructor(MetricsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsSummary").build()).build();

    private static final SdkField<SourceCodeType> SOURCE_CODE_TYPE_FIELD = SdkField
            .<SourceCodeType> builder(MarshallingType.SDK_POJO).memberName("SourceCodeType")
            .getter(getter(CodeReviewSummary::sourceCodeType)).setter(setter(Builder::sourceCodeType))
            .constructor(SourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCodeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CODE_REVIEW_ARN_FIELD, REPOSITORY_NAME_FIELD, OWNER_FIELD, PROVIDER_TYPE_FIELD, STATE_FIELD,
            CREATED_TIME_STAMP_FIELD, LAST_UPDATED_TIME_STAMP_FIELD, TYPE_FIELD, PULL_REQUEST_ID_FIELD, METRICS_SUMMARY_FIELD,
            SOURCE_CODE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String codeReviewArn;

    private final String repositoryName;

    private final String owner;

    private final String providerType;

    private final String state;

    private final Instant createdTimeStamp;

    private final Instant lastUpdatedTimeStamp;

    private final String type;

    private final String pullRequestId;

    private final MetricsSummary metricsSummary;

    private final SourceCodeType sourceCodeType;

    private CodeReviewSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.codeReviewArn = builder.codeReviewArn;
        this.repositoryName = builder.repositoryName;
        this.owner = builder.owner;
        this.providerType = builder.providerType;
        this.state = builder.state;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
        this.type = builder.type;
        this.pullRequestId = builder.pullRequestId;
        this.metricsSummary = builder.metricsSummary;
        this.sourceCodeType = builder.sourceCodeType;
    }

    /**
     * <p>
     * The name of the code review.
     * </p>
     * 
     * @return The name of the code review.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a>
     * object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     *         <code>CodeReview</code> </a> object.
     */
    public final String codeReviewArn() {
        return codeReviewArn;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services
     * account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket
     * repository, this is the username for the account that owns the repository. For an S3 repository, it can be the
     * username or Amazon Web Services account ID.
     * </p>
     * 
     * @return The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web
     *         Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or
     *         Bitbucket repository, this is the username for the account that owns the repository. For an S3
     *         repository, it can be the username or Amazon Web Services account ID.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The provider type of the repository association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type of the repository association.
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The provider type of the repository association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The provider type of the repository association.
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The state of the code review.
     * </p>
     * <p>
     * The valid code review states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The code review is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code>: The code review started and has not completed or failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The code review failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: The code review is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the code review. </p>
     *         <p>
     *         The valid code review states are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The code review is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code>: The code review started and has not completed or failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The code review failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: The code review is being deleted.
     *         </p>
     *         </li>
     * @see JobState
     */
    public final JobState state() {
        return JobState.fromValue(state);
    }

    /**
     * <p>
     * The state of the code review.
     * </p>
     * <p>
     * The valid code review states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The code review is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code>: The code review started and has not completed or failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The code review failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: The code review is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the code review. </p>
     *         <p>
     *         The valid code review states are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The code review is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code>: The code review started and has not completed or failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The code review failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: The code review is being deleted.
     *         </p>
     *         </li>
     * @see JobState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the code review was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the code review was created.
     */
    public final Instant createdTimeStamp() {
        return createdTimeStamp;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the code review was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the code review was last updated.
     */
    public final Instant lastUpdatedTimeStamp() {
        return lastUpdatedTimeStamp;
    }

    /**
     * <p>
     * The type of the code review.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the code review.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of the code review.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the code review.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The pull request ID for the code review.
     * </p>
     * 
     * @return The pull request ID for the code review.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The statistics from the code review.
     * </p>
     * 
     * @return The statistics from the code review.
     */
    public final MetricsSummary metricsSummary() {
        return metricsSummary;
    }

    /**
     * Returns the value of the SourceCodeType property for this object.
     * 
     * @return The value of the SourceCodeType property for this object.
     */
    public final SourceCodeType sourceCodeType() {
        return sourceCodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(metricsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeReviewSummary)) {
            return false;
        }
        CodeReviewSummary other = (CodeReviewSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(codeReviewArn(), other.codeReviewArn())
                && Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(owner(), other.owner())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(createdTimeStamp(), other.createdTimeStamp())
                && Objects.equals(lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(metricsSummary(), other.metricsSummary())
                && Objects.equals(sourceCodeType(), other.sourceCodeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeReviewSummary").add("Name", name()).add("CodeReviewArn", codeReviewArn())
                .add("RepositoryName", repositoryName()).add("Owner", owner()).add("ProviderType", providerTypeAsString())
                .add("State", stateAsString()).add("CreatedTimeStamp", createdTimeStamp())
                .add("LastUpdatedTimeStamp", lastUpdatedTimeStamp()).add("Type", typeAsString())
                .add("PullRequestId", pullRequestId()).add("MetricsSummary", metricsSummary())
                .add("SourceCodeType", sourceCodeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CodeReviewArn":
            return Optional.ofNullable(clazz.cast(codeReviewArn()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreatedTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        case "LastUpdatedTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimeStamp()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "PullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "MetricsSummary":
            return Optional.ofNullable(clazz.cast(metricsSummary()));
        case "SourceCodeType":
            return Optional.ofNullable(clazz.cast(sourceCodeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeReviewSummary, T> g) {
        return obj -> g.apply((CodeReviewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeReviewSummary> {
        /**
         * <p>
         * The name of the code review.
         * </p>
         * 
         * @param name
         *        The name of the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code>
         * </a> object.
         * </p>
         * 
         * @param codeReviewArn
         *        The Amazon Resource Name (ARN) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         *        <code>CodeReview</code> </a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewArn(String codeReviewArn);

        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web
         * Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or
         * Bitbucket repository, this is the username for the account that owns the repository. For an S3 repository, it
         * can be the username or Amazon Web Services account ID.
         * </p>
         * 
         * @param owner
         *        The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web
         *        Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server,
         *        or Bitbucket repository, this is the username for the account that owns the repository. For an S3
         *        repository, it can be the username or Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The provider type of the repository association.
         * </p>
         * 
         * @param providerType
         *        The provider type of the repository association.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The provider type of the repository association.
         * </p>
         * 
         * @param providerType
         *        The provider type of the repository association.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The state of the code review.
         * </p>
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the code review. </p>
         *        <p>
         *        The valid code review states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the code review.
         * </p>
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the code review. </p>
         *        <p>
         *        The valid code review states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder state(JobState state);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the code review was created.
         * </p>
         * 
         * @param createdTimeStamp
         *        The time, in milliseconds since the epoch, when the code review was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Instant createdTimeStamp);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the code review was last updated.
         * </p>
         * 
         * @param lastUpdatedTimeStamp
         *        The time, in milliseconds since the epoch, when the code review was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp);

        /**
         * <p>
         * The type of the code review.
         * </p>
         * 
         * @param type
         *        The type of the code review.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the code review.
         * </p>
         * 
         * @param type
         *        The type of the code review.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * The pull request ID for the code review.
         * </p>
         * 
         * @param pullRequestId
         *        The pull request ID for the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The statistics from the code review.
         * </p>
         * 
         * @param metricsSummary
         *        The statistics from the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsSummary(MetricsSummary metricsSummary);

        /**
         * <p>
         * The statistics from the code review.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricsSummary.Builder} avoiding the need
         * to create one manually via {@link MetricsSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #metricsSummary(MetricsSummary)}.
         * 
         * @param metricsSummary
         *        a consumer that will call methods on {@link MetricsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsSummary(MetricsSummary)
         */
        default Builder metricsSummary(Consumer<MetricsSummary.Builder> metricsSummary) {
            return metricsSummary(MetricsSummary.builder().applyMutation(metricsSummary).build());
        }

        /**
         * Sets the value of the SourceCodeType property for this object.
         *
         * @param sourceCodeType
         *        The new value for the SourceCodeType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeType(SourceCodeType sourceCodeType);

        /**
         * Sets the value of the SourceCodeType property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SourceCodeType.Builder} avoiding the need
         * to create one manually via {@link SourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceCodeType.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceCodeType(SourceCodeType)}.
         * 
         * @param sourceCodeType
         *        a consumer that will call methods on {@link SourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCodeType(SourceCodeType)
         */
        default Builder sourceCodeType(Consumer<SourceCodeType.Builder> sourceCodeType) {
            return sourceCodeType(SourceCodeType.builder().applyMutation(sourceCodeType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String codeReviewArn;

        private String repositoryName;

        private String owner;

        private String providerType;

        private String state;

        private Instant createdTimeStamp;

        private Instant lastUpdatedTimeStamp;

        private String type;

        private String pullRequestId;

        private MetricsSummary metricsSummary;

        private SourceCodeType sourceCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeReviewSummary model) {
            name(model.name);
            codeReviewArn(model.codeReviewArn);
            repositoryName(model.repositoryName);
            owner(model.owner);
            providerType(model.providerType);
            state(model.state);
            createdTimeStamp(model.createdTimeStamp);
            lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
            type(model.type);
            pullRequestId(model.pullRequestId);
            metricsSummary(model.metricsSummary);
            sourceCodeType(model.sourceCodeType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCodeReviewArn() {
            return codeReviewArn;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        @Override
        @Transient
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        @Transient
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        @Transient
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(JobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        @Transient
        public final Builder createdTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Instant getLastUpdatedTimeStamp() {
            return lastUpdatedTimeStamp;
        }

        public final void setLastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        @Transient
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final MetricsSummary.Builder getMetricsSummary() {
            return metricsSummary != null ? metricsSummary.toBuilder() : null;
        }

        public final void setMetricsSummary(MetricsSummary.BuilderImpl metricsSummary) {
            this.metricsSummary = metricsSummary != null ? metricsSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder metricsSummary(MetricsSummary metricsSummary) {
            this.metricsSummary = metricsSummary;
            return this;
        }

        public final SourceCodeType.Builder getSourceCodeType() {
            return sourceCodeType != null ? sourceCodeType.toBuilder() : null;
        }

        public final void setSourceCodeType(SourceCodeType.BuilderImpl sourceCodeType) {
            this.sourceCodeType = sourceCodeType != null ? sourceCodeType.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceCodeType(SourceCodeType sourceCodeType) {
            this.sourceCodeType = sourceCodeType;
            return this;
        }

        @Override
        public CodeReviewSummary build() {
            return new CodeReviewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
