/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the source code that is analyzed in a code review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCodeType implements SdkPojo, Serializable, ToCopyableBuilder<SourceCodeType.Builder, SourceCodeType> {
    private static final SdkField<CommitDiffSourceCodeType> COMMIT_DIFF_FIELD = SdkField
            .<CommitDiffSourceCodeType> builder(MarshallingType.SDK_POJO).memberName("CommitDiff")
            .getter(getter(SourceCodeType::commitDiff)).setter(setter(Builder::commitDiff))
            .constructor(CommitDiffSourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitDiff").build()).build();

    private static final SdkField<RepositoryHeadSourceCodeType> REPOSITORY_HEAD_FIELD = SdkField
            .<RepositoryHeadSourceCodeType> builder(MarshallingType.SDK_POJO).memberName("RepositoryHead")
            .getter(getter(SourceCodeType::repositoryHead)).setter(setter(Builder::repositoryHead))
            .constructor(RepositoryHeadSourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryHead").build()).build();

    private static final SdkField<BranchDiffSourceCodeType> BRANCH_DIFF_FIELD = SdkField
            .<BranchDiffSourceCodeType> builder(MarshallingType.SDK_POJO).memberName("BranchDiff")
            .getter(getter(SourceCodeType::branchDiff)).setter(setter(Builder::branchDiff))
            .constructor(BranchDiffSourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchDiff").build()).build();

    private static final SdkField<S3BucketRepository> S3_BUCKET_REPOSITORY_FIELD = SdkField
            .<S3BucketRepository> builder(MarshallingType.SDK_POJO).memberName("S3BucketRepository")
            .getter(getter(SourceCodeType::s3BucketRepository)).setter(setter(Builder::s3BucketRepository))
            .constructor(S3BucketRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketRepository").build())
            .build();

    private static final SdkField<RequestMetadata> REQUEST_METADATA_FIELD = SdkField
            .<RequestMetadata> builder(MarshallingType.SDK_POJO).memberName("RequestMetadata")
            .getter(getter(SourceCodeType::requestMetadata)).setter(setter(Builder::requestMetadata))
            .constructor(RequestMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_DIFF_FIELD,
            REPOSITORY_HEAD_FIELD, BRANCH_DIFF_FIELD, S3_BUCKET_REPOSITORY_FIELD, REQUEST_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final CommitDiffSourceCodeType commitDiff;

    private final RepositoryHeadSourceCodeType repositoryHead;

    private final BranchDiffSourceCodeType branchDiff;

    private final S3BucketRepository s3BucketRepository;

    private final RequestMetadata requestMetadata;

    private SourceCodeType(BuilderImpl builder) {
        this.commitDiff = builder.commitDiff;
        this.repositoryHead = builder.repositoryHead;
        this.branchDiff = builder.branchDiff;
        this.s3BucketRepository = builder.s3BucketRepository;
        this.requestMetadata = builder.requestMetadata;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
     * repository.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     *         <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
     *         repository.
     */
    public final CommitDiffSourceCodeType commitDiff() {
        return commitDiff;
    }

    /**
     * Returns the value of the RepositoryHead property for this object.
     * 
     * @return The value of the RepositoryHead property for this object.
     */
    public final RepositoryHeadSourceCodeType repositoryHead() {
        return repositoryHead;
    }

    /**
     * <p>
     * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * <code>SourceCodeType</code> </a> that specifies a source branch name and a destination branch name in an
     * associated repository.
     * </p>
     * 
     * @return A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     *         <code>SourceCodeType</code> </a> that specifies a source branch name and a destination branch name in an
     *         associated repository.
     */
    public final BranchDiffSourceCodeType branchDiff() {
        return branchDiff;
    }

    /**
     * <p>
     * Information about an associated repository in an S3 bucket that includes its name and an
     * <code>S3RepositoryDetails</code> object. The <code>S3RepositoryDetails</code> object includes the name of an S3
     * bucket, an S3 key for a source code .zip file, and an S3 key for a build artifacts .zip file.
     * <code>S3BucketRepository</code> is required in <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType"> <code>SourceCodeType</code>
     * </a> for <code>S3BucketRepository</code> based code reviews.
     * </p>
     * 
     * @return Information about an associated repository in an S3 bucket that includes its name and an
     *         <code>S3RepositoryDetails</code> object. The <code>S3RepositoryDetails</code> object includes the name of
     *         an S3 bucket, an S3 key for a source code .zip file, and an S3 key for a build artifacts .zip file.
     *         <code>S3BucketRepository</code> is required in <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     *         <code>SourceCodeType</code> </a> for <code>S3BucketRepository</code> based code reviews.
     */
    public final S3BucketRepository s3BucketRepository() {
        return s3BucketRepository;
    }

    /**
     * <p>
     * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru
     * Reviewer. The <code>RequestMetadaa</code> field captures any event metadata. For example, it might capture
     * metadata associated with an event trigger, such as a push or a pull request.
     * </p>
     * 
     * @return Metadata that is associated with a code review. This applies to any type of code review supported by
     *         CodeGuru Reviewer. The <code>RequestMetadaa</code> field captures any event metadata. For example, it
     *         might capture metadata associated with an event trigger, such as a push or a pull request.
     */
    public final RequestMetadata requestMetadata() {
        return requestMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitDiff());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryHead());
        hashCode = 31 * hashCode + Objects.hashCode(branchDiff());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketRepository());
        hashCode = 31 * hashCode + Objects.hashCode(requestMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCodeType)) {
            return false;
        }
        SourceCodeType other = (SourceCodeType) obj;
        return Objects.equals(commitDiff(), other.commitDiff()) && Objects.equals(repositoryHead(), other.repositoryHead())
                && Objects.equals(branchDiff(), other.branchDiff())
                && Objects.equals(s3BucketRepository(), other.s3BucketRepository())
                && Objects.equals(requestMetadata(), other.requestMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceCodeType").add("CommitDiff", commitDiff()).add("RepositoryHead", repositoryHead())
                .add("BranchDiff", branchDiff()).add("S3BucketRepository", s3BucketRepository())
                .add("RequestMetadata", requestMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommitDiff":
            return Optional.ofNullable(clazz.cast(commitDiff()));
        case "RepositoryHead":
            return Optional.ofNullable(clazz.cast(repositoryHead()));
        case "BranchDiff":
            return Optional.ofNullable(clazz.cast(branchDiff()));
        case "S3BucketRepository":
            return Optional.ofNullable(clazz.cast(s3BucketRepository()));
        case "RequestMetadata":
            return Optional.ofNullable(clazz.cast(requestMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCodeType, T> g) {
        return obj -> g.apply((SourceCodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCodeType> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
         * repository.
         * </p>
         * 
         * @param commitDiff
         *        A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         *        <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an
         *        associated repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitDiff(CommitDiffSourceCodeType commitDiff);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies a commit diff created by a pull request on an associated
         * repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommitDiffSourceCodeType.Builder}
         * avoiding the need to create one manually via {@link CommitDiffSourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CommitDiffSourceCodeType.Builder#build()} is called immediately
         * and its result is passed to {@link #commitDiff(CommitDiffSourceCodeType)}.
         * 
         * @param commitDiff
         *        a consumer that will call methods on {@link CommitDiffSourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitDiff(CommitDiffSourceCodeType)
         */
        default Builder commitDiff(Consumer<CommitDiffSourceCodeType.Builder> commitDiff) {
            return commitDiff(CommitDiffSourceCodeType.builder().applyMutation(commitDiff).build());
        }

        /**
         * Sets the value of the RepositoryHead property for this object.
         *
         * @param repositoryHead
         *        The new value for the RepositoryHead property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead);

        /**
         * Sets the value of the RepositoryHead property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RepositoryHeadSourceCodeType.Builder}
         * avoiding the need to create one manually via {@link RepositoryHeadSourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryHeadSourceCodeType.Builder#build()} is called
         * immediately and its result is passed to {@link #repositoryHead(RepositoryHeadSourceCodeType)}.
         * 
         * @param repositoryHead
         *        a consumer that will call methods on {@link RepositoryHeadSourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryHead(RepositoryHeadSourceCodeType)
         */
        default Builder repositoryHead(Consumer<RepositoryHeadSourceCodeType.Builder> repositoryHead) {
            return repositoryHead(RepositoryHeadSourceCodeType.builder().applyMutation(repositoryHead).build());
        }

        /**
         * <p>
         * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies a source branch name and a destination branch name in an
         * associated repository.
         * </p>
         * 
         * @param branchDiff
         *        A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         *        <code>SourceCodeType</code> </a> that specifies a source branch name and a destination branch name in
         *        an associated repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchDiff(BranchDiffSourceCodeType branchDiff);

        /**
         * <p>
         * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> that specifies a source branch name and a destination branch name in an
         * associated repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link BranchDiffSourceCodeType.Builder}
         * avoiding the need to create one manually via {@link BranchDiffSourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link BranchDiffSourceCodeType.Builder#build()} is called immediately
         * and its result is passed to {@link #branchDiff(BranchDiffSourceCodeType)}.
         * 
         * @param branchDiff
         *        a consumer that will call methods on {@link BranchDiffSourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branchDiff(BranchDiffSourceCodeType)
         */
        default Builder branchDiff(Consumer<BranchDiffSourceCodeType.Builder> branchDiff) {
            return branchDiff(BranchDiffSourceCodeType.builder().applyMutation(branchDiff).build());
        }

        /**
         * <p>
         * Information about an associated repository in an S3 bucket that includes its name and an
         * <code>S3RepositoryDetails</code> object. The <code>S3RepositoryDetails</code> object includes the name of an
         * S3 bucket, an S3 key for a source code .zip file, and an S3 key for a build artifacts .zip file.
         * <code>S3BucketRepository</code> is required in <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> for <code>S3BucketRepository</code> based code reviews.
         * </p>
         * 
         * @param s3BucketRepository
         *        Information about an associated repository in an S3 bucket that includes its name and an
         *        <code>S3RepositoryDetails</code> object. The <code>S3RepositoryDetails</code> object includes the name
         *        of an S3 bucket, an S3 key for a source code .zip file, and an S3 key for a build artifacts .zip file.
         *        <code>S3BucketRepository</code> is required in <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         *        <code>SourceCodeType</code> </a> for <code>S3BucketRepository</code> based code reviews.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketRepository(S3BucketRepository s3BucketRepository);

        /**
         * <p>
         * Information about an associated repository in an S3 bucket that includes its name and an
         * <code>S3RepositoryDetails</code> object. The <code>S3RepositoryDetails</code> object includes the name of an
         * S3 bucket, an S3 key for a source code .zip file, and an S3 key for a build artifacts .zip file.
         * <code>S3BucketRepository</code> is required in <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * <code>SourceCodeType</code> </a> for <code>S3BucketRepository</code> based code reviews.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketRepository.Builder} avoiding the
         * need to create one manually via {@link S3BucketRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3BucketRepository.Builder#build()} is called immediately and its
         * result is passed to {@link #s3BucketRepository(S3BucketRepository)}.
         * 
         * @param s3BucketRepository
         *        a consumer that will call methods on {@link S3BucketRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketRepository(S3BucketRepository)
         */
        default Builder s3BucketRepository(Consumer<S3BucketRepository.Builder> s3BucketRepository) {
            return s3BucketRepository(S3BucketRepository.builder().applyMutation(s3BucketRepository).build());
        }

        /**
         * <p>
         * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru
         * Reviewer. The <code>RequestMetadaa</code> field captures any event metadata. For example, it might capture
         * metadata associated with an event trigger, such as a push or a pull request.
         * </p>
         * 
         * @param requestMetadata
         *        Metadata that is associated with a code review. This applies to any type of code review supported by
         *        CodeGuru Reviewer. The <code>RequestMetadaa</code> field captures any event metadata. For example, it
         *        might capture metadata associated with an event trigger, such as a push or a pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMetadata(RequestMetadata requestMetadata);

        /**
         * <p>
         * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru
         * Reviewer. The <code>RequestMetadaa</code> field captures any event metadata. For example, it might capture
         * metadata associated with an event trigger, such as a push or a pull request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestMetadata.Builder} avoiding the
         * need to create one manually via {@link RequestMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link RequestMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #requestMetadata(RequestMetadata)}.
         * 
         * @param requestMetadata
         *        a consumer that will call methods on {@link RequestMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestMetadata(RequestMetadata)
         */
        default Builder requestMetadata(Consumer<RequestMetadata.Builder> requestMetadata) {
            return requestMetadata(RequestMetadata.builder().applyMutation(requestMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CommitDiffSourceCodeType commitDiff;

        private RepositoryHeadSourceCodeType repositoryHead;

        private BranchDiffSourceCodeType branchDiff;

        private S3BucketRepository s3BucketRepository;

        private RequestMetadata requestMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCodeType model) {
            commitDiff(model.commitDiff);
            repositoryHead(model.repositoryHead);
            branchDiff(model.branchDiff);
            s3BucketRepository(model.s3BucketRepository);
            requestMetadata(model.requestMetadata);
        }

        public final CommitDiffSourceCodeType.Builder getCommitDiff() {
            return commitDiff != null ? commitDiff.toBuilder() : null;
        }

        public final void setCommitDiff(CommitDiffSourceCodeType.BuilderImpl commitDiff) {
            this.commitDiff = commitDiff != null ? commitDiff.build() : null;
        }

        @Override
        @Transient
        public final Builder commitDiff(CommitDiffSourceCodeType commitDiff) {
            this.commitDiff = commitDiff;
            return this;
        }

        public final RepositoryHeadSourceCodeType.Builder getRepositoryHead() {
            return repositoryHead != null ? repositoryHead.toBuilder() : null;
        }

        public final void setRepositoryHead(RepositoryHeadSourceCodeType.BuilderImpl repositoryHead) {
            this.repositoryHead = repositoryHead != null ? repositoryHead.build() : null;
        }

        @Override
        @Transient
        public final Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead) {
            this.repositoryHead = repositoryHead;
            return this;
        }

        public final BranchDiffSourceCodeType.Builder getBranchDiff() {
            return branchDiff != null ? branchDiff.toBuilder() : null;
        }

        public final void setBranchDiff(BranchDiffSourceCodeType.BuilderImpl branchDiff) {
            this.branchDiff = branchDiff != null ? branchDiff.build() : null;
        }

        @Override
        @Transient
        public final Builder branchDiff(BranchDiffSourceCodeType branchDiff) {
            this.branchDiff = branchDiff;
            return this;
        }

        public final S3BucketRepository.Builder getS3BucketRepository() {
            return s3BucketRepository != null ? s3BucketRepository.toBuilder() : null;
        }

        public final void setS3BucketRepository(S3BucketRepository.BuilderImpl s3BucketRepository) {
            this.s3BucketRepository = s3BucketRepository != null ? s3BucketRepository.build() : null;
        }

        @Override
        @Transient
        public final Builder s3BucketRepository(S3BucketRepository s3BucketRepository) {
            this.s3BucketRepository = s3BucketRepository;
            return this;
        }

        public final RequestMetadata.Builder getRequestMetadata() {
            return requestMetadata != null ? requestMetadata.toBuilder() : null;
        }

        public final void setRequestMetadata(RequestMetadata.BuilderImpl requestMetadata) {
            this.requestMetadata = requestMetadata != null ? requestMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder requestMetadata(RequestMetadata requestMetadata) {
            this.requestMetadata = requestMetadata;
            return this;
        }

        @Override
        public SourceCodeType build() {
            return new SourceCodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
