/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationFeedbackResponse extends CodeGuruReviewerResponse implements
        ToCopyableBuilder<ListRecommendationFeedbackResponse.Builder, ListRecommendationFeedbackResponse> {
    private static final SdkField<List<RecommendationFeedbackSummary>> RECOMMENDATION_FEEDBACK_SUMMARIES_FIELD = SdkField
            .<List<RecommendationFeedbackSummary>> builder(MarshallingType.LIST)
            .memberName("RecommendationFeedbackSummaries")
            .getter(getter(ListRecommendationFeedbackResponse::recommendationFeedbackSummaries))
            .setter(setter(Builder::recommendationFeedbackSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationFeedbackSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationFeedbackSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationFeedbackSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRecommendationFeedbackResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOMMENDATION_FEEDBACK_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<RecommendationFeedbackSummary> recommendationFeedbackSummaries;

    private final String nextToken;

    private ListRecommendationFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationFeedbackSummaries = builder.recommendationFeedbackSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RecommendationFeedbackSummaries property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasRecommendationFeedbackSummaries() {
        return recommendationFeedbackSummaries != null && !(recommendationFeedbackSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Recommendation feedback summaries corresponding to the code review ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecommendationFeedbackSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Recommendation feedback summaries corresponding to the code review ARN.
     */
    public final List<RecommendationFeedbackSummary> recommendationFeedbackSummaries() {
        return recommendationFeedbackSummaries;
    }

    /**
     * <p>
     * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments
     * unchanged.
     * </p>
     * 
     * @return If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRecommendationFeedbackSummaries() ? recommendationFeedbackSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationFeedbackResponse)) {
            return false;
        }
        ListRecommendationFeedbackResponse other = (ListRecommendationFeedbackResponse) obj;
        return hasRecommendationFeedbackSummaries() == other.hasRecommendationFeedbackSummaries()
                && Objects.equals(recommendationFeedbackSummaries(), other.recommendationFeedbackSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListRecommendationFeedbackResponse")
                .add("RecommendationFeedbackSummaries",
                        hasRecommendationFeedbackSummaries() ? recommendationFeedbackSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationFeedbackSummaries":
            return Optional.ofNullable(clazz.cast(recommendationFeedbackSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationFeedbackResponse, T> g) {
        return obj -> g.apply((ListRecommendationFeedbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecommendationFeedbackResponse> {
        /**
         * <p>
         * Recommendation feedback summaries corresponding to the code review ARN.
         * </p>
         * 
         * @param recommendationFeedbackSummaries
         *        Recommendation feedback summaries corresponding to the code review ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationFeedbackSummaries(Collection<RecommendationFeedbackSummary> recommendationFeedbackSummaries);

        /**
         * <p>
         * Recommendation feedback summaries corresponding to the code review ARN.
         * </p>
         * 
         * @param recommendationFeedbackSummaries
         *        Recommendation feedback summaries corresponding to the code review ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationFeedbackSummaries(RecommendationFeedbackSummary... recommendationFeedbackSummaries);

        /**
         * <p>
         * Recommendation feedback summaries corresponding to the code review ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommendationFeedbackSummary>.Builder}
         * avoiding the need to create one manually via {@link List<RecommendationFeedbackSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationFeedbackSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #recommendationFeedbackSummaries(List<RecommendationFeedbackSummary>)}.
         * 
         * @param recommendationFeedbackSummaries
         *        a consumer that will call methods on {@link List<RecommendationFeedbackSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationFeedbackSummaries(List<RecommendationFeedbackSummary>)
         */
        Builder recommendationFeedbackSummaries(
                Consumer<RecommendationFeedbackSummary.Builder>... recommendationFeedbackSummaries);

        /**
         * <p>
         * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        If nextToken is returned, there are more results available. The value of nextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page. Keep all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeGuruReviewerResponse.BuilderImpl implements Builder {
        private List<RecommendationFeedbackSummary> recommendationFeedbackSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationFeedbackResponse model) {
            super(model);
            recommendationFeedbackSummaries(model.recommendationFeedbackSummaries);
            nextToken(model.nextToken);
        }

        public final List<RecommendationFeedbackSummary.Builder> getRecommendationFeedbackSummaries() {
            List<RecommendationFeedbackSummary.Builder> result = RecommendationFeedbackSummariesCopier
                    .copyToBuilder(this.recommendationFeedbackSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationFeedbackSummaries(
                Collection<RecommendationFeedbackSummary.BuilderImpl> recommendationFeedbackSummaries) {
            this.recommendationFeedbackSummaries = RecommendationFeedbackSummariesCopier
                    .copyFromBuilder(recommendationFeedbackSummaries);
        }

        @Override
        @Transient
        public final Builder recommendationFeedbackSummaries(
                Collection<RecommendationFeedbackSummary> recommendationFeedbackSummaries) {
            this.recommendationFeedbackSummaries = RecommendationFeedbackSummariesCopier.copy(recommendationFeedbackSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendationFeedbackSummaries(RecommendationFeedbackSummary... recommendationFeedbackSummaries) {
            recommendationFeedbackSummaries(Arrays.asList(recommendationFeedbackSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendationFeedbackSummaries(
                Consumer<RecommendationFeedbackSummary.Builder>... recommendationFeedbackSummaries) {
            recommendationFeedbackSummaries(Stream.of(recommendationFeedbackSummaries)
                    .map(c -> RecommendationFeedbackSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecommendationFeedbackResponse build() {
            return new ListRecommendationFeedbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
