/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecommendationFeedbackResponse extends CodeGuruReviewerResponse implements
        ToCopyableBuilder<DescribeRecommendationFeedbackResponse.Builder, DescribeRecommendationFeedbackResponse> {
    private static final SdkField<RecommendationFeedback> RECOMMENDATION_FEEDBACK_FIELD = SdkField
            .<RecommendationFeedback> builder(MarshallingType.SDK_POJO).memberName("RecommendationFeedback")
            .getter(getter(DescribeRecommendationFeedbackResponse::recommendationFeedback))
            .setter(setter(Builder::recommendationFeedback)).constructor(RecommendationFeedback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationFeedback").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(RECOMMENDATION_FEEDBACK_FIELD));

    private final RecommendationFeedback recommendationFeedback;

    private DescribeRecommendationFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationFeedback = builder.recommendationFeedback;
    }

    /**
     * <p>
     * The recommendation feedback given by the user.
     * </p>
     * 
     * @return The recommendation feedback given by the user.
     */
    public final RecommendationFeedback recommendationFeedback() {
        return recommendationFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendationFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationFeedbackResponse)) {
            return false;
        }
        DescribeRecommendationFeedbackResponse other = (DescribeRecommendationFeedbackResponse) obj;
        return Objects.equals(recommendationFeedback(), other.recommendationFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecommendationFeedbackResponse").add("RecommendationFeedback", recommendationFeedback())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationFeedback":
            return Optional.ofNullable(clazz.cast(recommendationFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommendationFeedbackResponse, T> g) {
        return obj -> g.apply((DescribeRecommendationFeedbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRecommendationFeedbackResponse> {
        /**
         * <p>
         * The recommendation feedback given by the user.
         * </p>
         * 
         * @param recommendationFeedback
         *        The recommendation feedback given by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationFeedback(RecommendationFeedback recommendationFeedback);

        /**
         * <p>
         * The recommendation feedback given by the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationFeedback.Builder} avoiding
         * the need to create one manually via {@link RecommendationFeedback#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommendationFeedback.Builder#build()} is called immediately and
         * its result is passed to {@link #recommendationFeedback(RecommendationFeedback)}.
         * 
         * @param recommendationFeedback
         *        a consumer that will call methods on {@link RecommendationFeedback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationFeedback(RecommendationFeedback)
         */
        default Builder recommendationFeedback(Consumer<RecommendationFeedback.Builder> recommendationFeedback) {
            return recommendationFeedback(RecommendationFeedback.builder().applyMutation(recommendationFeedback).build());
        }
    }

    static final class BuilderImpl extends CodeGuruReviewerResponse.BuilderImpl implements Builder {
        private RecommendationFeedback recommendationFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommendationFeedbackResponse model) {
            super(model);
            recommendationFeedback(model.recommendationFeedback);
        }

        public final RecommendationFeedback.Builder getRecommendationFeedback() {
            return recommendationFeedback != null ? recommendationFeedback.toBuilder() : null;
        }

        public final void setRecommendationFeedback(RecommendationFeedback.BuilderImpl recommendationFeedback) {
            this.recommendationFeedback = recommendationFeedback != null ? recommendationFeedback.build() : null;
        }

        @Override
        public final Builder recommendationFeedback(RecommendationFeedback recommendationFeedback) {
            this.recommendationFeedback = recommendationFeedback;
            return this;
        }

        @Override
        public DescribeRecommendationFeedbackResponse build() {
            return new DescribeRecommendationFeedbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
