/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
 * <code>SourceCodeType</code> </a> that specifies a code diff between a source and destination branch in an associated
 * repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BranchDiffSourceCodeType implements SdkPojo, Serializable,
        ToCopyableBuilder<BranchDiffSourceCodeType.Builder, BranchDiffSourceCodeType> {
    private static final SdkField<String> SOURCE_BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBranchName").getter(getter(BranchDiffSourceCodeType::sourceBranchName))
            .setter(setter(Builder::sourceBranchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBranchName").build()).build();

    private static final SdkField<String> DESTINATION_BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationBranchName").getter(getter(BranchDiffSourceCodeType::destinationBranchName))
            .setter(setter(Builder::destinationBranchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBranchName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_BRANCH_NAME_FIELD,
            DESTINATION_BRANCH_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceBranchName;

    private final String destinationBranchName;

    private BranchDiffSourceCodeType(BuilderImpl builder) {
        this.sourceBranchName = builder.sourceBranchName;
        this.destinationBranchName = builder.destinationBranchName;
    }

    /**
     * <p>
     * The source branch for a diff in an associated repository.
     * </p>
     * 
     * @return The source branch for a diff in an associated repository.
     */
    public final String sourceBranchName() {
        return sourceBranchName;
    }

    /**
     * <p>
     * The destination branch for a diff in an associated repository.
     * </p>
     * 
     * @return The destination branch for a diff in an associated repository.
     */
    public final String destinationBranchName() {
        return destinationBranchName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationBranchName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BranchDiffSourceCodeType)) {
            return false;
        }
        BranchDiffSourceCodeType other = (BranchDiffSourceCodeType) obj;
        return Objects.equals(sourceBranchName(), other.sourceBranchName())
                && Objects.equals(destinationBranchName(), other.destinationBranchName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BranchDiffSourceCodeType").add("SourceBranchName", sourceBranchName())
                .add("DestinationBranchName", destinationBranchName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceBranchName":
            return Optional.ofNullable(clazz.cast(sourceBranchName()));
        case "DestinationBranchName":
            return Optional.ofNullable(clazz.cast(destinationBranchName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BranchDiffSourceCodeType, T> g) {
        return obj -> g.apply((BranchDiffSourceCodeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BranchDiffSourceCodeType> {
        /**
         * <p>
         * The source branch for a diff in an associated repository.
         * </p>
         * 
         * @param sourceBranchName
         *        The source branch for a diff in an associated repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBranchName(String sourceBranchName);

        /**
         * <p>
         * The destination branch for a diff in an associated repository.
         * </p>
         * 
         * @param destinationBranchName
         *        The destination branch for a diff in an associated repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBranchName(String destinationBranchName);
    }

    static final class BuilderImpl implements Builder {
        private String sourceBranchName;

        private String destinationBranchName;

        private BuilderImpl() {
        }

        private BuilderImpl(BranchDiffSourceCodeType model) {
            sourceBranchName(model.sourceBranchName);
            destinationBranchName(model.destinationBranchName);
        }

        public final String getSourceBranchName() {
            return sourceBranchName;
        }

        public final void setSourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
        }

        @Override
        public final Builder sourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
            return this;
        }

        public final String getDestinationBranchName() {
            return destinationBranchName;
        }

        public final void setDestinationBranchName(String destinationBranchName) {
            this.destinationBranchName = destinationBranchName;
        }

        @Override
        public final Builder destinationBranchName(String destinationBranchName) {
            this.destinationBranchName = destinationBranchName;
            return this;
        }

        @Override
        public BranchDiffSourceCodeType build() {
            return new BranchDiffSourceCodeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
