/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositoryAssociationsResponse extends CodeGuruReviewerResponse implements
        ToCopyableBuilder<ListRepositoryAssociationsResponse.Builder, ListRepositoryAssociationsResponse> {
    private static final SdkField<List<RepositoryAssociationSummary>> REPOSITORY_ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<RepositoryAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("RepositoryAssociationSummaries")
            .getter(getter(ListRepositoryAssociationsResponse::repositoryAssociationSummaries))
            .setter(setter(Builder::repositoryAssociationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAssociationSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRepositoryAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPOSITORY_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<RepositoryAssociationSummary> repositoryAssociationSummaries;

    private final String nextToken;

    private ListRepositoryAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryAssociationSummaries = builder.repositoryAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryAssociationSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRepositoryAssociationSummaries() {
        return repositoryAssociationSummaries != null && !(repositoryAssociationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of repository associations that meet the criteria of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryAssociationSummaries} method.
     * </p>
     * 
     * @return A list of repository associations that meet the criteria of the request.
     */
    public final List<RepositoryAssociationSummary> repositoryAssociationSummaries() {
        return repositoryAssociationSummaries;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListRecommendations</code> request. When the
     * results of a <code>ListRecommendations</code> request exceed <code>maxResults</code>, this value can be used to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListRecommendations</code> request. When
     *         the results of a <code>ListRecommendations</code> request exceed <code>maxResults</code>, this value can
     *         be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRepositoryAssociationSummaries() ? repositoryAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoryAssociationsResponse)) {
            return false;
        }
        ListRepositoryAssociationsResponse other = (ListRepositoryAssociationsResponse) obj;
        return hasRepositoryAssociationSummaries() == other.hasRepositoryAssociationSummaries()
                && Objects.equals(repositoryAssociationSummaries(), other.repositoryAssociationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListRepositoryAssociationsResponse")
                .add("RepositoryAssociationSummaries",
                        hasRepositoryAssociationSummaries() ? repositoryAssociationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryAssociationSummaries":
            return Optional.ofNullable(clazz.cast(repositoryAssociationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoryAssociationsResponse, T> g) {
        return obj -> g.apply((ListRepositoryAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRepositoryAssociationsResponse> {
        /**
         * <p>
         * A list of repository associations that meet the criteria of the request.
         * </p>
         * 
         * @param repositoryAssociationSummaries
         *        A list of repository associations that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryAssociationSummaries(Collection<RepositoryAssociationSummary> repositoryAssociationSummaries);

        /**
         * <p>
         * A list of repository associations that meet the criteria of the request.
         * </p>
         * 
         * @param repositoryAssociationSummaries
         *        A list of repository associations that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryAssociationSummaries(RepositoryAssociationSummary... repositoryAssociationSummaries);

        /**
         * <p>
         * A list of repository associations that meet the criteria of the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <RepositoryAssociationSummary>.Builder} avoiding the need to create one manually via {@link List
         * <RepositoryAssociationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositoryAssociationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #repositoryAssociationSummaries(List<RepositoryAssociationSummary>)}.
         * 
         * @param repositoryAssociationSummaries
         *        a consumer that will call methods on {@link List<RepositoryAssociationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryAssociationSummaries(List<RepositoryAssociationSummary>)
         */
        Builder repositoryAssociationSummaries(Consumer<RepositoryAssociationSummary.Builder>... repositoryAssociationSummaries);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListRecommendations</code> request. When the
         * results of a <code>ListRecommendations</code> request exceed <code>maxResults</code>, this value can be used
         * to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListRecommendations</code> request. When
         *        the results of a <code>ListRecommendations</code> request exceed <code>maxResults</code>, this value
         *        can be used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeGuruReviewerResponse.BuilderImpl implements Builder {
        private List<RepositoryAssociationSummary> repositoryAssociationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoryAssociationsResponse model) {
            super(model);
            repositoryAssociationSummaries(model.repositoryAssociationSummaries);
            nextToken(model.nextToken);
        }

        public final List<RepositoryAssociationSummary.Builder> getRepositoryAssociationSummaries() {
            List<RepositoryAssociationSummary.Builder> result = RepositoryAssociationSummariesCopier
                    .copyToBuilder(this.repositoryAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryAssociationSummaries(
                Collection<RepositoryAssociationSummary.BuilderImpl> repositoryAssociationSummaries) {
            this.repositoryAssociationSummaries = RepositoryAssociationSummariesCopier
                    .copyFromBuilder(repositoryAssociationSummaries);
        }

        @Override
        public final Builder repositoryAssociationSummaries(
                Collection<RepositoryAssociationSummary> repositoryAssociationSummaries) {
            this.repositoryAssociationSummaries = RepositoryAssociationSummariesCopier.copy(repositoryAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryAssociationSummaries(RepositoryAssociationSummary... repositoryAssociationSummaries) {
            repositoryAssociationSummaries(Arrays.asList(repositoryAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryAssociationSummaries(
                Consumer<RepositoryAssociationSummary.Builder>... repositoryAssociationSummaries) {
            repositoryAssociationSummaries(Stream.of(repositoryAssociationSummaries)
                    .map(c -> RepositoryAssociationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRepositoryAssociationsResponse build() {
            return new ListRepositoryAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
