/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an associated Amazon Web Services CodeCommit repository or an associated repository that is managed
 * by Amazon Web Services CodeStar Connections (for example, Bitbucket). This <code>Repository</code> object is not used
 * if your source code is in an associated GitHub repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Repository implements SdkPojo, Serializable, ToCopyableBuilder<Repository.Builder, Repository> {
    private static final SdkField<CodeCommitRepository> CODE_COMMIT_FIELD = SdkField
            .<CodeCommitRepository> builder(MarshallingType.SDK_POJO).memberName("CodeCommit")
            .getter(getter(Repository::codeCommit)).setter(setter(Builder::codeCommit))
            .constructor(CodeCommitRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeCommit").build()).build();

    private static final SdkField<ThirdPartySourceRepository> BITBUCKET_FIELD = SdkField
            .<ThirdPartySourceRepository> builder(MarshallingType.SDK_POJO).memberName("Bitbucket")
            .getter(getter(Repository::bitbucket)).setter(setter(Builder::bitbucket))
            .constructor(ThirdPartySourceRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bitbucket").build()).build();

    private static final SdkField<ThirdPartySourceRepository> GIT_HUB_ENTERPRISE_SERVER_FIELD = SdkField
            .<ThirdPartySourceRepository> builder(MarshallingType.SDK_POJO).memberName("GitHubEnterpriseServer")
            .getter(getter(Repository::gitHubEnterpriseServer)).setter(setter(Builder::gitHubEnterpriseServer))
            .constructor(ThirdPartySourceRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubEnterpriseServer").build())
            .build();

    private static final SdkField<S3Repository> S3_BUCKET_FIELD = SdkField.<S3Repository> builder(MarshallingType.SDK_POJO)
            .memberName("S3Bucket").getter(getter(Repository::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(S3Repository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_COMMIT_FIELD,
            BITBUCKET_FIELD, GIT_HUB_ENTERPRISE_SERVER_FIELD, S3_BUCKET_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeCommitRepository codeCommit;

    private final ThirdPartySourceRepository bitbucket;

    private final ThirdPartySourceRepository gitHubEnterpriseServer;

    private final S3Repository s3Bucket;

    private Repository(BuilderImpl builder) {
        this.codeCommit = builder.codeCommit;
        this.bitbucket = builder.bitbucket;
        this.gitHubEnterpriseServer = builder.gitHubEnterpriseServer;
        this.s3Bucket = builder.s3Bucket;
    }

    /**
     * <p>
     * Information about an Amazon Web Services CodeCommit repository.
     * </p>
     * 
     * @return Information about an Amazon Web Services CodeCommit repository.
     */
    public final CodeCommitRepository codeCommit() {
        return codeCommit;
    }

    /**
     * <p>
     * Information about a Bitbucket repository.
     * </p>
     * 
     * @return Information about a Bitbucket repository.
     */
    public final ThirdPartySourceRepository bitbucket() {
        return bitbucket;
    }

    /**
     * <p>
     * Information about a GitHub Enterprise Server repository.
     * </p>
     * 
     * @return Information about a GitHub Enterprise Server repository.
     */
    public final ThirdPartySourceRepository gitHubEnterpriseServer() {
        return gitHubEnterpriseServer;
    }

    /**
     * Returns the value of the S3Bucket property for this object.
     * 
     * @return The value of the S3Bucket property for this object.
     */
    public final S3Repository s3Bucket() {
        return s3Bucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeCommit());
        hashCode = 31 * hashCode + Objects.hashCode(bitbucket());
        hashCode = 31 * hashCode + Objects.hashCode(gitHubEnterpriseServer());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository) obj;
        return Objects.equals(codeCommit(), other.codeCommit()) && Objects.equals(bitbucket(), other.bitbucket())
                && Objects.equals(gitHubEnterpriseServer(), other.gitHubEnterpriseServer())
                && Objects.equals(s3Bucket(), other.s3Bucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Repository").add("CodeCommit", codeCommit()).add("Bitbucket", bitbucket())
                .add("GitHubEnterpriseServer", gitHubEnterpriseServer()).add("S3Bucket", s3Bucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeCommit":
            return Optional.ofNullable(clazz.cast(codeCommit()));
        case "Bitbucket":
            return Optional.ofNullable(clazz.cast(bitbucket()));
        case "GitHubEnterpriseServer":
            return Optional.ofNullable(clazz.cast(gitHubEnterpriseServer()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Repository, T> g) {
        return obj -> g.apply((Repository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Repository> {
        /**
         * <p>
         * Information about an Amazon Web Services CodeCommit repository.
         * </p>
         * 
         * @param codeCommit
         *        Information about an Amazon Web Services CodeCommit repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeCommit(CodeCommitRepository codeCommit);

        /**
         * <p>
         * Information about an Amazon Web Services CodeCommit repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeCommitRepository.Builder} avoiding
         * the need to create one manually via {@link CodeCommitRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeCommitRepository.Builder#build()} is called immediately and
         * its result is passed to {@link #codeCommit(CodeCommitRepository)}.
         * 
         * @param codeCommit
         *        a consumer that will call methods on {@link CodeCommitRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeCommit(CodeCommitRepository)
         */
        default Builder codeCommit(Consumer<CodeCommitRepository.Builder> codeCommit) {
            return codeCommit(CodeCommitRepository.builder().applyMutation(codeCommit).build());
        }

        /**
         * <p>
         * Information about a Bitbucket repository.
         * </p>
         * 
         * @param bitbucket
         *        Information about a Bitbucket repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitbucket(ThirdPartySourceRepository bitbucket);

        /**
         * <p>
         * Information about a Bitbucket repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThirdPartySourceRepository.Builder}
         * avoiding the need to create one manually via {@link ThirdPartySourceRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThirdPartySourceRepository.Builder#build()} is called immediately
         * and its result is passed to {@link #bitbucket(ThirdPartySourceRepository)}.
         * 
         * @param bitbucket
         *        a consumer that will call methods on {@link ThirdPartySourceRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bitbucket(ThirdPartySourceRepository)
         */
        default Builder bitbucket(Consumer<ThirdPartySourceRepository.Builder> bitbucket) {
            return bitbucket(ThirdPartySourceRepository.builder().applyMutation(bitbucket).build());
        }

        /**
         * <p>
         * Information about a GitHub Enterprise Server repository.
         * </p>
         * 
         * @param gitHubEnterpriseServer
         *        Information about a GitHub Enterprise Server repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubEnterpriseServer(ThirdPartySourceRepository gitHubEnterpriseServer);

        /**
         * <p>
         * Information about a GitHub Enterprise Server repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThirdPartySourceRepository.Builder}
         * avoiding the need to create one manually via {@link ThirdPartySourceRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThirdPartySourceRepository.Builder#build()} is called immediately
         * and its result is passed to {@link #gitHubEnterpriseServer(ThirdPartySourceRepository)}.
         * 
         * @param gitHubEnterpriseServer
         *        a consumer that will call methods on {@link ThirdPartySourceRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubEnterpriseServer(ThirdPartySourceRepository)
         */
        default Builder gitHubEnterpriseServer(Consumer<ThirdPartySourceRepository.Builder> gitHubEnterpriseServer) {
            return gitHubEnterpriseServer(ThirdPartySourceRepository.builder().applyMutation(gitHubEnterpriseServer).build());
        }

        /**
         * Sets the value of the S3Bucket property for this object.
         *
         * @param s3Bucket
         *        The new value for the S3Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(S3Repository s3Bucket);

        /**
         * Sets the value of the S3Bucket property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Repository.Builder} avoiding the need
         * to create one manually via {@link S3Repository#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Repository.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Bucket(S3Repository)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link S3Repository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(S3Repository)
         */
        default Builder s3Bucket(Consumer<S3Repository.Builder> s3Bucket) {
            return s3Bucket(S3Repository.builder().applyMutation(s3Bucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CodeCommitRepository codeCommit;

        private ThirdPartySourceRepository bitbucket;

        private ThirdPartySourceRepository gitHubEnterpriseServer;

        private S3Repository s3Bucket;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            codeCommit(model.codeCommit);
            bitbucket(model.bitbucket);
            gitHubEnterpriseServer(model.gitHubEnterpriseServer);
            s3Bucket(model.s3Bucket);
        }

        public final CodeCommitRepository.Builder getCodeCommit() {
            return codeCommit != null ? codeCommit.toBuilder() : null;
        }

        public final void setCodeCommit(CodeCommitRepository.BuilderImpl codeCommit) {
            this.codeCommit = codeCommit != null ? codeCommit.build() : null;
        }

        @Override
        public final Builder codeCommit(CodeCommitRepository codeCommit) {
            this.codeCommit = codeCommit;
            return this;
        }

        public final ThirdPartySourceRepository.Builder getBitbucket() {
            return bitbucket != null ? bitbucket.toBuilder() : null;
        }

        public final void setBitbucket(ThirdPartySourceRepository.BuilderImpl bitbucket) {
            this.bitbucket = bitbucket != null ? bitbucket.build() : null;
        }

        @Override
        public final Builder bitbucket(ThirdPartySourceRepository bitbucket) {
            this.bitbucket = bitbucket;
            return this;
        }

        public final ThirdPartySourceRepository.Builder getGitHubEnterpriseServer() {
            return gitHubEnterpriseServer != null ? gitHubEnterpriseServer.toBuilder() : null;
        }

        public final void setGitHubEnterpriseServer(ThirdPartySourceRepository.BuilderImpl gitHubEnterpriseServer) {
            this.gitHubEnterpriseServer = gitHubEnterpriseServer != null ? gitHubEnterpriseServer.build() : null;
        }

        @Override
        public final Builder gitHubEnterpriseServer(ThirdPartySourceRepository gitHubEnterpriseServer) {
            this.gitHubEnterpriseServer = gitHubEnterpriseServer;
            return this;
        }

        public final S3Repository.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3Repository.BuilderImpl s3Bucket) {
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
        }

        @Override
        public final Builder s3Bucket(S3Repository s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        @Override
        public Repository build() {
            return new Repository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
