/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum RecommendationCategory {
    AWS_BEST_PRACTICES("AWSBestPractices"),

    AWS_CLOUD_FORMATION_ISSUES("AWSCloudFormationIssues"),

    DUPLICATE_CODE("DuplicateCode"),

    CODE_MAINTENANCE_ISSUES("CodeMaintenanceIssues"),

    CONCURRENCY_ISSUES("ConcurrencyIssues"),

    INPUT_VALIDATIONS("InputValidations"),

    PYTHON_BEST_PRACTICES("PythonBestPractices"),

    JAVA_BEST_PRACTICES("JavaBestPractices"),

    RESOURCE_LEAKS("ResourceLeaks"),

    SECURITY_ISSUES("SecurityIssues"),

    CODE_INCONSISTENCIES("CodeInconsistencies"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RecommendationCategory(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return RecommendationCategory corresponding to the value
     */
    public static RecommendationCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RecommendationCategory.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link RecommendationCategory}s
     */
    public static Set<RecommendationCategory> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
