/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Code artifacts are source code artifacts and build artifacts used in a repository analysis or a pull request review.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Source code artifacts are source code files in a Git repository that are compressed into a .zip file.
 * </p>
 * </li>
 * <li>
 * <p>
 * Build artifacts are .jar or .class files that are compressed in a .zip file.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeArtifacts implements SdkPojo, Serializable, ToCopyableBuilder<CodeArtifacts.Builder, CodeArtifacts> {
    private static final SdkField<String> SOURCE_CODE_ARTIFACTS_OBJECT_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCodeArtifactsObjectKey")
            .getter(getter(CodeArtifacts::sourceCodeArtifactsObjectKey))
            .setter(setter(Builder::sourceCodeArtifactsObjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCodeArtifactsObjectKey")
                    .build()).build();

    private static final SdkField<String> BUILD_ARTIFACTS_OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuildArtifactsObjectKey").getter(getter(CodeArtifacts::buildArtifactsObjectKey))
            .setter(setter(Builder::buildArtifactsObjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildArtifactsObjectKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_CODE_ARTIFACTS_OBJECT_KEY_FIELD, BUILD_ARTIFACTS_OBJECT_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceCodeArtifactsObjectKey;

    private final String buildArtifactsObjectKey;

    private CodeArtifacts(BuilderImpl builder) {
        this.sourceCodeArtifactsObjectKey = builder.sourceCodeArtifactsObjectKey;
        this.buildArtifactsObjectKey = builder.buildArtifactsObjectKey;
    }

    /**
     * <p>
     * The S3 object key for a source code .zip file. This is required for all code reviews.
     * </p>
     * 
     * @return The S3 object key for a source code .zip file. This is required for all code reviews.
     */
    public final String sourceCodeArtifactsObjectKey() {
        return sourceCodeArtifactsObjectKey;
    }

    /**
     * <p>
     * The S3 object key for a build artifacts .zip file that contains .jar or .class files. This is required for a code
     * review with security analysis. For more information, see <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with
     * security analysis</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
     * </p>
     * 
     * @return The S3 object key for a build artifacts .zip file that contains .jar or .class files. This is required
     *         for a code review with security analysis. For more information, see <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code
     *         reviews with security analysis</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
     */
    public final String buildArtifactsObjectKey() {
        return buildArtifactsObjectKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeArtifactsObjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(buildArtifactsObjectKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeArtifacts)) {
            return false;
        }
        CodeArtifacts other = (CodeArtifacts) obj;
        return Objects.equals(sourceCodeArtifactsObjectKey(), other.sourceCodeArtifactsObjectKey())
                && Objects.equals(buildArtifactsObjectKey(), other.buildArtifactsObjectKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeArtifacts").add("SourceCodeArtifactsObjectKey", sourceCodeArtifactsObjectKey())
                .add("BuildArtifactsObjectKey", buildArtifactsObjectKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceCodeArtifactsObjectKey":
            return Optional.ofNullable(clazz.cast(sourceCodeArtifactsObjectKey()));
        case "BuildArtifactsObjectKey":
            return Optional.ofNullable(clazz.cast(buildArtifactsObjectKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeArtifacts, T> g) {
        return obj -> g.apply((CodeArtifacts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeArtifacts> {
        /**
         * <p>
         * The S3 object key for a source code .zip file. This is required for all code reviews.
         * </p>
         * 
         * @param sourceCodeArtifactsObjectKey
         *        The S3 object key for a source code .zip file. This is required for all code reviews.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeArtifactsObjectKey(String sourceCodeArtifactsObjectKey);

        /**
         * <p>
         * The S3 object key for a build artifacts .zip file that contains .jar or .class files. This is required for a
         * code review with security analysis. For more information, see <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews
         * with security analysis</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
         * </p>
         * 
         * @param buildArtifactsObjectKey
         *        The S3 object key for a build artifacts .zip file that contains .jar or .class files. This is required
         *        for a code review with security analysis. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code
         *        reviews with security analysis</a> in the <i>Amazon CodeGuru Reviewer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildArtifactsObjectKey(String buildArtifactsObjectKey);
    }

    static final class BuilderImpl implements Builder {
        private String sourceCodeArtifactsObjectKey;

        private String buildArtifactsObjectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeArtifacts model) {
            sourceCodeArtifactsObjectKey(model.sourceCodeArtifactsObjectKey);
            buildArtifactsObjectKey(model.buildArtifactsObjectKey);
        }

        public final String getSourceCodeArtifactsObjectKey() {
            return sourceCodeArtifactsObjectKey;
        }

        @Override
        public final Builder sourceCodeArtifactsObjectKey(String sourceCodeArtifactsObjectKey) {
            this.sourceCodeArtifactsObjectKey = sourceCodeArtifactsObjectKey;
            return this;
        }

        public final void setSourceCodeArtifactsObjectKey(String sourceCodeArtifactsObjectKey) {
            this.sourceCodeArtifactsObjectKey = sourceCodeArtifactsObjectKey;
        }

        public final String getBuildArtifactsObjectKey() {
            return buildArtifactsObjectKey;
        }

        @Override
        public final Builder buildArtifactsObjectKey(String buildArtifactsObjectKey) {
            this.buildArtifactsObjectKey = buildArtifactsObjectKey;
            return this;
        }

        public final void setBuildArtifactsObjectKey(String buildArtifactsObjectKey) {
            this.buildArtifactsObjectKey = buildArtifactsObjectKey;
        }

        @Override
        public CodeArtifacts build() {
            return new CodeArtifacts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
