/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an associated repository in an S3 bucket. The associated repository contains a source code .zip
 * file and a build artifacts .zip file that contains .jar or .class files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketRepository implements SdkPojo, Serializable,
        ToCopyableBuilder<S3BucketRepository.Builder, S3BucketRepository> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(S3BucketRepository::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<S3RepositoryDetails> DETAILS_FIELD = SdkField
            .<S3RepositoryDetails> builder(MarshallingType.SDK_POJO).memberName("Details")
            .getter(getter(S3BucketRepository::details)).setter(setter(Builder::details))
            .constructor(S3RepositoryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final S3RepositoryDetails details;

    private S3BucketRepository(BuilderImpl builder) {
        this.name = builder.name;
        this.details = builder.details;
    }

    /**
     * <p>
     * The name of the repository when the <code>ProviderType</code> is <code>S3Bucket</code>.
     * </p>
     * 
     * @return The name of the repository when the <code>ProviderType</code> is <code>S3Bucket</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and a
     * <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object keys for a source
     * code .zip file and for a build artifacts .zip file.
     * </p>
     * 
     * @return An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and a
     *         <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object keys for
     *         a source code .zip file and for a build artifacts .zip file.
     */
    public final S3RepositoryDetails details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketRepository)) {
            return false;
        }
        S3BucketRepository other = (S3BucketRepository) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketRepository").add("Name", name()).add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketRepository, T> g) {
        return obj -> g.apply((S3BucketRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketRepository> {
        /**
         * <p>
         * The name of the repository when the <code>ProviderType</code> is <code>S3Bucket</code>.
         * </p>
         * 
         * @param name
         *        The name of the repository when the <code>ProviderType</code> is <code>S3Bucket</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and a
         * <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object keys for a
         * source code .zip file and for a build artifacts .zip file.
         * </p>
         * 
         * @param details
         *        An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and a
         *        <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object keys
         *        for a source code .zip file and for a build artifacts .zip file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(S3RepositoryDetails details);

        /**
         * <p>
         * An <code>S3RepositoryDetails</code> object that specifies the name of an S3 bucket and a
         * <code>CodeArtifacts</code> object. The <code>CodeArtifacts</code> object includes the S3 object keys for a
         * source code .zip file and for a build artifacts .zip file.
         * </p>
         * This is a convenience that creates an instance of the {@link S3RepositoryDetails.Builder} avoiding the need
         * to create one manually via {@link S3RepositoryDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3RepositoryDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #details(S3RepositoryDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link S3RepositoryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(S3RepositoryDetails)
         */
        default Builder details(Consumer<S3RepositoryDetails.Builder> details) {
            return details(S3RepositoryDetails.builder().applyMutation(details).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private S3RepositoryDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketRepository model) {
            name(model.name);
            details(model.details);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3RepositoryDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(S3RepositoryDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        @Transient
        public final Builder details(S3RepositoryDetails details) {
            this.details = details;
            return this;
        }

        @Override
        public S3BucketRepository build() {
            return new S3BucketRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
