/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCodeReviewRequest extends CodeGuruReviewerRequest implements
        ToCopyableBuilder<CreateCodeReviewRequest.Builder, CreateCodeReviewRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCodeReviewRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REPOSITORY_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryAssociationArn").getter(getter(CreateCodeReviewRequest::repositoryAssociationArn))
            .setter(setter(Builder::repositoryAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAssociationArn").build())
            .build();

    private static final SdkField<CodeReviewType> TYPE_FIELD = SdkField.<CodeReviewType> builder(MarshallingType.SDK_POJO)
            .memberName("Type").getter(getter(CreateCodeReviewRequest::type)).setter(setter(Builder::type))
            .constructor(CodeReviewType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateCodeReviewRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REPOSITORY_ASSOCIATION_ARN_FIELD, TYPE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String name;

    private final String repositoryAssociationArn;

    private final CodeReviewType type;

    private final String clientRequestToken;

    private CreateCodeReviewRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.repositoryAssociationArn = builder.repositoryAssociationArn;
        this.type = builder.type;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
     * </p>
     * 
     * @return The name of the code review. The name of each code review in your Amazon Web Services account must be
     *         unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     * <code>ListRepositoryAssociations</code> </a>.
     * </p>
     * <p>
     * A code review can only be created on an associated repository. This is the ARN of the associated repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     *         <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     *         <code>ListRepositoryAssociations</code> </a>. </p>
     *         <p>
     *         A code review can only be created on an associated repository. This is the ARN of the associated
     *         repository.
     */
    public final String repositoryAssociationArn() {
        return repositoryAssociationArn;
    }

    /**
     * <p>
     * The type of code review to create. This is specified using a <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
     * <code>CodeReviewType</code> </a> object. You can create a code review only of type
     * <code>RepositoryAnalysis</code>.
     * </p>
     * 
     * @return The type of code review to create. This is specified using a <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
     *         <code>CodeReviewType</code> </a> object. You can create a code review only of type
     *         <code>RepositoryAnalysis</code>.
     */
    public final CodeReviewType type() {
        return type;
    }

    /**
     * <p>
     * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there
     * are failures and retries.
     * </p>
     * 
     * @return Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if
     *         there are failures and retries.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeReviewRequest)) {
            return false;
        }
        CreateCodeReviewRequest other = (CreateCodeReviewRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(repositoryAssociationArn(), other.repositoryAssociationArn())
                && Objects.equals(type(), other.type()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCodeReviewRequest").add("Name", name())
                .add("RepositoryAssociationArn", repositoryAssociationArn()).add("Type", type())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RepositoryAssociationArn":
            return Optional.ofNullable(clazz.cast(repositoryAssociationArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeReviewRequest, T> g) {
        return obj -> g.apply((CreateCodeReviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCodeReviewRequest> {
        /**
         * <p>
         * The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
         * </p>
         * 
         * @param name
         *        The name of the code review. The name of each code review in your Amazon Web Services account must be
         *        unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * <code>ListRepositoryAssociations</code> </a>.
         * </p>
         * <p>
         * A code review can only be created on an associated repository. This is the ARN of the associated repository.
         * </p>
         * 
         * @param repositoryAssociationArn
         *        The Amazon Resource Name (ARN) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         *        <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         *        <code>ListRepositoryAssociations</code> </a>. </p>
         *        <p>
         *        A code review can only be created on an associated repository. This is the ARN of the associated
         *        repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryAssociationArn(String repositoryAssociationArn);

        /**
         * <p>
         * The type of code review to create. This is specified using a <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
         * <code>CodeReviewType</code> </a> object. You can create a code review only of type
         * <code>RepositoryAnalysis</code>.
         * </p>
         * 
         * @param type
         *        The type of code review to create. This is specified using a <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
         *        <code>CodeReviewType</code> </a> object. You can create a code review only of type
         *        <code>RepositoryAnalysis</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(CodeReviewType type);

        /**
         * <p>
         * The type of code review to create. This is specified using a <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
         * <code>CodeReviewType</code> </a> object. You can create a code review only of type
         * <code>RepositoryAnalysis</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeReviewType.Builder} avoiding the need to
         * create one manually via {@link CodeReviewType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeReviewType.Builder#build()} is called immediately and its
         * result is passed to {@link #type(CodeReviewType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link CodeReviewType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(CodeReviewType)
         */
        default Builder type(Consumer<CodeReviewType.Builder> type) {
            return type(CodeReviewType.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if
         * there are failures and retries.
         * </p>
         * 
         * @param clientRequestToken
         *        Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews
         *        if there are failures and retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruReviewerRequest.BuilderImpl implements Builder {
        private String name;

        private String repositoryAssociationArn;

        private CodeReviewType type;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeReviewRequest model) {
            super(model);
            name(model.name);
            repositoryAssociationArn(model.repositoryAssociationArn);
            type(model.type);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRepositoryAssociationArn() {
            return repositoryAssociationArn;
        }

        public final void setRepositoryAssociationArn(String repositoryAssociationArn) {
            this.repositoryAssociationArn = repositoryAssociationArn;
        }

        @Override
        @Transient
        public final Builder repositoryAssociationArn(String repositoryAssociationArn) {
            this.repositoryAssociationArn = repositoryAssociationArn;
            return this;
        }

        public final CodeReviewType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(CodeReviewType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        @Transient
        public final Builder type(CodeReviewType type) {
            this.type = type;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeReviewRequest build() {
            return new CreateCodeReviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
