/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.KMSKeyDetails;
import software.amazon.awssdk.services.codegurureviewer.model.Repository;
import software.amazon.awssdk.services.codegurureviewer.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateRepositoryRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, AssociateRepositoryRequest> {
    private static final SdkField<Repository> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Repository").getter(AssociateRepositoryRequest.getter(AssociateRepositoryRequest::repository)).setter(AssociateRepositoryRequest.setter(Builder::repository)).constructor(Repository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(AssociateRepositoryRequest.getter(AssociateRepositoryRequest::clientRequestToken)).setter(AssociateRepositoryRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(AssociateRepositoryRequest.getter(AssociateRepositoryRequest::tags)).setter(AssociateRepositoryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<KMSKeyDetails> KMS_KEY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KMSKeyDetails").getter(AssociateRepositoryRequest.getter(AssociateRepositoryRequest::kmsKeyDetails)).setter(AssociateRepositoryRequest.setter(Builder::kmsKeyDetails)).constructor(KMSKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, KMS_KEY_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateRepositoryRequest.memberNameToFieldInitializer();
    private final Repository repository;
    private final String clientRequestToken;
    private final Map<String, String> tags;
    private final KMSKeyDetails kmsKeyDetails;

    private AssociateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.repository = builder.repository;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.kmsKeyDetails = builder.kmsKeyDetails;
    }

    public final Repository repository() {
        return this.repository;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final KMSKeyDetails kmsKeyDetails() {
        return this.kmsKeyDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRepositoryRequest)) {
            return false;
        }
        AssociateRepositoryRequest other = (AssociateRepositoryRequest)((Object)obj);
        return Objects.equals(this.repository(), other.repository()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyDetails(), other.kmsKeyDetails());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateRepositoryRequest").add("Repository", (Object)this.repository()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).add("KMSKeyDetails", (Object)this.kmsKeyDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KMSKeyDetails": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Repository", REPOSITORY_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KMSKeyDetails", KMS_KEY_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateRepositoryRequest, T> g) {
        return obj -> g.apply((AssociateRepositoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private Repository repository;
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private KMSKeyDetails kmsKeyDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRepositoryRequest model) {
            super(model);
            this.repository(model.repository);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.kmsKeyDetails(model.kmsKeyDetails);
        }

        public final Repository.Builder getRepository() {
            return this.repository != null ? this.repository.toBuilder() : null;
        }

        public final void setRepository(Repository.BuilderImpl repository) {
            this.repository = repository != null ? repository.build() : null;
        }

        @Override
        public final Builder repository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final KMSKeyDetails.Builder getKmsKeyDetails() {
            return this.kmsKeyDetails != null ? this.kmsKeyDetails.toBuilder() : null;
        }

        public final void setKmsKeyDetails(KMSKeyDetails.BuilderImpl kmsKeyDetails) {
            this.kmsKeyDetails = kmsKeyDetails != null ? kmsKeyDetails.build() : null;
        }

        @Override
        public final Builder kmsKeyDetails(KMSKeyDetails kmsKeyDetails) {
            this.kmsKeyDetails = kmsKeyDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateRepositoryRequest build() {
            return new AssociateRepositoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateRepositoryRequest> {
        public Builder repository(Repository var1);

        default public Builder repository(Consumer<Repository.Builder> repository) {
            return this.repository((Repository)((Repository.Builder)Repository.builder().applyMutation(repository)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyDetails(KMSKeyDetails var1);

        default public Builder kmsKeyDetails(Consumer<KMSKeyDetails.Builder> kmsKeyDetails) {
            return this.kmsKeyDetails((KMSKeyDetails)((KMSKeyDetails.Builder)KMSKeyDetails.builder().applyMutation(kmsKeyDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

