/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCodeReviewsResponse extends CodeGuruReviewerResponse implements
        ToCopyableBuilder<ListCodeReviewsResponse.Builder, ListCodeReviewsResponse> {
    private static final SdkField<List<CodeReviewSummary>> CODE_REVIEW_SUMMARIES_FIELD = SdkField
            .<List<CodeReviewSummary>> builder(MarshallingType.LIST)
            .memberName("CodeReviewSummaries")
            .getter(getter(ListCodeReviewsResponse::codeReviewSummaries))
            .setter(setter(Builder::codeReviewSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeReviewSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeReviewSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCodeReviewsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CodeReviewSummary> codeReviewSummaries;

    private final String nextToken;

    private ListCodeReviewsResponse(BuilderImpl builder) {
        super(builder);
        this.codeReviewSummaries = builder.codeReviewSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeReviewSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCodeReviewSummaries() {
        return codeReviewSummaries != null && !(codeReviewSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of code reviews that meet the criteria of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeReviewSummaries} method.
     * </p>
     * 
     * @return A list of code reviews that meet the criteria of the request.
     */
    public final List<CodeReviewSummary> codeReviewSummaries() {
        return codeReviewSummaries;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeReviewSummaries() ? codeReviewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeReviewsResponse)) {
            return false;
        }
        ListCodeReviewsResponse other = (ListCodeReviewsResponse) obj;
        return hasCodeReviewSummaries() == other.hasCodeReviewSummaries()
                && Objects.equals(codeReviewSummaries(), other.codeReviewSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCodeReviewsResponse")
                .add("CodeReviewSummaries", hasCodeReviewSummaries() ? codeReviewSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeReviewSummaries":
            return Optional.ofNullable(clazz.cast(codeReviewSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CodeReviewSummaries", CODE_REVIEW_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCodeReviewsResponse, T> g) {
        return obj -> g.apply((ListCodeReviewsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCodeReviewsResponse> {
        /**
         * <p>
         * A list of code reviews that meet the criteria of the request.
         * </p>
         * 
         * @param codeReviewSummaries
         *        A list of code reviews that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewSummaries(Collection<CodeReviewSummary> codeReviewSummaries);

        /**
         * <p>
         * A list of code reviews that meet the criteria of the request.
         * </p>
         * 
         * @param codeReviewSummaries
         *        A list of code reviews that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewSummaries(CodeReviewSummary... codeReviewSummaries);

        /**
         * <p>
         * A list of code reviews that meet the criteria of the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #codeReviewSummaries(List<CodeReviewSummary>)}.
         * 
         * @param codeReviewSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeReviewSummaries(java.util.Collection<CodeReviewSummary>)
         */
        Builder codeReviewSummaries(Consumer<CodeReviewSummary.Builder>... codeReviewSummaries);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeGuruReviewerResponse.BuilderImpl implements Builder {
        private List<CodeReviewSummary> codeReviewSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeReviewsResponse model) {
            super(model);
            codeReviewSummaries(model.codeReviewSummaries);
            nextToken(model.nextToken);
        }

        public final List<CodeReviewSummary.Builder> getCodeReviewSummaries() {
            List<CodeReviewSummary.Builder> result = CodeReviewSummariesCopier.copyToBuilder(this.codeReviewSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeReviewSummaries(Collection<CodeReviewSummary.BuilderImpl> codeReviewSummaries) {
            this.codeReviewSummaries = CodeReviewSummariesCopier.copyFromBuilder(codeReviewSummaries);
        }

        @Override
        public final Builder codeReviewSummaries(Collection<CodeReviewSummary> codeReviewSummaries) {
            this.codeReviewSummaries = CodeReviewSummariesCopier.copy(codeReviewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeReviewSummaries(CodeReviewSummary... codeReviewSummaries) {
            codeReviewSummaries(Arrays.asList(codeReviewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeReviewSummaries(Consumer<CodeReviewSummary.Builder>... codeReviewSummaries) {
            codeReviewSummaries(Stream.of(codeReviewSummaries).map(c -> CodeReviewSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCodeReviewsResponse build() {
            return new ListCodeReviewsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
