/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the statistics from the code review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metrics implements SdkPojo, Serializable, ToCopyableBuilder<Metrics.Builder, Metrics> {
    private static final SdkField<Long> METERED_LINES_OF_CODE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MeteredLinesOfCodeCount").getter(getter(Metrics::meteredLinesOfCodeCount))
            .setter(setter(Builder::meteredLinesOfCodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredLinesOfCodeCount").build())
            .build();

    private static final SdkField<Long> SUPPRESSED_LINES_OF_CODE_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("SuppressedLinesOfCodeCount")
            .getter(getter(Metrics::suppressedLinesOfCodeCount))
            .setter(setter(Builder::suppressedLinesOfCodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedLinesOfCodeCount").build())
            .build();

    private static final SdkField<Long> FINDINGS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FindingsCount").getter(getter(Metrics::findingsCount)).setter(setter(Builder::findingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METERED_LINES_OF_CODE_COUNT_FIELD, SUPPRESSED_LINES_OF_CODE_COUNT_FIELD, FINDINGS_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long meteredLinesOfCodeCount;

    private final Long suppressedLinesOfCodeCount;

    private final Long findingsCount;

    private Metrics(BuilderImpl builder) {
        this.meteredLinesOfCodeCount = builder.meteredLinesOfCodeCount;
        this.suppressedLinesOfCodeCount = builder.suppressedLinesOfCodeCount;
        this.findingsCount = builder.findingsCount;
    }

    /**
     * <p>
     * <code>MeteredLinesOfCodeCount</code> is the number of lines of code in the repository where the code review
     * happened. This does not include non-code lines such as comments and blank lines.
     * </p>
     * 
     * @return <code>MeteredLinesOfCodeCount</code> is the number of lines of code in the repository where the code
     *         review happened. This does not include non-code lines such as comments and blank lines.
     */
    public final Long meteredLinesOfCodeCount() {
        return meteredLinesOfCodeCount;
    }

    /**
     * <p>
     * <code>SuppressedLinesOfCodeCount</code> is the number of lines of code in the repository where the code review
     * happened that CodeGuru Reviewer did not analyze. The lines suppressed in the analysis is based on the
     * <code>excludeFiles</code> variable in the <code>aws-codeguru-reviewer.yml</code> file. This number does not
     * include non-code lines such as comments and blank lines.
     * </p>
     * 
     * @return <code>SuppressedLinesOfCodeCount</code> is the number of lines of code in the repository where the code
     *         review happened that CodeGuru Reviewer did not analyze. The lines suppressed in the analysis is based on
     *         the <code>excludeFiles</code> variable in the <code>aws-codeguru-reviewer.yml</code> file. This number
     *         does not include non-code lines such as comments and blank lines.
     */
    public final Long suppressedLinesOfCodeCount() {
        return suppressedLinesOfCodeCount;
    }

    /**
     * <p>
     * Total number of recommendations found in the code review.
     * </p>
     * 
     * @return Total number of recommendations found in the code review.
     */
    public final Long findingsCount() {
        return findingsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meteredLinesOfCodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(suppressedLinesOfCodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(findingsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics) obj;
        return Objects.equals(meteredLinesOfCodeCount(), other.meteredLinesOfCodeCount())
                && Objects.equals(suppressedLinesOfCodeCount(), other.suppressedLinesOfCodeCount())
                && Objects.equals(findingsCount(), other.findingsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metrics").add("MeteredLinesOfCodeCount", meteredLinesOfCodeCount())
                .add("SuppressedLinesOfCodeCount", suppressedLinesOfCodeCount()).add("FindingsCount", findingsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeteredLinesOfCodeCount":
            return Optional.ofNullable(clazz.cast(meteredLinesOfCodeCount()));
        case "SuppressedLinesOfCodeCount":
            return Optional.ofNullable(clazz.cast(suppressedLinesOfCodeCount()));
        case "FindingsCount":
            return Optional.ofNullable(clazz.cast(findingsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MeteredLinesOfCodeCount", METERED_LINES_OF_CODE_COUNT_FIELD);
        map.put("SuppressedLinesOfCodeCount", SUPPRESSED_LINES_OF_CODE_COUNT_FIELD);
        map.put("FindingsCount", FINDINGS_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metrics, T> g) {
        return obj -> g.apply((Metrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metrics> {
        /**
         * <p>
         * <code>MeteredLinesOfCodeCount</code> is the number of lines of code in the repository where the code review
         * happened. This does not include non-code lines such as comments and blank lines.
         * </p>
         * 
         * @param meteredLinesOfCodeCount
         *        <code>MeteredLinesOfCodeCount</code> is the number of lines of code in the repository where the code
         *        review happened. This does not include non-code lines such as comments and blank lines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meteredLinesOfCodeCount(Long meteredLinesOfCodeCount);

        /**
         * <p>
         * <code>SuppressedLinesOfCodeCount</code> is the number of lines of code in the repository where the code
         * review happened that CodeGuru Reviewer did not analyze. The lines suppressed in the analysis is based on the
         * <code>excludeFiles</code> variable in the <code>aws-codeguru-reviewer.yml</code> file. This number does not
         * include non-code lines such as comments and blank lines.
         * </p>
         * 
         * @param suppressedLinesOfCodeCount
         *        <code>SuppressedLinesOfCodeCount</code> is the number of lines of code in the repository where the
         *        code review happened that CodeGuru Reviewer did not analyze. The lines suppressed in the analysis is
         *        based on the <code>excludeFiles</code> variable in the <code>aws-codeguru-reviewer.yml</code> file.
         *        This number does not include non-code lines such as comments and blank lines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedLinesOfCodeCount(Long suppressedLinesOfCodeCount);

        /**
         * <p>
         * Total number of recommendations found in the code review.
         * </p>
         * 
         * @param findingsCount
         *        Total number of recommendations found in the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsCount(Long findingsCount);
    }

    static final class BuilderImpl implements Builder {
        private Long meteredLinesOfCodeCount;

        private Long suppressedLinesOfCodeCount;

        private Long findingsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Metrics model) {
            meteredLinesOfCodeCount(model.meteredLinesOfCodeCount);
            suppressedLinesOfCodeCount(model.suppressedLinesOfCodeCount);
            findingsCount(model.findingsCount);
        }

        public final Long getMeteredLinesOfCodeCount() {
            return meteredLinesOfCodeCount;
        }

        public final void setMeteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
        }

        @Override
        public final Builder meteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
            return this;
        }

        public final Long getSuppressedLinesOfCodeCount() {
            return suppressedLinesOfCodeCount;
        }

        public final void setSuppressedLinesOfCodeCount(Long suppressedLinesOfCodeCount) {
            this.suppressedLinesOfCodeCount = suppressedLinesOfCodeCount;
        }

        @Override
        public final Builder suppressedLinesOfCodeCount(Long suppressedLinesOfCodeCount) {
            this.suppressedLinesOfCodeCount = suppressedLinesOfCodeCount;
            return this;
        }

        public final Long getFindingsCount() {
            return findingsCount;
        }

        public final void setFindingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
        }

        @Override
        public final Builder findingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
            return this;
        }

        @Override
        public Metrics build() {
            return new Metrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
