/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata that is associated with a code review. This applies to both pull request and repository analysis code
 * reviews.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestMetadata implements SdkPojo, Serializable, ToCopyableBuilder<RequestMetadata.Builder, RequestMetadata> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(RequestMetadata::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> REQUESTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Requester").getter(getter(RequestMetadata::requester)).setter(setter(Builder::requester))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requester").build()).build();

    private static final SdkField<EventInfo> EVENT_INFO_FIELD = SdkField.<EventInfo> builder(MarshallingType.SDK_POJO)
            .memberName("EventInfo").getter(getter(RequestMetadata::eventInfo)).setter(setter(Builder::eventInfo))
            .constructor(EventInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventInfo").build()).build();

    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorName").getter(getter(RequestMetadata::vendorNameAsString)).setter(setter(Builder::vendorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            REQUESTER_FIELD, EVENT_INFO_FIELD, VENDOR_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String requestId;

    private final String requester;

    private final EventInfo eventInfo;

    private final String vendorName;

    private RequestMetadata(BuilderImpl builder) {
        this.requestId = builder.requestId;
        this.requester = builder.requester;
        this.eventInfo = builder.eventInfo;
        this.vendorName = builder.vendorName;
    }

    /**
     * <p>
     * The ID of the request. This is required for a pull request code review.
     * </p>
     * 
     * @return The ID of the request. This is required for a pull request code review.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * An identifier, such as a name or account ID, that is associated with the requester. The <code>Requester</code> is
     * used to capture the <code>author/actor</code> name of the event request.
     * </p>
     * 
     * @return An identifier, such as a name or account ID, that is associated with the requester. The
     *         <code>Requester</code> is used to capture the <code>author/actor</code> name of the event request.
     */
    public final String requester() {
        return requester;
    }

    /**
     * <p>
     * Information about the event associated with a code review.
     * </p>
     * 
     * @return Information about the event associated with a code review.
     */
    public final EventInfo eventInfo() {
        return eventInfo;
    }

    /**
     * <p>
     * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For example, if
     * code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts from a GitHub
     * repository, then the repository association's <code>ProviderType</code> is <code>S3Bucket</code> and the CI/CD
     * repository vendor name is GitHub. For more information, see the definition for <code>ProviderType</code> in <a
     * href
     * ="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation
     * </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendorName} will
     * return {@link VendorName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vendorNameAsString}.
     * </p>
     * 
     * @return The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For
     *         example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts
     *         from a GitHub repository, then the repository association's <code>ProviderType</code> is
     *         <code>S3Bucket</code> and the CI/CD repository vendor name is GitHub. For more information, see the
     *         definition for <code>ProviderType</code> in <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"
     *         >RepositoryAssociation</a>.
     * @see VendorName
     */
    public final VendorName vendorName() {
        return VendorName.fromValue(vendorName);
    }

    /**
     * <p>
     * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For example, if
     * code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts from a GitHub
     * repository, then the repository association's <code>ProviderType</code> is <code>S3Bucket</code> and the CI/CD
     * repository vendor name is GitHub. For more information, see the definition for <code>ProviderType</code> in <a
     * href
     * ="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation
     * </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendorName} will
     * return {@link VendorName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vendorNameAsString}.
     * </p>
     * 
     * @return The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For
     *         example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts
     *         from a GitHub repository, then the repository association's <code>ProviderType</code> is
     *         <code>S3Bucket</code> and the CI/CD repository vendor name is GitHub. For more information, see the
     *         definition for <code>ProviderType</code> in <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"
     *         >RepositoryAssociation</a>.
     * @see VendorName
     */
    public final String vendorNameAsString() {
        return vendorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(requester());
        hashCode = 31 * hashCode + Objects.hashCode(eventInfo());
        hashCode = 31 * hashCode + Objects.hashCode(vendorNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestMetadata)) {
            return false;
        }
        RequestMetadata other = (RequestMetadata) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(requester(), other.requester())
                && Objects.equals(eventInfo(), other.eventInfo())
                && Objects.equals(vendorNameAsString(), other.vendorNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestMetadata").add("RequestId", requestId()).add("Requester", requester())
                .add("EventInfo", eventInfo()).add("VendorName", vendorNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Requester":
            return Optional.ofNullable(clazz.cast(requester()));
        case "EventInfo":
            return Optional.ofNullable(clazz.cast(eventInfo()));
        case "VendorName":
            return Optional.ofNullable(clazz.cast(vendorNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Requester", REQUESTER_FIELD);
        map.put("EventInfo", EVENT_INFO_FIELD);
        map.put("VendorName", VENDOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestMetadata, T> g) {
        return obj -> g.apply((RequestMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestMetadata> {
        /**
         * <p>
         * The ID of the request. This is required for a pull request code review.
         * </p>
         * 
         * @param requestId
         *        The ID of the request. This is required for a pull request code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * An identifier, such as a name or account ID, that is associated with the requester. The
         * <code>Requester</code> is used to capture the <code>author/actor</code> name of the event request.
         * </p>
         * 
         * @param requester
         *        An identifier, such as a name or account ID, that is associated with the requester. The
         *        <code>Requester</code> is used to capture the <code>author/actor</code> name of the event request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requester(String requester);

        /**
         * <p>
         * Information about the event associated with a code review.
         * </p>
         * 
         * @param eventInfo
         *        Information about the event associated with a code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventInfo(EventInfo eventInfo);

        /**
         * <p>
         * Information about the event associated with a code review.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventInfo.Builder} avoiding the need to
         * create one manually via {@link EventInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #eventInfo(EventInfo)}.
         * 
         * @param eventInfo
         *        a consumer that will call methods on {@link EventInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventInfo(EventInfo)
         */
        default Builder eventInfo(Consumer<EventInfo.Builder> eventInfo) {
            return eventInfo(EventInfo.builder().applyMutation(eventInfo).build());
        }

        /**
         * <p>
         * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For example,
         * if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts from a GitHub
         * repository, then the repository association's <code>ProviderType</code> is <code>S3Bucket</code> and the
         * CI/CD repository vendor name is GitHub. For more information, see the definition for
         * <code>ProviderType</code> in <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"
         * >RepositoryAssociation</a>.
         * </p>
         * 
         * @param vendorName
         *        The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For
         *        example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts
         *        from a GitHub repository, then the repository association's <code>ProviderType</code> is
         *        <code>S3Bucket</code> and the CI/CD repository vendor name is GitHub. For more information, see the
         *        definition for <code>ProviderType</code> in <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"
         *        >RepositoryAssociation</a>.
         * @see VendorName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VendorName
         */
        Builder vendorName(String vendorName);

        /**
         * <p>
         * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For example,
         * if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts from a GitHub
         * repository, then the repository association's <code>ProviderType</code> is <code>S3Bucket</code> and the
         * CI/CD repository vendor name is GitHub. For more information, see the definition for
         * <code>ProviderType</code> in <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"
         * >RepositoryAssociation</a>.
         * </p>
         * 
         * @param vendorName
         *        The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For
         *        example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts
         *        from a GitHub repository, then the repository association's <code>ProviderType</code> is
         *        <code>S3Bucket</code> and the CI/CD repository vendor name is GitHub. For more information, see the
         *        definition for <code>ProviderType</code> in <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"
         *        >RepositoryAssociation</a>.
         * @see VendorName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VendorName
         */
        Builder vendorName(VendorName vendorName);
    }

    static final class BuilderImpl implements Builder {
        private String requestId;

        private String requester;

        private EventInfo eventInfo;

        private String vendorName;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestMetadata model) {
            requestId(model.requestId);
            requester(model.requester);
            eventInfo(model.eventInfo);
            vendorName(model.vendorName);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getRequester() {
            return requester;
        }

        public final void setRequester(String requester) {
            this.requester = requester;
        }

        @Override
        public final Builder requester(String requester) {
            this.requester = requester;
            return this;
        }

        public final EventInfo.Builder getEventInfo() {
            return eventInfo != null ? eventInfo.toBuilder() : null;
        }

        public final void setEventInfo(EventInfo.BuilderImpl eventInfo) {
            this.eventInfo = eventInfo != null ? eventInfo.build() : null;
        }

        @Override
        public final Builder eventInfo(EventInfo eventInfo) {
            this.eventInfo = eventInfo;
            return this;
        }

        public final String getVendorName() {
            return vendorName;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        @Override
        public final Builder vendorName(VendorName vendorName) {
            this.vendorName(vendorName == null ? null : vendorName.toString());
            return this;
        }

        @Override
        public RequestMetadata build() {
            return new RequestMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
