/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a third-party source repository connected to CodeGuru Reviewer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThirdPartySourceRepository implements SdkPojo, Serializable,
        ToCopyableBuilder<ThirdPartySourceRepository.Builder, ThirdPartySourceRepository> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ThirdPartySourceRepository::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(ThirdPartySourceRepository::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(ThirdPartySourceRepository::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONNECTION_ARN_FIELD, OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String connectionArn;

    private final String owner;

    private ThirdPartySourceRepository(BuilderImpl builder) {
        this.name = builder.name;
        this.connectionArn = builder.connectionArn;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The name of the third party source repository.
     * </p>
     * 
     * @return The name of the third party source repository.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
     * <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">Connection</a> in
     * the <i>Amazon Web Services CodeStar Connections API Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
     *         <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html"
     *         >Connection</a> in the <i>Amazon Web Services CodeStar Connections API Reference</i>.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository, this is the username for
     * the account that owns the repository. For an S3 repository, this can be the username or Amazon Web Services
     * account ID
     * </p>
     * 
     * @return The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository, this is the
     *         username for the account that owns the repository. For an S3 repository, this can be the username or
     *         Amazon Web Services account ID
     */
    public final String owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartySourceRepository)) {
            return false;
        }
        ThirdPartySourceRepository other = (ThirdPartySourceRepository) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThirdPartySourceRepository").add("Name", name()).add("ConnectionArn", connectionArn())
                .add("Owner", owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("Owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThirdPartySourceRepository, T> g) {
        return obj -> g.apply((ThirdPartySourceRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThirdPartySourceRepository> {
        /**
         * <p>
         * The name of the third party source repository.
         * </p>
         * 
         * @param name
         *        The name of the third party source repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html"
         * >Connection</a> in the <i>Amazon Web Services CodeStar Connections API Reference</i>.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format
         *        is <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html"
         *        >Connection</a> in the <i>Amazon Web Services CodeStar Connections API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository, this is the username
         * for the account that owns the repository. For an S3 repository, this can be the username or Amazon Web
         * Services account ID
         * </p>
         * 
         * @param owner
         *        The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository, this is the
         *        username for the account that owns the repository. For an S3 repository, this can be the username or
         *        Amazon Web Services account ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String connectionArn;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ThirdPartySourceRepository model) {
            name(model.name);
            connectionArn(model.connectionArn);
            owner(model.owner);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public ThirdPartySourceRepository build() {
            return new ThirdPartySourceRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
